/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.geometric;

import com.amazon.redshift.geometric.RedshiftPoint;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftObject;
import com.amazon.redshift.util.RedshiftState;
import com.amazon.redshift.util.RedshiftTokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class RedshiftLseg
extends RedshiftObject
implements Serializable,
Cloneable {
    public RedshiftPoint[] point = new RedshiftPoint[2];

    public RedshiftLseg(double x1, double y1, double x2, double y2) {
        this(new RedshiftPoint(x1, y1), new RedshiftPoint(x2, y2));
    }

    public RedshiftLseg(RedshiftPoint p1, RedshiftPoint p2) {
        this();
        this.point[0] = p1;
        this.point[1] = p2;
    }

    public RedshiftLseg(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public RedshiftLseg() {
        this.setType("lseg");
    }

    @Override
    public void setValue(String s) throws SQLException {
        RedshiftTokenizer t = new RedshiftTokenizer(RedshiftTokenizer.removeBox(s), ',');
        if (t.getSize() != 2) {
            throw new RedshiftException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s), RedshiftState.DATA_TYPE_MISMATCH);
        }
        this.point[0] = new RedshiftPoint(t.getToken(0));
        this.point[1] = new RedshiftPoint(t.getToken(1));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RedshiftLseg) {
            RedshiftLseg p = (RedshiftLseg)obj;
            return p.point[0].equals(this.point[0]) && p.point[1].equals(this.point[1]) || p.point[0].equals(this.point[1]) && p.point[1].equals(this.point[0]);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.point[0].hashCode() ^ this.point[1].hashCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RedshiftLseg newRSlseg = (RedshiftLseg)super.clone();
        if (newRSlseg.point != null) {
            newRSlseg.point = (RedshiftPoint[])newRSlseg.point.clone();
            for (int i = 0; i < newRSlseg.point.length; ++i) {
                if (newRSlseg.point[i] == null) continue;
                newRSlseg.point[i] = (RedshiftPoint)newRSlseg.point[i].clone();
            }
        }
        return newRSlseg;
    }

    @Override
    public String getValue() {
        return "[" + this.point[0] + "," + this.point[1] + "]";
    }
}

