/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.debug.action;

import java.util.Map;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.debug.action.ActionDebugLevel;
import org.apache.hop.debug.action.ActionDebugLevelDialog;
import org.apache.hop.debug.util.DebugLevelUtil;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.workflow.extension.HopGuiWorkflowGraphExtension;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;

@ExtensionPoint(id="EditActionDebugLevelExtensionPoint", extensionPointId="WorkflowGraphMouseUp", description="Edit the custom action debug level with a single click")
public class EditActionDebugLevelExtensionPoint
implements IExtensionPoint<HopGuiWorkflowGraphExtension> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, HopGuiWorkflowGraphExtension ext) throws HopException {
        try {
            if (ext.getAreaOwner() == null || ext.getAreaOwner().getOwner() == null) {
                return;
            }
            if (!(ext.getAreaOwner().getOwner() instanceof ActionDebugLevel)) {
                return;
            }
            ActionDebugLevel debugLevel = (ActionDebugLevel)ext.getAreaOwner().getOwner();
            ActionDebugLevelDialog dialog = new ActionDebugLevelDialog(HopGui.getInstance().getShell(), debugLevel);
            if (dialog.open()) {
                WorkflowMeta workflowMeta = ext.getWorkflowGraph().getWorkflowMeta();
                ActionMeta actionCopy = (ActionMeta)ext.getAreaOwner().getParent();
                DebugLevelUtil.storeActionDebugLevel((Map)workflowMeta.getAttributesMap().get("debug_plugin"), actionCopy.getName(), debugLevel);
                ext.getWorkflowGraph().redraw();
            }
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), "Error", "Error editing action debug level", e);
        }
    }
}

