/*
 * Decompiled with CFR 0.152.
 */
package io.crate.shade.org.postgresql.jdbc;

import io.crate.shade.org.postgresql.Driver;
import io.crate.shade.org.postgresql.core.BaseStatement;
import io.crate.shade.org.postgresql.core.Field;
import io.crate.shade.org.postgresql.core.ServerVersion;
import io.crate.shade.org.postgresql.jdbc.CrateVersion;
import io.crate.shade.org.postgresql.jdbc.PgConnection;
import io.crate.shade.org.postgresql.util.GT;
import io.crate.shade.org.postgresql.util.JdbcBlackHole;
import io.crate.shade.org.postgresql.util.PSQLException;
import io.crate.shade.org.postgresql.util.PSQLState;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PgDatabaseMetaData
implements DatabaseMetaData {
    private String keywords;
    protected final PgConnection connection;
    private int NAMEDATALEN = 0;
    private int INDEX_MAX_KEYS = 0;
    private static final Map<String, String> REFERENCE_GENERATIONS;
    private static final Map<String, Map<String, String>> tableTypeClauses;

    public PgDatabaseMetaData(PgConnection conn) {
        this.connection = conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMaxIndexKeys() throws SQLException {
        if (this.INDEX_MAX_KEYS == 0) {
            String sql = "SELECT setting FROM pg_catalog.pg_settings WHERE name='max_index_keys'";
            Statement stmt = this.connection.createStatement();
            ResultSet rs = null;
            try {
                rs = stmt.executeQuery(sql);
                if (!rs.next()) {
                    stmt.close();
                    throw new PSQLException(GT.tr("Unable to determine a value for MaxIndexKeys due to missing system catalog data.", new Object[0]), PSQLState.UNEXPECTED_ERROR);
                }
                this.INDEX_MAX_KEYS = rs.getInt(1);
            }
            finally {
                JdbcBlackHole.close(rs);
                JdbcBlackHole.close(stmt);
            }
        }
        return this.INDEX_MAX_KEYS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMaxNameLength() throws SQLException {
        if (this.NAMEDATALEN == 0) {
            String sql = "SELECT t.typlen FROM pg_catalog.pg_type t, pg_catalog.pg_namespace n WHERE t.typnamespace=n.oid AND t.typname='name' AND n.nspname='pg_catalog'";
            Statement stmt = this.connection.createStatement();
            ResultSet rs = null;
            try {
                rs = stmt.executeQuery(sql);
                if (!rs.next()) {
                    throw new PSQLException(GT.tr("Unable to find name datatype in the system catalogs.", new Object[0]), PSQLState.UNEXPECTED_ERROR);
                }
                this.NAMEDATALEN = rs.getInt("typlen");
            }
            finally {
                JdbcBlackHole.close(rs);
                JdbcBlackHole.close(stmt);
            }
        }
        return this.NAMEDATALEN - 1;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.connection.getUserName();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "Crate";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.connection.getDBVersionNumber();
    }

    @Override
    public String getDriverName() {
        return "PostgreSQL JDBC Driver";
    }

    @Override
    public String getDriverVersion() {
        return "42.2.5";
    }

    @Override
    public int getDriverMajorVersion() {
        return 42;
    }

    @Override
    public int getDriverMinorVersion() {
        return 2;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        this.connection.checkClosed();
        return "alias,all,alter,analyzer,and,any,array,as,asc,always,array,add,bernoulli,between,blob,boolean,by,byte,begin,case,cast,catalogs,char_filters,clustered,coalesce,columns,constraint,copy,create,cross,current,current_date,current_time,current_timestamp,current_schema, column,date,day,delete,desc,describe,directory,distinct,distributed,double,drop,dynamic,delete,duplicate,default,else,end,escape,except,exists,explain,extends,extract,false,first,float,following,for,format,from,full,fulltext,functions,graphviz,group,geo_point,geo_shape,global,generated,having,hour,if,ignored,in,index,inner,insert,int,integer,intersect,interval,into,ip,is,isolation,join,last,left,like,limit,logical,long,local,level,materialized,minute,month,match,natural,not,null,nulls,object,off,offset,on,or,order,outer,over,optmize,only,partition,partitioned,partitions,plain,preceding,primary_key,range,recursive,refresh,reset,right,row,rows,repository,restore,schemas,second,select,set,shards,short,show,some,stratify,strict,string_type,substring,system,select,snapshot,session,table,tables,tablesample,text,then,time,timestamp,to,tokenizer,token_filters,true,type,try_cast,transaction,tablesample,transient,unbounded,union,update,using,values,view,when,where,with,year";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "abs,ceil,floor,ln,log,random,round,sqrt,sin,asin,cos,acos,tan,atan";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "concat,format,substr,char_length,bit_length,octet_length,lower,upper";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "date_trunc,extract,date_format";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "function";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return this.getMaxIndexKeys();
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 1600;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 8192;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0x40000000;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        if (this.connection.isStrict()) {
            return 0;
        }
        return 2;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return !this.connection.isStrict();
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        if (this.connection.isStrict()) {
            return level == 0;
        }
        switch (level) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return !this.connection.isStrict();
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    protected String escapeQuotes(String s) throws SQLException {
        StringBuilder sb = new StringBuilder();
        if (!this.connection.getStandardConformingStrings()) {
            sb.append("E");
        }
        sb.append("'");
        sb.append(this.connection.escapeString(s));
        sb.append("'");
        return sb.toString();
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return this.emptyResult(PgDatabaseMetaData.col("PROCEDURE_CAT"), PgDatabaseMetaData.col("PROCEDURE_SCHEM"), PgDatabaseMetaData.col("PROCEDURE_NAME"), PgDatabaseMetaData.col("NUM_INPUT_PARAMS", 23), PgDatabaseMetaData.col("NUM_OUTPUT_PARAMS", 23), PgDatabaseMetaData.col("NUM_RESULT_SETS", 23), PgDatabaseMetaData.col("REMARKS"), PgDatabaseMetaData.col("PROCEDURE_TYPE", 21), PgDatabaseMetaData.col("SPECIFIC_NAME"));
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return this.emptyResult(PgDatabaseMetaData.col("PROCEDURE_CAT"), PgDatabaseMetaData.col("PROCEDURE_SCHEM"), PgDatabaseMetaData.col("PROCEDURE_NAME"), PgDatabaseMetaData.col("COLUMN_NAME"), PgDatabaseMetaData.col("COLUMN_TYPE", 21), PgDatabaseMetaData.col("DATA_TYPE"), PgDatabaseMetaData.col("TYPE_NAME"), PgDatabaseMetaData.col("PRECISION", 23), PgDatabaseMetaData.col("LENGTH", 23), PgDatabaseMetaData.col("SCALE", 21), PgDatabaseMetaData.col("RADIX", 21), PgDatabaseMetaData.col("NULLABLE", 21), PgDatabaseMetaData.col("REMARKS"), PgDatabaseMetaData.col("COLUMN_DEF"), PgDatabaseMetaData.col("SQL_DATA_TYPE", 23), PgDatabaseMetaData.col("SQL_DATETIME_SUB", 23), PgDatabaseMetaData.col("CHAR_OCTET_LENGTH", 23), PgDatabaseMetaData.col("ORDINAL_POSITION", 23), PgDatabaseMetaData.col("IS_NULLANLE"), PgDatabaseMetaData.col("SPECIFIC_NAME"));
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        Field[] fields = new Field[]{new Field("TABLE_CAT", 1043), new Field("TABLE_SCHEM", 1043), new Field("TABLE_NAME", 1043), new Field("TABLE_TYPE", 1043), new Field("REMARKS", 1043), new Field("TYPE_CAT", 1043), new Field("TYPE_SCHEM", 1043), new Field("TYPE_NAME", 1043), new Field("SELF_REFERENCING_COL_NAME", 1043), new Field("REF_GENERATION", 1043)};
        String schemaName = this.getCrateSchemaName();
        String infoSchemaTableWhereClause = this.createInfoSchemaTableWhereClause(schemaName, schemaPattern, tableNamePattern, null).toString();
        StringBuilder stmt = this.getTablesStatement(schemaName, infoSchemaTableWhereClause);
        ResultSet rs = this.connection.createStatement().executeQuery(stmt.toString());
        ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
        while (rs.next()) {
            byte[][] tuple = new byte[fields.length][];
            String schema = rs.getString(schemaName);
            tuple[1] = schema.getBytes();
            tuple[2] = rs.getBytes("table_name");
            tuple[4] = this.connection.encodeString("");
            tuple[5] = null;
            tuple[6] = null;
            tuple[7] = null;
            if (this.getCrateVersion().before("2.0.0")) {
                tuple[0] = null;
                tuple[3] = "sys".equals(schema) || "information_schema".equals(schema) ? this.connection.encodeString("SYSTEM TABLE") : this.connection.encodeString("TABLE");
                tuple[8] = this.connection.encodeString("_id");
                tuple[9] = this.connection.encodeString("SYSTEM");
            } else {
                tuple[0] = rs.getBytes("table_catalog");
                tuple[3] = rs.getBytes("table_type");
                tuple[8] = rs.getBytes("self_referencing_column_name");
                tuple[9] = this.connection.encodeString(PgDatabaseMetaData.getReferenceGeneration(rs.getString("reference_generation")));
            }
            tuples.add(tuple);
        }
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fields, tuples);
    }

    private StringBuilder getTablesStatement(String schemaName, String infoSchemaTableWhereClause) throws SQLException {
        StringBuilder builder = new StringBuilder("SELECT ").append(schemaName).append(", table_name");
        if (this.getCrateVersion().compareTo("2.0.0") >= 0) {
            builder.append(", table_catalog, table_type, self_referencing_column_name, reference_generation");
        }
        builder.append(" FROM information_schema.tables").append(infoSchemaTableWhereClause);
        if (this.getCrateVersion().compareTo("2.0.0") >= 0) {
            builder.append("AND table_type = 'BASE TABLE'");
        }
        builder.append(" ORDER BY ").append(schemaName).append(", table_name");
        return builder;
    }

    private static String getReferenceGeneration(String referenceGeneration) {
        if (REFERENCE_GENERATIONS.containsKey(referenceGeneration)) {
            return REFERENCE_GENERATIONS.get(referenceGeneration);
        }
        return null;
    }

    private String getCrateSchemaName() throws SQLException {
        return this.getCrateVersion().before("0.57.0") ? "schema_name" : "table_schema";
    }

    public CrateVersion getCrateVersion() throws SQLException {
        ResultSet rs = this.connection.createStatement().executeQuery("select version['number'] as version from sys.nodes limit 1");
        if (rs.next()) {
            return new CrateVersion(rs.getString("version"));
        }
        throw new SQLException("unable to fetch Crate version");
    }

    private StringBuilder createInfoSchemaTableWhereClause(String schemaColumnName, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        StringBuilder where = new StringBuilder(" where ");
        if (schemaPattern == null) {
            where.append(schemaColumnName).append(" like '%'");
        } else if (schemaPattern.equals("")) {
            where.append(schemaColumnName).append(" is null");
        } else {
            where.append(schemaColumnName).append(" like '").append(this.connection.escapeString(schemaPattern)).append("'");
        }
        if (columnNamePattern != null) {
            where.append(" and column_name like '").append(this.connection.escapeString(columnNamePattern)).append("'");
        }
        if (tableNamePattern != null) {
            where.append(" and table_name like '").append(this.connection.escapeString(tableNamePattern)).append("'");
        }
        return where;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        StringBuilder stmt = new StringBuilder("select schema_name from information_schema.schemata");
        if (schemaPattern != null) {
            stmt.append(" where schema_name like '").append(this.connection.escapeString(schemaPattern)).append("'");
        }
        stmt.append(" order by schema_name");
        ResultSet rs = this.connection.createStatement().executeQuery(stmt.toString());
        Field[] fields = new Field[]{new Field("TABLE_SCHEM", 1043), new Field("TABLE_CAT", 1043)};
        ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
        while (rs.next()) {
            tuples.add(new byte[][]{rs.getBytes("schema_name"), null});
        }
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fields, tuples);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return this.emptyResult(PgDatabaseMetaData.col("TABLE_CAT"));
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        Field[] f = new Field[1];
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        f[0] = new Field("TABLE_TYPE", 1043);
        v.add(new byte[][]{this.connection.encodeString("SYSTEM TABLE")});
        v.add(new byte[][]{this.connection.encodeString("TABLE")});
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(f, v);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        Field[] fields = new Field[]{new Field("TABLE_CAT", 1043), new Field("TABLE_SCHEM", 1043), new Field("TABLE_NAME", 1043), new Field("COLUMN_NAME", 1043), new Field("DATA_TYPE", 21), new Field("TYPE_NAME", 1043), new Field("COLUMN_SIZE", 23), new Field("BUFFER_LENGTH", 1043), new Field("DECIMAL_DIGITS", 23), new Field("NUM_PREC_RADIX", 23), new Field("NULLABLE", 23), new Field("REMARKS", 1043), new Field("COLUMN_DEF", 1043), new Field("SQL_DATA_TYPE", 23), new Field("SQL_DATETIME_SUB", 23), new Field("CHAR_OCTET_LENGTH", 1043), new Field("ORDINAL_POSITION", 23), new Field("IS_NULLABLE", 1043), new Field("SCOPE_CATLOG", 1043), new Field("SCOPE_SCHEMA", 1043), new Field("SCOPE_TABLE", 1043), new Field("SOURCE_DATA_TYPE", 21), new Field("IS_AUTOINCREMENT", 1043), new Field("IS_GENERATEDCOLUMN", 1043)};
        String schemaName = this.getCrateSchemaName();
        String infoSchemaTableWhereClause = this.createInfoSchemaTableWhereClause(schemaName, schemaPattern, tableNamePattern, columnNamePattern).toString();
        String stmt = this.getColumnsStatement(schemaName, infoSchemaTableWhereClause);
        ResultSet rs = this.connection.createStatement().executeQuery(stmt);
        ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
        while (rs.next()) {
            byte[][] tuple = new byte[fields.length][];
            tuple[1] = rs.getBytes(schemaName);
            tuple[2] = rs.getBytes("table_name");
            tuple[3] = rs.getBytes("column_name");
            String sqlType = rs.getString("data_type");
            tuple[4] = this.connection.encodeString(Integer.toString(this.sqlTypeOfCrateType(sqlType)));
            tuple[5] = sqlType.getBytes();
            tuple[6] = null;
            tuple[7] = null;
            tuple[10] = this.connection.encodeString(Integer.toString(1));
            tuple[11] = null;
            tuple[13] = null;
            tuple[14] = null;
            tuple[16] = rs.getBytes("ordinal_position");
            tuple[18] = null;
            tuple[19] = null;
            tuple[20] = null;
            tuple[21] = null;
            tuple[22] = this.connection.encodeString("NO");
            if (this.getCrateVersion().before("2.0.0")) {
                tuple[0] = null;
                tuple[8] = null;
                tuple[9] = this.connection.encodeString("10");
                tuple[12] = null;
                tuple[15] = null;
                tuple[17] = this.connection.encodeString("YES");
                tuple[23] = this.connection.encodeString("NO");
            } else {
                tuple[0] = rs.getBytes("table_catalog");
                tuple[8] = rs.getBytes("numeric_precision");
                tuple[9] = rs.getBytes("numeric_precision_radix");
                tuple[12] = rs.getBytes("column_default");
                tuple[15] = rs.getBytes("character_octet_length");
                tuple[17] = this.connection.encodeString(rs.getBoolean("is_nullable") ? "YES" : "NO");
                tuple[23] = this.getCrateVersion().before("4.0.0") ? this.connection.encodeString(rs.getBoolean("is_generated") ? "YES" : "NO") : rs.getBytes("is_generated");
            }
            tuples.add(tuple);
        }
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fields, tuples);
    }

    private String getColumnsStatement(String schemaName, String infoSchemaTableWhereClause) throws SQLException {
        String select = this.getCrateVersion().before("2.0.0") ? "SELECT " + schemaName + ", table_name, column_name, data_type, ordinal_position" : "SELECT " + schemaName + ", table_name, column_name, data_type, ordinal_position, table_catalog, numeric_precision, numeric_precision_radix, column_default, character_octet_length, is_nullable,is_generated";
        return select + " FROM information_schema.columns " + infoSchemaTableWhereClause + " AND column_name NOT LIKE '%[%]' AND column_name NOT LIKE '%.%' ORDER BY " + schemaName + ", table_name, ordinal_position";
    }

    private int sqlTypeOfCrateType(String dataType) {
        switch (dataType) {
            case "byte": {
                return -6;
            }
            case "long": {
                return -5;
            }
            case "integer": {
                return 4;
            }
            case "short": {
                return 5;
            }
            case "float": {
                return 7;
            }
            case "double": {
                return 8;
            }
            case "string": 
            case "ip": {
                return 12;
            }
            case "boolean": {
                return 16;
            }
            case "timestamp": {
                return 93;
            }
            case "object": {
                return 2002;
            }
            case "string_array": 
            case "ip_array": 
            case "integer_array": 
            case "long_array": 
            case "short_array": 
            case "byte_array": 
            case "float_array": 
            case "double_array": 
            case "timestamp_array": 
            case "object_array": {
                return 2003;
            }
        }
        return 1111;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return this.emptyResult(PgDatabaseMetaData.col("TABLE_CAT"), PgDatabaseMetaData.col("TABLE_SCHEM"), PgDatabaseMetaData.col("TABLE_NAME"), PgDatabaseMetaData.col("COLUMN_NAME"), PgDatabaseMetaData.col("GRANTOR"), PgDatabaseMetaData.col("GRANTEE"), PgDatabaseMetaData.col("PRIVILEGE"), PgDatabaseMetaData.col("IS_GRANTABLE"));
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.emptyResult(PgDatabaseMetaData.col("TABLE_CAT"), PgDatabaseMetaData.col("TABLE_SCHEM"), PgDatabaseMetaData.col("TABLE_NAME"), PgDatabaseMetaData.col("GRANTOR"), PgDatabaseMetaData.col("GRANTEE"), PgDatabaseMetaData.col("PRIVILEGE"), PgDatabaseMetaData.col("IS_GRANTABLE"));
    }

    private static List<String> parseACLArray(String aclString) {
        int i;
        ArrayList<String> acls = new ArrayList<String>();
        if (aclString == null || aclString.isEmpty()) {
            return acls;
        }
        boolean inQuotes = false;
        int beginIndex = 1;
        int prevChar = 32;
        for (i = beginIndex; i < aclString.length(); ++i) {
            char c = aclString.charAt(i);
            if (c == '\"' && prevChar != 92) {
                inQuotes = !inQuotes;
            } else if (c == ',' && !inQuotes) {
                acls.add(aclString.substring(beginIndex, i));
                beginIndex = i + 1;
            }
            prevChar = c;
        }
        acls.add(aclString.substring(beginIndex, aclString.length() - 1));
        for (i = 0; i < acls.size(); ++i) {
            String acl = (String)acls.get(i);
            if (!acl.startsWith("\"") || !acl.endsWith("\"")) continue;
            acl = acl.substring(1, acl.length() - 1);
            acls.set(i, acl);
        }
        return acls;
    }

    private static void addACLPrivileges(String acl, Map<String, Map<String, List<String[]>>> privileges) {
        String privs;
        int equalIndex = acl.lastIndexOf("=");
        int slashIndex = acl.lastIndexOf("/");
        if (equalIndex == -1) {
            return;
        }
        String user = acl.substring(0, equalIndex);
        String grantor = null;
        if (user.isEmpty()) {
            user = "PUBLIC";
        }
        if (slashIndex != -1) {
            privs = acl.substring(equalIndex + 1, slashIndex);
            grantor = acl.substring(slashIndex + 1, acl.length());
        } else {
            privs = acl.substring(equalIndex + 1, acl.length());
        }
        for (int i = 0; i < privs.length(); ++i) {
            List<String[]> permissionByGrantor;
            String sqlpriv;
            char c = privs.charAt(i);
            if (c == '*') continue;
            String grantable = i < privs.length() - 1 && privs.charAt(i + 1) == '*' ? "YES" : "NO";
            switch (c) {
                case 'a': {
                    sqlpriv = "INSERT";
                    break;
                }
                case 'p': 
                case 'r': {
                    sqlpriv = "SELECT";
                    break;
                }
                case 'w': {
                    sqlpriv = "UPDATE";
                    break;
                }
                case 'd': {
                    sqlpriv = "DELETE";
                    break;
                }
                case 'D': {
                    sqlpriv = "TRUNCATE";
                    break;
                }
                case 'R': {
                    sqlpriv = "RULE";
                    break;
                }
                case 'x': {
                    sqlpriv = "REFERENCES";
                    break;
                }
                case 't': {
                    sqlpriv = "TRIGGER";
                    break;
                }
                case 'X': {
                    sqlpriv = "EXECUTE";
                    break;
                }
                case 'U': {
                    sqlpriv = "USAGE";
                    break;
                }
                case 'C': {
                    sqlpriv = "CREATE";
                    break;
                }
                case 'T': {
                    sqlpriv = "CREATE TEMP";
                    break;
                }
                default: {
                    sqlpriv = "UNKNOWN";
                }
            }
            Map<String, List<String[]>> usersWithPermission = privileges.get(sqlpriv);
            String[] grant = new String[]{grantor, grantable};
            if (usersWithPermission == null) {
                usersWithPermission = new HashMap<String, List<String[]>>();
                permissionByGrantor = new ArrayList<String[]>();
                permissionByGrantor.add(grant);
                usersWithPermission.put(user, permissionByGrantor);
                privileges.put(sqlpriv, usersWithPermission);
                continue;
            }
            permissionByGrantor = usersWithPermission.get(user);
            if (permissionByGrantor == null) {
                permissionByGrantor = new ArrayList<String[]>();
                permissionByGrantor.add(grant);
                usersWithPermission.put(user, permissionByGrantor);
                continue;
            }
            permissionByGrantor.add(grant);
        }
    }

    public Map<String, Map<String, List<String[]>>> parseACL(String aclArray, String owner) {
        if (aclArray == null) {
            String perms = this.connection.haveMinimumServerVersion(ServerVersion.v8_4) ? "arwdDxt" : "arwdxt";
            aclArray = "{" + owner + "=" + perms + "/" + owner + "}";
        }
        List<String> acls = PgDatabaseMetaData.parseACLArray(aclArray);
        HashMap<String, Map<String, List<String[]>>> privileges = new HashMap<String, Map<String, List<String[]>>>();
        for (String acl : acls) {
            PgDatabaseMetaData.addACLPrivileges(acl, privileges);
        }
        return privileges;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return this.emptyResult(PgDatabaseMetaData.col("SCOPE"), PgDatabaseMetaData.col("COLUMN_NAME"), PgDatabaseMetaData.col("DATA_TYPE"), PgDatabaseMetaData.col("TYPE_NAME"), PgDatabaseMetaData.col("COLUMN_SIZE"), PgDatabaseMetaData.col("BUFFER_LENGTH"), PgDatabaseMetaData.col("DECIMAL_DIGITS"), PgDatabaseMetaData.col("PSEUDO_COLUMNS"));
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return this.emptyResult(PgDatabaseMetaData.col("SCOPE", 21), PgDatabaseMetaData.col("COLUMN_NAME"), PgDatabaseMetaData.col("DATA_TYPE", 23), PgDatabaseMetaData.col("TYPE_NAME"), PgDatabaseMetaData.col("COLUMN_SIZE", 23), PgDatabaseMetaData.col("BUFFER_LENGTH", 23), PgDatabaseMetaData.col("DECIMAL_DIGITS", 21), PgDatabaseMetaData.col("PSEUDO_COLUMN", 21));
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        CrateVersion version = this.getCrateVersion();
        if (version.before("2.3.0")) {
            Field[] fields = new Field[]{new Field("TABLE_CAT", 1043), new Field("TABLE_SCHEM", 1043), new Field("TABLE_NAME", 1043), new Field("COLUMN_NAME", 1043), new Field("KEY_SEQ", 1043), new Field("PK_NAME", 1043)};
            String schemaName = this.getCrateSchemaName();
            StringBuilder sql = new StringBuilder("SELECT NULL AS TABLE_CAT,   " + schemaName + " AS TABLE_SCHEM,   table_name as TABLE_NAME,   constraint_name AS COLUMN_NAMES,   0 AS KEY_SEQ,   NULL AS PK_NAME FROM information_schema.table_constraints WHERE '_id' != ANY(constraint_name)   AND table_name = '" + this.connection.escapeString(table) + "' ");
            if (schema != null) {
                sql.append("  AND " + schemaName + "= '" + this.connection.escapeString(schema) + "' ");
            }
            sql.append("ORDER BY TABLE_SCHEM, TABLE_NAME");
            ResultSet rs = this.connection.createStatement().executeQuery(sql.toString());
            ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
            while (rs.next()) {
                byte[] tableCat = rs.getBytes(1);
                byte[] tableSchem = rs.getBytes(2);
                byte[] tableName = rs.getBytes(3);
                byte[] pkName = rs.getBytes(6);
                String[] pkColumsn = (String[])rs.getArray(4).getArray();
                for (int i = 0; i < pkColumsn.length; ++i) {
                    byte[][] tuple = new byte[fields.length][];
                    tuple[0] = tableCat;
                    tuple[1] = tableSchem;
                    tuple[2] = tableName;
                    tuple[3] = this.connection.encodeString(pkColumsn[i]);
                    tuple[4] = this.connection.encodeString(Integer.toString(i));
                    tuple[5] = pkName;
                    tuples.add(tuple);
                }
            }
            return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fields, tuples);
        }
        String schemaField = "table_catalog";
        if (version.after("3.0.0")) {
            schemaField = "table_schema";
        }
        String catalogField = version.before("5.1.0") ? "NULL" : "kcu.table_catalog";
        StringBuilder sql = new StringBuilder("SELECT " + catalogField + " AS \"TABLE_CAT\",\n  kcu." + schemaField + " AS \"TABLE_SCHEM\",\n  kcu.table_name AS \"TABLE_NAME\",\n  kcu.column_name AS \"COLUMN_NAME\",\n  kcu.ordinal_position AS \"KEY_SEQ\",\n  kcu.constraint_name AS \"PK_NAME\"\n FROM information_schema.key_column_usage kcu\n WHERE kcu.table_name = '" + this.connection.escapeString(table) + "'\n");
        if (schema != null) {
            sql.append("  AND kcu." + schemaField + " = '" + this.connection.escapeString(schema) + "'\n");
        }
        sql.append("ORDER BY \"TABLE_SCHEM\", \"TABLE_NAME\", \"KEY_SEQ\";");
        return this.createMetaDataStatement().executeQuery(sql.toString());
    }

    protected ResultSet getImportedExportedKeys(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        String sql = "SELECT NULL::text AS PKTABLE_CAT, pkn.nspname AS PKTABLE_SCHEM, pkc.relname AS PKTABLE_NAME, pka.attname AS PKCOLUMN_NAME, NULL::text AS FKTABLE_CAT, fkn.nspname AS FKTABLE_SCHEM, fkc.relname AS FKTABLE_NAME, fka.attname AS FKCOLUMN_NAME, pos.n AS KEY_SEQ, CASE con.confupdtype  WHEN 'c' THEN 0 WHEN 'n' THEN 2 WHEN 'd' THEN 4 WHEN 'r' THEN 1 WHEN 'p' THEN 1 WHEN 'a' THEN 3 ELSE NULL END AS UPDATE_RULE, CASE con.confdeltype  WHEN 'c' THEN 0 WHEN 'n' THEN 2 WHEN 'd' THEN 4 WHEN 'r' THEN 1 WHEN 'p' THEN 1 WHEN 'a' THEN 3 ELSE NULL END AS DELETE_RULE, con.conname AS FK_NAME, pkic.relname AS PK_NAME, CASE  WHEN con.condeferrable AND con.condeferred THEN 5 WHEN con.condeferrable THEN 6 ELSE 7 END AS DEFERRABILITY  FROM  pg_catalog.pg_namespace pkn, pg_catalog.pg_class pkc, pg_catalog.pg_attribute pka,  pg_catalog.pg_namespace fkn, pg_catalog.pg_class fkc, pg_catalog.pg_attribute fka,  pg_catalog.pg_constraint con,  pg_catalog.generate_series(1, " + this.getMaxIndexKeys() + ") pos(n),  pg_catalog.pg_class pkic";
        if (!this.connection.haveMinimumServerVersion(ServerVersion.v9_0)) {
            sql = sql + ", pg_catalog.pg_depend dep ";
        }
        sql = sql + " WHERE pkn.oid = pkc.relnamespace AND pkc.oid = pka.attrelid AND pka.attnum = con.confkey[pos.n] AND con.confrelid = pkc.oid  AND fkn.oid = fkc.relnamespace AND fkc.oid = fka.attrelid AND fka.attnum = con.conkey[pos.n] AND con.conrelid = fkc.oid  AND con.contype = 'f' AND pkic.relkind = 'i' ";
        sql = !this.connection.haveMinimumServerVersion(ServerVersion.v9_0) ? sql + " AND con.oid = dep.objid AND pkic.oid = dep.refobjid AND dep.classid = 'pg_constraint'::regclass::oid AND dep.refclassid = 'pg_class'::regclass::oid " : sql + " AND pkic.oid = con.conindid ";
        if (primarySchema != null && !primarySchema.isEmpty()) {
            sql = sql + " AND pkn.nspname = " + this.escapeQuotes(primarySchema);
        }
        if (foreignSchema != null && !foreignSchema.isEmpty()) {
            sql = sql + " AND fkn.nspname = " + this.escapeQuotes(foreignSchema);
        }
        if (primaryTable != null && !primaryTable.isEmpty()) {
            sql = sql + " AND pkc.relname = " + this.escapeQuotes(primaryTable);
        }
        if (foreignTable != null && !foreignTable.isEmpty()) {
            sql = sql + " AND fkc.relname = " + this.escapeQuotes(foreignTable);
        }
        sql = primaryTable != null ? sql + " ORDER BY fkn.nspname,fkc.relname,con.conname,pos.n" : sql + " ORDER BY pkn.nspname,pkc.relname, con.conname,pos.n";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.emptyResult(PgDatabaseMetaData.col("PKTABLE_CAT"), PgDatabaseMetaData.col("PKTABLE_SCHEM"), PgDatabaseMetaData.col("PKTABLE_NAME"), PgDatabaseMetaData.col("PKCOLUMN_NAME"), PgDatabaseMetaData.col("FKTABLE_CAT"), PgDatabaseMetaData.col("FKTABLE_SCHEM"), PgDatabaseMetaData.col("FKTABLE_NAME"), PgDatabaseMetaData.col("FKCOLUMN_NAME"), PgDatabaseMetaData.col("KEY_SEQ"), PgDatabaseMetaData.col("UPDATE_RULE"), PgDatabaseMetaData.col("DELETE_RULE"), PgDatabaseMetaData.col("FK_NAME"), PgDatabaseMetaData.col("PK_NAME"), PgDatabaseMetaData.col("DEFERRABILITY"));
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.emptyResult(PgDatabaseMetaData.col("PKTABLE_CAT"), PgDatabaseMetaData.col("PKTABLE_SCHEM"), PgDatabaseMetaData.col("PKTABLE_NAME"), PgDatabaseMetaData.col("PKCOLUMN_NAME"), PgDatabaseMetaData.col("FKTABLE_CAT"), PgDatabaseMetaData.col("FKTABLE_SCHEM"), PgDatabaseMetaData.col("FKTABLE_NAME"), PgDatabaseMetaData.col("FKCOLUMN_NAME"), PgDatabaseMetaData.col("KEY_SEQ"), PgDatabaseMetaData.col("UPDATE_RULE"), PgDatabaseMetaData.col("DELETE_RULE"), PgDatabaseMetaData.col("FK_NAME"), PgDatabaseMetaData.col("PK_NAME"), PgDatabaseMetaData.col("DEFERRABILITY"));
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.emptyResult(PgDatabaseMetaData.col("PKTABLE_CAT"), PgDatabaseMetaData.col("PKTABLE_SCHEM"), PgDatabaseMetaData.col("PKTABLE_NAME"), PgDatabaseMetaData.col("PKCOLUMN_NAME"), PgDatabaseMetaData.col("FKTABLE_CAT"), PgDatabaseMetaData.col("FKTABLE_SCHEM"), PgDatabaseMetaData.col("FKTABLE_NAME"), PgDatabaseMetaData.col("FKCOLUMN_NAME"), PgDatabaseMetaData.col("KEY_SEQ"), PgDatabaseMetaData.col("UPDATE_RULE"), PgDatabaseMetaData.col("DELETE_RULE"), PgDatabaseMetaData.col("FK_NAME"), PgDatabaseMetaData.col("PK_NAME"), PgDatabaseMetaData.col("DEFERRABILITY"));
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        byte[][] row;
        Field[] f = new Field[18];
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        byte[] bNullable = this.connection.encodeString(Integer.toString(1));
        byte[] bSearchable = this.connection.encodeString(Integer.toString(3));
        byte[] bPredBasic = this.connection.encodeString(Integer.toString(2));
        byte[] bPredNone = this.connection.encodeString(Integer.toString(0));
        byte[] bTrue = this.connection.encodeString("t");
        byte[] bFalse = this.connection.encodeString("f");
        byte[] bZero = this.connection.encodeString("0");
        byte[] b10 = this.connection.encodeString("10");
        f[0] = PgDatabaseMetaData.col("TYPE_NAME");
        f[1] = PgDatabaseMetaData.col("DATA_TYPE", 21);
        f[2] = PgDatabaseMetaData.col("PRECISION", 23);
        f[3] = PgDatabaseMetaData.col("LITERAL_PREFIX");
        f[4] = PgDatabaseMetaData.col("LITERAL_SUFFIX");
        f[5] = PgDatabaseMetaData.col("CREATE_PARAMS");
        f[6] = PgDatabaseMetaData.col("NULLABLE", 21);
        f[7] = PgDatabaseMetaData.col("CASE_SENSITIVE", 16);
        f[8] = PgDatabaseMetaData.col("SEARCHABLE", 21);
        f[9] = PgDatabaseMetaData.col("UNSIGNED_ATTRIBUTE", 16);
        f[10] = PgDatabaseMetaData.col("FIXED_PREC_SCALE", 16);
        f[11] = PgDatabaseMetaData.col("AUTO_INCREMENT", 16);
        f[12] = PgDatabaseMetaData.col("LOCAL_TYPE_NAME");
        f[13] = PgDatabaseMetaData.col("MINIMUM_SCALE", 21);
        f[14] = PgDatabaseMetaData.col("MAXIMUM_SCALE", 21);
        f[15] = PgDatabaseMetaData.col("SQL_DATA_TYPE", 23);
        f[16] = PgDatabaseMetaData.col("SQL_DATETIME_SUB", 23);
        f[17] = PgDatabaseMetaData.col("NUM_PREC_RADIX", 23);
        row = new byte[][]{this.connection.encodeString("byte"), this.connection.encodeString(Integer.toString(-6)), this.connection.encodeString("3"), null, null, null, bNullable, bFalse, bPredBasic, bTrue, bFalse, bFalse, row[0], bZero, bZero, null, null, b10};
        v.add((byte[][])row.clone());
        row[0] = this.connection.encodeString("long");
        row[1] = this.connection.encodeString(Integer.toString(-5));
        row[2] = this.connection.encodeString("19");
        row[3] = null;
        row[4] = null;
        row[5] = null;
        row[6] = bNullable;
        row[7] = bFalse;
        row[8] = bPredBasic;
        row[9] = bTrue;
        row[10] = bFalse;
        row[11] = bFalse;
        row[12] = row[0];
        row[13] = bZero;
        row[14] = bZero;
        row[15] = null;
        row[16] = null;
        row[17] = b10;
        v.add((byte[][])row.clone());
        row[0] = this.connection.encodeString("integer");
        row[1] = this.connection.encodeString(Integer.toString(4));
        row[2] = b10;
        row[3] = null;
        row[4] = null;
        row[5] = null;
        row[6] = bNullable;
        row[7] = bFalse;
        row[8] = bPredBasic;
        row[9] = bTrue;
        row[10] = bFalse;
        row[11] = bFalse;
        row[12] = row[0];
        row[13] = bZero;
        row[14] = bZero;
        row[15] = null;
        row[16] = null;
        row[17] = b10;
        v.add((byte[][])row.clone());
        row[0] = this.connection.encodeString("short");
        row[1] = this.connection.encodeString(Integer.toString(5));
        row[2] = this.connection.encodeString("5");
        row[3] = null;
        row[4] = null;
        row[5] = null;
        row[6] = bNullable;
        row[7] = bFalse;
        row[8] = bPredBasic;
        row[9] = bTrue;
        row[10] = bFalse;
        row[11] = bFalse;
        row[12] = row[0];
        row[13] = bZero;
        row[14] = bZero;
        row[15] = null;
        row[16] = null;
        row[17] = b10;
        v.add((byte[][])row.clone());
        row[0] = this.connection.encodeString("float");
        row[1] = this.connection.encodeString(Integer.toString(7));
        row[2] = this.connection.encodeString("7");
        row[3] = null;
        row[4] = null;
        row[5] = null;
        row[6] = bNullable;
        row[7] = bFalse;
        row[8] = bPredBasic;
        row[9] = bTrue;
        row[10] = bFalse;
        row[11] = bFalse;
        row[12] = row[0];
        row[13] = bZero;
        row[14] = this.connection.encodeString("6");
        row[15] = null;
        row[16] = null;
        row[17] = b10;
        v.add((byte[][])row.clone());
        row[0] = this.connection.encodeString("double");
        row[1] = this.connection.encodeString(Integer.toString(8));
        row[2] = this.connection.encodeString("15");
        row[3] = null;
        row[4] = null;
        row[5] = null;
        row[6] = bNullable;
        row[7] = bFalse;
        row[8] = bPredBasic;
        row[9] = bTrue;
        row[10] = bFalse;
        row[11] = bFalse;
        row[12] = row[0];
        row[13] = bZero;
        row[14] = this.connection.encodeString("14");
        row[15] = null;
        row[16] = null;
        row[17] = b10;
        v.add((byte[][])row.clone());
        row[0] = this.connection.encodeString("string");
        row[1] = this.connection.encodeString(Integer.toString(12));
        row[2] = null;
        row[3] = null;
        row[4] = null;
        row[5] = null;
        row[6] = bNullable;
        row[7] = bTrue;
        row[8] = bSearchable;
        row[9] = bTrue;
        row[10] = bFalse;
        row[11] = bFalse;
        row[12] = row[0];
        row[13] = bZero;
        row[14] = bZero;
        row[15] = null;
        row[16] = null;
        row[17] = b10;
        v.add((byte[][])row.clone());
        row[0] = this.connection.encodeString("ip");
        row[1] = this.connection.encodeString(Integer.toString(12));
        row[2] = this.connection.encodeString("15");
        row[3] = null;
        row[4] = null;
        row[5] = null;
        row[6] = bNullable;
        row[7] = bFalse;
        row[8] = bSearchable;
        row[9] = bTrue;
        row[10] = bFalse;
        row[11] = bFalse;
        row[12] = row[0];
        row[13] = bZero;
        row[14] = bZero;
        row[15] = null;
        row[16] = null;
        row[17] = b10;
        v.add((byte[][])row.clone());
        row[0] = this.connection.encodeString("boolean");
        row[1] = this.connection.encodeString(Integer.toString(16));
        row[2] = null;
        row[3] = null;
        row[4] = null;
        row[5] = null;
        row[6] = bNullable;
        row[7] = bFalse;
        row[8] = bPredBasic;
        row[9] = bTrue;
        row[10] = bFalse;
        row[11] = bFalse;
        row[12] = row[0];
        row[13] = bZero;
        row[14] = bZero;
        row[15] = null;
        row[16] = null;
        row[17] = b10;
        v.add((byte[][])row.clone());
        row[0] = this.connection.encodeString("timestamp");
        row[1] = this.connection.encodeString(Integer.toString(93));
        row[2] = null;
        row[3] = null;
        row[4] = null;
        row[5] = null;
        row[6] = bNullable;
        row[7] = bTrue;
        row[8] = bPredBasic;
        row[9] = bTrue;
        row[10] = bFalse;
        row[11] = bFalse;
        row[12] = row[0];
        row[13] = bZero;
        row[14] = bZero;
        row[15] = null;
        row[16] = null;
        row[17] = b10;
        v.add((byte[][])row.clone());
        row[0] = this.connection.encodeString("object");
        row[1] = this.connection.encodeString(Integer.toString(2002));
        row[2] = null;
        row[3] = null;
        row[4] = null;
        row[5] = null;
        row[6] = bNullable;
        row[7] = bFalse;
        row[8] = bPredNone;
        row[9] = bTrue;
        row[10] = bFalse;
        row[11] = bFalse;
        row[12] = row[0];
        row[13] = bZero;
        row[14] = bZero;
        row[15] = null;
        row[16] = null;
        row[17] = b10;
        v.add((byte[][])row.clone());
        String[] arrayTypes = new String[]{"string_array", "ip_array", "long_array", "integer_array", "short_array", "boolean_array", "byte_array", "float_array", "double_array", "object_array"};
        for (int i = 11; i < 11 + arrayTypes.length; ++i) {
            row[0] = this.connection.encodeString(arrayTypes[i - 11]);
            row[1] = this.connection.encodeString(Integer.toString(2003));
            row[2] = null;
            row[3] = null;
            row[4] = null;
            row[5] = null;
            row[6] = bNullable;
            row[7] = bFalse;
            row[8] = bPredNone;
            row[9] = bTrue;
            row[10] = bFalse;
            row[11] = bFalse;
            row[12] = row[0];
            row[13] = bZero;
            row[14] = bZero;
            row[15] = null;
            row[16] = null;
            row[17] = b10;
            v.add((byte[][])row.clone());
        }
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(f, v);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String tableName, boolean unique, boolean approximate) throws SQLException {
        return this.emptyResult(PgDatabaseMetaData.col("TABLE_CAT"), PgDatabaseMetaData.col("TABLE_SCHEM"), PgDatabaseMetaData.col("TABLE_NAME"), PgDatabaseMetaData.col("NON_UNIQUE"), PgDatabaseMetaData.col("INDEX_QUALIFIER"), PgDatabaseMetaData.col("INDEX_NAME"), PgDatabaseMetaData.col("TYPE"), PgDatabaseMetaData.col("ORDINAL_POSITION"), PgDatabaseMetaData.col("COLUMN_NAME"), PgDatabaseMetaData.col("ASC_OR_DESC"), PgDatabaseMetaData.col("CARDINALITY"), PgDatabaseMetaData.col("PAGES"), PgDatabaseMetaData.col("FILTER_CONDITION"));
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type != 1005;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        if (type == 1005) {
            return false;
        }
        if (concurrency == 1008) {
            return true;
        }
        return true;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int i) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int i) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return this.emptyResult(PgDatabaseMetaData.col("TYPE_CAT"), PgDatabaseMetaData.col("TYPE_SCHEM"), PgDatabaseMetaData.col("TYPE_NAME"), PgDatabaseMetaData.col("CLASS_NAME"), PgDatabaseMetaData.col("DATA_TYPE"), PgDatabaseMetaData.col("REMARKS"), PgDatabaseMetaData.col("BASE_TYPE"));
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    protected Statement createMetaDataStatement() throws SQLException {
        return this.connection.createStatement(1004, 1007);
    }

    @Override
    public long getMaxLogicalLobSize() throws SQLException {
        return 0L;
    }

    @Override
    public boolean supportsRefCursors() throws SQLException {
        return true;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRowIdLifetime()");
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return this.emptyResult(PgDatabaseMetaData.col("NAME"), PgDatabaseMetaData.col("MAX_LEN", 23), PgDatabaseMetaData.col("DEFAULT_VALUE"), PgDatabaseMetaData.col("DESCRIPTION"));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return this.emptyResult(PgDatabaseMetaData.col("FUNCTION_CAT"), PgDatabaseMetaData.col("FUNCTION_SCHEM"), PgDatabaseMetaData.col("FUNCTION_NAME"), PgDatabaseMetaData.col("REMARKS"), PgDatabaseMetaData.col("FUNCTION_TYPE", 21), PgDatabaseMetaData.col("SPECIFIC_NAME"));
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return this.emptyResult(PgDatabaseMetaData.col("FUNCTION_CAT"), PgDatabaseMetaData.col("FUNCTION_SCHEM"), PgDatabaseMetaData.col("FUNCTION_NAME"), PgDatabaseMetaData.col("COLUMN_NAME"), PgDatabaseMetaData.col("COLUMN_TYPE", 21), PgDatabaseMetaData.col("DATA_TYPE", 23), PgDatabaseMetaData.col("TYPE_NAME"), PgDatabaseMetaData.col("PRECISION", 23), PgDatabaseMetaData.col("LENGTH", 23), PgDatabaseMetaData.col("SCALE", 21), PgDatabaseMetaData.col("RADIX", 21), PgDatabaseMetaData.col("NULLABLE", 21), PgDatabaseMetaData.col("REMARKS"), PgDatabaseMetaData.col("CHAR_OCTET_LENGTH", 23), PgDatabaseMetaData.col("ORDINAL_POSITION", 23), PgDatabaseMetaData.col("IS_NULLABLE"), PgDatabaseMetaData.col("SPECIFIC_NAME"));
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.emptyResult(PgDatabaseMetaData.col("TABLE_CAT"), PgDatabaseMetaData.col("TABLE_SCHEM"), PgDatabaseMetaData.col("TABLE_NAME"), PgDatabaseMetaData.col("COLUMN_NAME"), PgDatabaseMetaData.col("DATA_TYPE", 23), PgDatabaseMetaData.col("COLUMN_SIZE", 23), PgDatabaseMetaData.col("DECIMAL_DIGITS", 23), PgDatabaseMetaData.col("NUM_PREC_RADIX", 23), PgDatabaseMetaData.col("COLUMN_USAGE"), PgDatabaseMetaData.col("REMARKS"), PgDatabaseMetaData.col("CHAR_OCTET_LENGTH", 23), PgDatabaseMetaData.col("IS_NULLABLE"));
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return this.emptyResult(PgDatabaseMetaData.col("TYPE_CAT"), PgDatabaseMetaData.col("TYPE_SCHEM"), PgDatabaseMetaData.col("TYPE_NAME"), PgDatabaseMetaData.col("SUPERTYPE_CAT"), PgDatabaseMetaData.col("SUPERTYPE_SCHEM"), PgDatabaseMetaData.col("SUPERTYPE_NAME"));
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.emptyResult(PgDatabaseMetaData.col("TABLE_CAT"), PgDatabaseMetaData.col("TABLE_SCHEM"), PgDatabaseMetaData.col("TABLE_NAME"), PgDatabaseMetaData.col("SUPERTABLE_NAME"));
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return this.emptyResult(PgDatabaseMetaData.col("TYPE_CAT"), PgDatabaseMetaData.col("TYPE_SCHEM"), PgDatabaseMetaData.col("TYPE_NAME"), PgDatabaseMetaData.col("ATTR_NAME"), PgDatabaseMetaData.col("DATA_TYPE"), PgDatabaseMetaData.col("ATTR_TYPE_NAME"), PgDatabaseMetaData.col("ATTR_SIZE"), PgDatabaseMetaData.col("DECIMAL_DIGITS"), PgDatabaseMetaData.col("NUM_PREC_RADIX"), PgDatabaseMetaData.col("NULLABLE"), PgDatabaseMetaData.col("REMARKS"), PgDatabaseMetaData.col("ATTR_DEF"), PgDatabaseMetaData.col("SQL_DATA_TYPE"), PgDatabaseMetaData.col("SQL_DATETIME_SUB"), PgDatabaseMetaData.col("CHAR_OCTET_LENGTH"), PgDatabaseMetaData.col("ORDINAL_POSITION"), PgDatabaseMetaData.col("IS_NULLABLE"), PgDatabaseMetaData.col("SCOPE_CATALOG"), PgDatabaseMetaData.col("SCOPE_SCHEMA"), PgDatabaseMetaData.col("SCOPE_TABLE"), PgDatabaseMetaData.col("SOURCE_DATA_TYPE"));
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return true;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.connection.getServerMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.connection.getServerMinorVersion();
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 2;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    private static Field col(String name, int oid) {
        return new Field(name, oid);
    }

    private static Field col(String name) {
        return new Field(name, 1043);
    }

    private final ResultSet emptyResult(Field ... fields) throws SQLException {
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fields, Collections.emptyList());
    }

    static {
        HashMap<String, String> referenceMaps = new HashMap<String, String>();
        referenceMaps.put("SYSTEM GENERATED", "SYSTEM");
        referenceMaps.put("USER GENERATED", "USER");
        REFERENCE_GENERATIONS = Collections.unmodifiableMap(referenceMaps);
        tableTypeClauses = new HashMap<String, Map<String, String>>();
        HashMap<String, String> ht = new HashMap<String, String>();
        tableTypeClauses.put("TABLE", ht);
        ht.put("SCHEMAS", "c.relkind IN ('r','p') AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'");
        ht.put("NOSCHEMAS", "c.relkind IN ('r','p') AND c.relname !~ '^pg_'");
        ht = new HashMap();
        tableTypeClauses.put("VIEW", ht);
        ht.put("SCHEMAS", "c.relkind = 'v' AND n.nspname <> 'pg_catalog' AND n.nspname <> 'information_schema'");
        ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname !~ '^pg_'");
        ht = new HashMap();
        tableTypeClauses.put("INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'");
        ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname !~ '^pg_'");
        ht = new HashMap();
        tableTypeClauses.put("SEQUENCE", ht);
        ht.put("SCHEMAS", "c.relkind = 'S'");
        ht.put("NOSCHEMAS", "c.relkind = 'S'");
        ht = new HashMap();
        tableTypeClauses.put("TYPE", ht);
        ht.put("SCHEMAS", "c.relkind = 'c' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'");
        ht.put("NOSCHEMAS", "c.relkind = 'c' AND c.relname !~ '^pg_'");
        ht = new HashMap();
        tableTypeClauses.put("SYSTEM TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'r' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema')");
        ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname ~ '^pg_' AND c.relname !~ '^pg_toast_' AND c.relname !~ '^pg_temp_'");
        ht = new HashMap();
        tableTypeClauses.put("SYSTEM TOAST TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname = 'pg_toast'");
        ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname ~ '^pg_toast_'");
        ht = new HashMap();
        tableTypeClauses.put("SYSTEM TOAST INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname = 'pg_toast'");
        ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname ~ '^pg_toast_'");
        ht = new HashMap();
        tableTypeClauses.put("SYSTEM VIEW", ht);
        ht.put("SCHEMAS", "c.relkind = 'v' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema') ");
        ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname ~ '^pg_'");
        ht = new HashMap();
        tableTypeClauses.put("SYSTEM INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema') ");
        ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname ~ '^pg_' AND c.relname !~ '^pg_toast_' AND c.relname !~ '^pg_temp_'");
        ht = new HashMap();
        tableTypeClauses.put("TEMPORARY TABLE", ht);
        ht.put("SCHEMAS", "c.relkind IN ('r','p') AND n.nspname ~ '^pg_temp_' ");
        ht.put("NOSCHEMAS", "c.relkind IN ('r','p') AND c.relname ~ '^pg_temp_' ");
        ht = new HashMap();
        tableTypeClauses.put("TEMPORARY INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname ~ '^pg_temp_' ");
        ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname ~ '^pg_temp_' ");
        ht = new HashMap();
        tableTypeClauses.put("TEMPORARY VIEW", ht);
        ht.put("SCHEMAS", "c.relkind = 'v' AND n.nspname ~ '^pg_temp_' ");
        ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname ~ '^pg_temp_' ");
        ht = new HashMap();
        tableTypeClauses.put("TEMPORARY SEQUENCE", ht);
        ht.put("SCHEMAS", "c.relkind = 'S' AND n.nspname ~ '^pg_temp_' ");
        ht.put("NOSCHEMAS", "c.relkind = 'S' AND c.relname ~ '^pg_temp_' ");
        ht = new HashMap();
        tableTypeClauses.put("FOREIGN TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'f'");
        ht.put("NOSCHEMAS", "c.relkind = 'f'");
        ht = new HashMap();
        tableTypeClauses.put("MATERIALIZED VIEW", ht);
        ht.put("SCHEMAS", "c.relkind = 'm'");
        ht.put("NOSCHEMAS", "c.relkind = 'm'");
    }
}

