/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class AfterAllStateMachine
extends TriggerStateMachine {
    private AfterAllStateMachine(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TriggerStateMachine> subTriggers) {
        super(subTriggers);
        Preconditions.checkArgument((subTriggers.size() > 1 ? 1 : 0) != 0);
    }

    @SafeVarargs
    public static @UnknownKeyFor @NonNull @Initialized TriggerStateMachine of(TriggerStateMachine ... triggers) {
        return new AfterAllStateMachine(Arrays.asList(triggers));
    }

    public static @UnknownKeyFor @NonNull @Initialized TriggerStateMachine of(@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized TriggerStateMachine> triggers) {
        return new AfterAllStateMachine((List<TriggerStateMachine>)ImmutableList.copyOf(triggers));
    }

    @Override
    public void prefetchOnElement(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.PrefetchContext c) {
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
            subTrigger.invokePrefetchOnElement(c.forTrigger(subTrigger));
        }
    }

    @Override
    public void onElement(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.OnElementContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().unfinishedSubTriggers()) {
            subTrigger.invokeOnElement(c);
        }
    }

    @Override
    public void prefetchOnMerge(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.MergingPrefetchContext c) {
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
            subTrigger.invokePrefetchOnMerge(c.forTrigger(subTrigger));
        }
    }

    @Override
    public void onMerge(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.OnMergeContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
            subTrigger.invokeOnMerge(c);
        }
        boolean allFinished = true;
        for (ExecutableTriggerStateMachine subTrigger1 : c.trigger().subTriggers()) {
            allFinished &= c.forTrigger(subTrigger1).trigger().isFinished();
        }
        c.trigger().setFinished(allFinished);
    }

    @Override
    public void prefetchShouldFire(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.PrefetchContext c) {
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
            subTrigger.invokePrefetchShouldFire(c.forTrigger(subTrigger));
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean shouldFire(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.TriggerContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        for (ExecutableTriggerStateMachine subTrigger : context.trigger().subTriggers()) {
            if (context.forTrigger(subTrigger).trigger().isFinished() || subTrigger.invokeShouldFire(context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onFire(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.TriggerContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        for (ExecutableTriggerStateMachine subTrigger : context.trigger().subTriggers()) {
            subTrigger.invokeOnFire(context);
        }
        context.trigger().setFinished(true);
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder builder = new StringBuilder("AfterAll.of(");
        Joiner.on((String)", ").appendTo(builder, (Iterable)this.subTriggers);
        builder.append(")");
        return builder.toString();
    }
}

