/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.UploadSessionType;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nullable;

class UploadSessionStartBatchArg {
    @Nullable
    protected final UploadSessionType sessionType;
    protected final long numSessions;

    public UploadSessionStartBatchArg(long numSessions, @Nullable UploadSessionType sessionType) {
        this.sessionType = sessionType;
        if (numSessions < 1L) {
            throw new IllegalArgumentException("Number 'numSessions' is smaller than 1L");
        }
        if (numSessions > 1000L) {
            throw new IllegalArgumentException("Number 'numSessions' is larger than 1000L");
        }
        this.numSessions = numSessions;
    }

    public UploadSessionStartBatchArg(long numSessions) {
        this(numSessions, null);
    }

    public long getNumSessions() {
        return this.numSessions;
    }

    @Nullable
    public UploadSessionType getSessionType() {
        return this.sessionType;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.sessionType, this.numSessions});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            UploadSessionStartBatchArg other = (UploadSessionStartBatchArg)obj;
            return this.numSessions == other.numSessions && (this.sessionType == other.sessionType || this.sessionType != null && this.sessionType.equals((Object)other.sessionType));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<UploadSessionStartBatchArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UploadSessionStartBatchArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("num_sessions");
            StoneSerializers.uInt64().serialize((Long)value.numSessions, g);
            if (value.sessionType != null) {
                g.writeFieldName("session_type");
                StoneSerializers.nullable(UploadSessionType.Serializer.INSTANCE).serialize(value.sessionType, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public UploadSessionStartBatchArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            UploadSessionType f_sessionType;
            Long f_numSessions;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_numSessions = null;
                f_sessionType = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("num_sessions".equals(field)) {
                        f_numSessions = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    if ("session_type".equals(field)) {
                        f_sessionType = StoneSerializers.nullable(UploadSessionType.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_numSessions == null) {
                    throw new JsonParseException(p, "Required field \"num_sessions\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            UploadSessionStartBatchArg value = new UploadSessionStartBatchArg(f_numSessions, f_sessionType);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

