/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MinimalFileLinkMetadata {
    @Nonnull
    protected final String url;
    @Nullable
    protected final String id;
    @Nullable
    protected final String path;
    @Nonnull
    protected final String rev;

    public MinimalFileLinkMetadata(@Nonnull String url, @Nonnull String rev, @Nullable String id, @Nullable String path) {
        if (url == null) {
            throw new IllegalArgumentException("Required value for 'url' is null");
        }
        this.url = url;
        if (id != null && id.length() < 1) {
            throw new IllegalArgumentException("String 'id' is shorter than 1");
        }
        this.id = id;
        this.path = path;
        if (rev == null) {
            throw new IllegalArgumentException("Required value for 'rev' is null");
        }
        if (rev.length() < 9) {
            throw new IllegalArgumentException("String 'rev' is shorter than 9");
        }
        if (!Pattern.matches("[0-9a-f]+", rev)) {
            throw new IllegalArgumentException("String 'rev' does not match pattern");
        }
        this.rev = rev;
    }

    public MinimalFileLinkMetadata(@Nonnull String url, @Nonnull String rev) {
        this(url, rev, null, null);
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    @Nonnull
    public String getRev() {
        return this.rev;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public static Builder newBuilder(String url, String rev) {
        return new Builder(url, rev);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.url, this.id, this.path, this.rev});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            MinimalFileLinkMetadata other = (MinimalFileLinkMetadata)obj;
            return !(this.url != other.url && !this.url.equals(other.url) || this.rev != other.rev && !this.rev.equals(other.rev) || this.id != other.id && (this.id == null || !this.id.equals(other.id)) || this.path != other.path && (this.path == null || !this.path.equals(other.path)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<MinimalFileLinkMetadata> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MinimalFileLinkMetadata value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("url");
            StoneSerializers.string().serialize(value.url, g);
            g.writeFieldName("rev");
            StoneSerializers.string().serialize(value.rev, g);
            if (value.id != null) {
                g.writeFieldName("id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.id, g);
            }
            if (value.path != null) {
                g.writeFieldName("path");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.path, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public MinimalFileLinkMetadata deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_path;
            String f_id;
            String f_rev;
            String f_url;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_url = null;
                f_rev = null;
                f_id = null;
                f_path = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("url".equals(field)) {
                        f_url = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("rev".equals(field)) {
                        f_rev = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("id".equals(field)) {
                        f_id = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_url == null) {
                    throw new JsonParseException(p, "Required field \"url\" missing.");
                }
                if (f_rev == null) {
                    throw new JsonParseException(p, "Required field \"rev\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            MinimalFileLinkMetadata value = new MinimalFileLinkMetadata(f_url, f_rev, f_id, f_path);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String url;
        protected final String rev;
        protected String id;
        protected String path;

        protected Builder(String url, String rev) {
            if (url == null) {
                throw new IllegalArgumentException("Required value for 'url' is null");
            }
            this.url = url;
            if (rev == null) {
                throw new IllegalArgumentException("Required value for 'rev' is null");
            }
            if (rev.length() < 9) {
                throw new IllegalArgumentException("String 'rev' is shorter than 9");
            }
            if (!Pattern.matches("[0-9a-f]+", rev)) {
                throw new IllegalArgumentException("String 'rev' does not match pattern");
            }
            this.rev = rev;
            this.id = null;
            this.path = null;
        }

        public Builder withId(String id) {
            if (id != null && id.length() < 1) {
                throw new IllegalArgumentException("String 'id' is shorter than 1");
            }
            this.id = id;
            return this;
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public MinimalFileLinkMetadata build() {
            return new MinimalFileLinkMetadata(this.url, this.rev, this.id, this.path);
        }
    }
}

