/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mail.pipeline.transforms.mail;

import java.util.List;
import lombok.Generated;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.mail.pipeline.transforms.mail.Mail;
import org.apache.hop.mail.pipeline.transforms.mail.MailData;
import org.apache.hop.mail.workflow.actions.mail.MailEmbeddedImageField;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

@Transform(id="Mail", image="mail.svg", name="i18n::Mail.Name", description="i18n::Mail.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Utility", keywords={"i18n::MailMeta.keyword"}, documentationUrl="/pipeline/transforms/mail.html")
public class MailMeta
extends BaseTransformMeta<Mail, MailData> {
    private static final Class<?> PKG = MailMeta.class;
    private static final String CONST_SPACE = "      ";
    private static final String CONST_SPACE_SHORT = "    ";
    @HopMetadataProperty
    private String server;
    @HopMetadataProperty
    private String destination;
    @HopMetadataProperty
    private String destinationCc;
    @HopMetadataProperty
    private String destinationBCc;
    @HopMetadataProperty(key="replyto")
    private String replyAddress;
    @HopMetadataProperty(key="replytoname")
    private String replyName;
    @HopMetadataProperty
    private String subject;
    @HopMetadataProperty(key="include_date")
    private boolean includeDate;
    @HopMetadataProperty(key="include_subfolders")
    private boolean includeSubFolders;
    @HopMetadataProperty
    private boolean zipFilenameDynamic;
    @HopMetadataProperty(key="isFilenameDynamic")
    private boolean filenameDynamic;
    @HopMetadataProperty
    private String dynamicFieldname;
    @HopMetadataProperty
    private String dynamicWildcard;
    @HopMetadataProperty
    private String dynamicZipFilename;
    @HopMetadataProperty
    private String sourcefilefoldername;
    @HopMetadataProperty
    private String sourcewildcard;
    @HopMetadataProperty
    private String connectionName;
    @HopMetadataProperty(key="contact_person")
    private String contactPerson;
    @HopMetadataProperty(key="contact_phone")
    private String contactPhone;
    @HopMetadataProperty
    private String comment;
    @HopMetadataProperty(key="include_files")
    private boolean includingFiles;
    @HopMetadataProperty(key="zip_files")
    private boolean zipFiles;
    @HopMetadataProperty(key="zip_name")
    private String zipFilename;
    @HopMetadataProperty(key="zip_limit_size")
    private String ziplimitsize;
    @HopMetadataProperty(key="use_auth")
    private boolean usingAuthentication;
    @HopMetadataProperty(key="usexoauth2")
    private boolean usexoauth2;
    @HopMetadataProperty(key="auth_user")
    private String authenticationUser;
    @HopMetadataProperty(key="auth_password", password=true)
    private String authenticationPassword;
    @HopMetadataProperty(key="only_comment")
    private boolean onlySendComment;
    @HopMetadataProperty(key="use_HTML")
    private boolean useHTML;
    @HopMetadataProperty(key="use_secure_auth")
    private boolean usingSecureAuthentication;
    @HopMetadataProperty(key="use_Priority")
    private boolean usePriority;
    @HopMetadataProperty
    private String port;
    @HopMetadataProperty
    private String priority;
    @HopMetadataProperty
    private String importance;
    @HopMetadataProperty
    private String sensitivity;
    @HopMetadataProperty(key="secureconnectiontype")
    private String secureConnectionType;
    @HopMetadataProperty
    private String encoding;
    @HopMetadataProperty
    private String replyToAddresses;
    @HopMetadataProperty(key="embeddedimage", groupKey="embeddedimages")
    public List<MailEmbeddedImageField> embeddedImages;
    @HopMetadataProperty
    private boolean attachContentFromField;
    @HopMetadataProperty
    private String attachContentField;
    @HopMetadataProperty
    private String attachContentFileNameField;
    @HopMetadataProperty(key="include_message_in_output")
    private boolean addMessageToOutput;
    @HopMetadataProperty(key="message_output_field")
    private String messageOutputField;
    @HopMetadataProperty(key="check_server_identity")
    private boolean checkServerIdentity;
    @HopMetadataProperty(key="trusted_hosts")
    private String trustedHosts;

    public Object clone() {
        return super.clone();
    }

    public void getFields(IRowMeta row, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.isAddMessageToOutput()) {
            try {
                IValueMeta v = ValueMetaFactory.createValueMeta((String)this.messageOutputField, (int)2);
                v.setOrigin(origin);
                row.addValueMeta(v);
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr = prev == null || prev.isEmpty() ? new CheckResult(3, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.TransformRecevingData", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.TransformRecevingData2", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        if (Utils.isEmpty((CharSequence)this.server)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.ServerEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.ServerOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            if (prev.indexOfValue(variables.resolve(this.server)) < 0) {
                cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.ServerFieldNotFound", (String[])new String[]{this.server}), (ICheckResultSource)transformMeta);
            }
            remarks.add((ICheckResult)cr);
        }
        cr = Utils.isEmpty((CharSequence)this.port) ? new CheckResult(3, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.PortEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.PortOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = Utils.isEmpty((CharSequence)this.replyAddress) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.ReplayAddressEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.ReplayAddressOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = Utils.isEmpty((CharSequence)this.destination) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.DestinationEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.DestinationOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = Utils.isEmpty((CharSequence)this.subject) ? new CheckResult(3, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.SubjectEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.SubjectOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = Utils.isEmpty((CharSequence)this.comment) ? new CheckResult(3, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.CommentEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.CommentEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        if (this.filenameDynamic) {
            cr = Utils.isEmpty((CharSequence)this.dynamicFieldname) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.DynamicFilenameFieldEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.DynamicFilenameFieldOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = Utils.isEmpty((CharSequence)this.sourcefilefoldername) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.SourceFilenameEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.SourceFilenameOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.isZipFiles()) {
            if (this.filenameDynamic) {
                cr = Utils.isEmpty((CharSequence)this.getDynamicZipFilename()) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.DynamicZipfilenameEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.DynamicZipfilenameOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = Utils.isEmpty((CharSequence)this.zipFilename) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.ZipfilenameEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.ZipfilenameOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public String getDestination() {
        return this.destination;
    }

    @Generated
    public String getDestinationCc() {
        return this.destinationCc;
    }

    @Generated
    public String getDestinationBCc() {
        return this.destinationBCc;
    }

    @Generated
    public String getReplyAddress() {
        return this.replyAddress;
    }

    @Generated
    public String getReplyName() {
        return this.replyName;
    }

    @Generated
    public String getSubject() {
        return this.subject;
    }

    @Generated
    public boolean isIncludeDate() {
        return this.includeDate;
    }

    @Generated
    public boolean isIncludeSubFolders() {
        return this.includeSubFolders;
    }

    @Generated
    public boolean isZipFilenameDynamic() {
        return this.zipFilenameDynamic;
    }

    @Generated
    public boolean isFilenameDynamic() {
        return this.filenameDynamic;
    }

    @Generated
    public String getDynamicFieldname() {
        return this.dynamicFieldname;
    }

    @Generated
    public String getDynamicWildcard() {
        return this.dynamicWildcard;
    }

    @Generated
    public String getDynamicZipFilename() {
        return this.dynamicZipFilename;
    }

    @Generated
    public String getSourcefilefoldername() {
        return this.sourcefilefoldername;
    }

    @Generated
    public String getSourcewildcard() {
        return this.sourcewildcard;
    }

    @Generated
    public String getConnectionName() {
        return this.connectionName;
    }

    @Generated
    public String getContactPerson() {
        return this.contactPerson;
    }

    @Generated
    public String getContactPhone() {
        return this.contactPhone;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public boolean isIncludingFiles() {
        return this.includingFiles;
    }

    @Generated
    public boolean isZipFiles() {
        return this.zipFiles;
    }

    @Generated
    public String getZipFilename() {
        return this.zipFilename;
    }

    @Generated
    public String getZiplimitsize() {
        return this.ziplimitsize;
    }

    @Generated
    public boolean isUsingAuthentication() {
        return this.usingAuthentication;
    }

    @Generated
    public boolean isUsexoauth2() {
        return this.usexoauth2;
    }

    @Generated
    public String getAuthenticationUser() {
        return this.authenticationUser;
    }

    @Generated
    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    @Generated
    public boolean isOnlySendComment() {
        return this.onlySendComment;
    }

    @Generated
    public boolean isUseHTML() {
        return this.useHTML;
    }

    @Generated
    public boolean isUsingSecureAuthentication() {
        return this.usingSecureAuthentication;
    }

    @Generated
    public boolean isUsePriority() {
        return this.usePriority;
    }

    @Generated
    public String getPort() {
        return this.port;
    }

    @Generated
    public String getPriority() {
        return this.priority;
    }

    @Generated
    public String getImportance() {
        return this.importance;
    }

    @Generated
    public String getSensitivity() {
        return this.sensitivity;
    }

    @Generated
    public String getSecureConnectionType() {
        return this.secureConnectionType;
    }

    @Generated
    public String getEncoding() {
        return this.encoding;
    }

    @Generated
    public String getReplyToAddresses() {
        return this.replyToAddresses;
    }

    @Generated
    public List<MailEmbeddedImageField> getEmbeddedImages() {
        return this.embeddedImages;
    }

    @Generated
    public boolean isAttachContentFromField() {
        return this.attachContentFromField;
    }

    @Generated
    public String getAttachContentField() {
        return this.attachContentField;
    }

    @Generated
    public String getAttachContentFileNameField() {
        return this.attachContentFileNameField;
    }

    @Generated
    public boolean isAddMessageToOutput() {
        return this.addMessageToOutput;
    }

    @Generated
    public String getMessageOutputField() {
        return this.messageOutputField;
    }

    @Generated
    public boolean isCheckServerIdentity() {
        return this.checkServerIdentity;
    }

    @Generated
    public String getTrustedHosts() {
        return this.trustedHosts;
    }

    @Generated
    public void setServer(String server) {
        this.server = server;
    }

    @Generated
    public void setDestination(String destination) {
        this.destination = destination;
    }

    @Generated
    public void setDestinationCc(String destinationCc) {
        this.destinationCc = destinationCc;
    }

    @Generated
    public void setDestinationBCc(String destinationBCc) {
        this.destinationBCc = destinationBCc;
    }

    @Generated
    public void setReplyAddress(String replyAddress) {
        this.replyAddress = replyAddress;
    }

    @Generated
    public void setReplyName(String replyName) {
        this.replyName = replyName;
    }

    @Generated
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Generated
    public void setIncludeDate(boolean includeDate) {
        this.includeDate = includeDate;
    }

    @Generated
    public void setIncludeSubFolders(boolean includeSubFolders) {
        this.includeSubFolders = includeSubFolders;
    }

    @Generated
    public void setZipFilenameDynamic(boolean zipFilenameDynamic) {
        this.zipFilenameDynamic = zipFilenameDynamic;
    }

    @Generated
    public void setFilenameDynamic(boolean filenameDynamic) {
        this.filenameDynamic = filenameDynamic;
    }

    @Generated
    public void setDynamicFieldname(String dynamicFieldname) {
        this.dynamicFieldname = dynamicFieldname;
    }

    @Generated
    public void setDynamicWildcard(String dynamicWildcard) {
        this.dynamicWildcard = dynamicWildcard;
    }

    @Generated
    public void setDynamicZipFilename(String dynamicZipFilename) {
        this.dynamicZipFilename = dynamicZipFilename;
    }

    @Generated
    public void setSourcefilefoldername(String sourcefilefoldername) {
        this.sourcefilefoldername = sourcefilefoldername;
    }

    @Generated
    public void setSourcewildcard(String sourcewildcard) {
        this.sourcewildcard = sourcewildcard;
    }

    @Generated
    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    @Generated
    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    @Generated
    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setIncludingFiles(boolean includingFiles) {
        this.includingFiles = includingFiles;
    }

    @Generated
    public void setZipFiles(boolean zipFiles) {
        this.zipFiles = zipFiles;
    }

    @Generated
    public void setZipFilename(String zipFilename) {
        this.zipFilename = zipFilename;
    }

    @Generated
    public void setZiplimitsize(String ziplimitsize) {
        this.ziplimitsize = ziplimitsize;
    }

    @Generated
    public void setUsingAuthentication(boolean usingAuthentication) {
        this.usingAuthentication = usingAuthentication;
    }

    @Generated
    public void setUsexoauth2(boolean usexoauth2) {
        this.usexoauth2 = usexoauth2;
    }

    @Generated
    public void setAuthenticationUser(String authenticationUser) {
        this.authenticationUser = authenticationUser;
    }

    @Generated
    public void setAuthenticationPassword(String authenticationPassword) {
        this.authenticationPassword = authenticationPassword;
    }

    @Generated
    public void setOnlySendComment(boolean onlySendComment) {
        this.onlySendComment = onlySendComment;
    }

    @Generated
    public void setUseHTML(boolean useHTML) {
        this.useHTML = useHTML;
    }

    @Generated
    public void setUsingSecureAuthentication(boolean usingSecureAuthentication) {
        this.usingSecureAuthentication = usingSecureAuthentication;
    }

    @Generated
    public void setUsePriority(boolean usePriority) {
        this.usePriority = usePriority;
    }

    @Generated
    public void setPort(String port) {
        this.port = port;
    }

    @Generated
    public void setPriority(String priority) {
        this.priority = priority;
    }

    @Generated
    public void setImportance(String importance) {
        this.importance = importance;
    }

    @Generated
    public void setSensitivity(String sensitivity) {
        this.sensitivity = sensitivity;
    }

    @Generated
    public void setSecureConnectionType(String secureConnectionType) {
        this.secureConnectionType = secureConnectionType;
    }

    @Generated
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Generated
    public void setReplyToAddresses(String replyToAddresses) {
        this.replyToAddresses = replyToAddresses;
    }

    @Generated
    public void setEmbeddedImages(List<MailEmbeddedImageField> embeddedImages) {
        this.embeddedImages = embeddedImages;
    }

    @Generated
    public void setAttachContentFromField(boolean attachContentFromField) {
        this.attachContentFromField = attachContentFromField;
    }

    @Generated
    public void setAttachContentField(String attachContentField) {
        this.attachContentField = attachContentField;
    }

    @Generated
    public void setAttachContentFileNameField(String attachContentFileNameField) {
        this.attachContentFileNameField = attachContentFileNameField;
    }

    @Generated
    public void setAddMessageToOutput(boolean addMessageToOutput) {
        this.addMessageToOutput = addMessageToOutput;
    }

    @Generated
    public void setMessageOutputField(String messageOutputField) {
        this.messageOutputField = messageOutputField;
    }

    @Generated
    public void setCheckServerIdentity(boolean checkServerIdentity) {
        this.checkServerIdentity = checkServerIdentity;
    }

    @Generated
    public void setTrustedHosts(String trustedHosts) {
        this.trustedHosts = trustedHosts;
    }
}

