/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.pipeline.PipelineConfiguration;
import org.apache.hop.pipeline.PipelineExecutionConfiguration;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.PipelineEngineFactory;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.RowAdapter;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.service.WebService;

@HopServerServlet(id="webService", name="Output the content of a field in a transform")
public class WebServiceServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final Class<?> PKG = WebServiceServlet.class;
    private static final long serialVersionUID = 3634806745373343432L;
    public static final String CONTEXT_PATH = "/hop/webService";

    public WebServiceServlet() {
    }

    public WebServiceServlet(PipelineMap pipelineMap) {
        super(pipelineMap);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    @Override
    public void doGet(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"WebServiceServlet.Log.WebServiceRequested", (String[])new String[0]));
        }
        IVariables variables = this.pipelineMap.getHopServerConfig().getVariables();
        MultiMetadataProvider metadataProvider = this.pipelineMap.getHopServerConfig().getMetadataProvider();
        String webServiceName = request.getParameter("service");
        if (StringUtils.isEmpty((String)webServiceName)) {
            throw new ServletException("Please specify a service parameter pointing to the name of the web service object");
        }
        String runConfigurationName = request.getParameter("runConfig");
        try {
            IHopMetadataSerializer serializer = metadataProvider.getSerializer(WebService.class);
            WebService webService = (WebService)serializer.load(webServiceName);
            if (webService == null) {
                throw new HopException("Unable to find web service '" + webServiceName + "'.  You can set the metadata_folder in the Hop server XML configuration");
            }
            if (!webService.isEnabled()) {
                throw new HopException("Web service '" + webServiceName + "' is disabled.");
            }
            if (StringUtils.isEmpty((String)runConfigurationName)) {
                runConfigurationName = variables.resolve(webService.getRunConfigurationName());
            }
            String filename = variables.resolve(webService.getFilename());
            String transformName = variables.resolve(webService.getTransformName());
            final String fieldName = variables.resolve(webService.getFieldName());
            String contentType = variables.resolve(webService.getContentType());
            final String statusCodeField = variables.resolve(webService.getStatusCode());
            String bodyContentVariable = variables.resolve(webService.getBodyContentVariable());
            String headerContentVariable = variables.resolve(webService.getHeaderContentVariable());
            String bodyContent = "";
            if (StringUtils.isNotEmpty((String)bodyContentVariable)) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)request.getInputStream(), (OutputStream)out);
                bodyContent = out.toString(StandardCharsets.UTF_8);
            }
            String headerContent = "";
            if (StringUtils.isNotEmpty((String)headerContentVariable)) {
                ObjectMapper objectMapper = new ObjectMapper();
                ObjectNode headersJson = objectMapper.createObjectNode();
                Enumeration headerNames = request.getHeaderNames();
                while (headerNames.hasMoreElements()) {
                    String headerName = (String)headerNames.nextElement();
                    String headerValue = request.getHeader(headerName);
                    headersJson.put(headerName, headerValue);
                }
                headerContent = objectMapper.writeValueAsString((Object)headersJson);
            }
            if (StringUtils.isEmpty((String)contentType)) {
                response.setContentType("text/plain");
            } else {
                response.setContentType(contentType);
            }
            response.setCharacterEncoding("UTF-8");
            String serverObjectId = UUID.randomUUID().toString();
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.HOP_SERVER, null);
            servletLoggingObject.setContainerObjectId(serverObjectId);
            PipelineMeta pipelineMeta = new PipelineMeta(filename, (IHopMetadataProvider)metadataProvider, variables);
            LocalPipelineEngine pipeline = StringUtils.isEmpty((String)runConfigurationName) ? new LocalPipelineEngine(pipelineMeta, variables, (ILoggingObject)servletLoggingObject) : PipelineEngineFactory.createPipelineEngine(variables, runConfigurationName, (IHopMetadataProvider)metadataProvider, pipelineMeta);
            pipeline.setContainerId(serverObjectId);
            if (StringUtils.isNotEmpty((String)bodyContentVariable)) {
                pipeline.setVariable(bodyContentVariable, Const.NVL((String)bodyContent, (String)""));
            }
            if (StringUtils.isNotEmpty((String)headerContentVariable)) {
                pipeline.setVariable(headerContentVariable, Const.NVL((String)headerContent, (String)""));
            }
            String[] pipelineParameters = pipelineMeta.listParameters();
            pipeline.copyParametersFromDefinitions(pipelineMeta);
            for (String requestParameter : request.getParameterMap().keySet()) {
                if ("service".equals(requestParameter)) continue;
                String requestParameterValue = request.getParameter(requestParameter);
                if (Const.indexOfString((String)requestParameter, (String[])pipelineParameters) < 0) {
                    pipeline.setVariable(requestParameter, Const.NVL((String)requestParameterValue, (String)""));
                    continue;
                }
                pipeline.setParameterValue(requestParameter, Const.NVL((String)requestParameterValue, (String)""));
            }
            pipeline.activateParameters(pipeline);
            if (webService.isListingStatus()) {
                PipelineExecutionConfiguration pipelineExecutionConfiguration = new PipelineExecutionConfiguration();
                PipelineConfiguration pipelineConfiguration = new PipelineConfiguration(pipelineMeta, pipelineExecutionConfiguration, new SerializableMetadataProvider((IHopMetadataProvider)metadataProvider));
                this.getPipelineMap().addPipeline(pipelineMeta.getName(), serverObjectId, pipeline, pipelineConfiguration);
            }
            pipeline.prepareExecution();
            ServletOutputStream outputStream = response.getOutputStream();
            IEngineComponent component = pipeline.findComponent(transformName, 0);
            component.addRowListener(new RowAdapter((OutputStream)outputStream){
                final /* synthetic */ OutputStream val$outputStream;
                {
                    this.val$outputStream = outputStream;
                }

                @Override
                public void rowWrittenEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                    try {
                        byte[] outputData;
                        response.setStatus(rowMeta.getInteger(row, statusCodeField, Long.valueOf(200L)).intValue());
                        int fieldIndex = rowMeta.indexOfValue(fieldName);
                        if (fieldIndex < 0) {
                            throw new HopTransformException("Field '" + fieldName + "' not found in row");
                        }
                        IValueMeta valueMeta = rowMeta.getValueMeta(fieldIndex);
                        if (valueMeta.getType() == 8) {
                            outputData = rowMeta.getBinary(row, fieldIndex);
                            if (outputData == null) {
                                outputData = new byte[]{};
                            }
                        } else {
                            String outputString = rowMeta.getString(row, fieldName, "");
                            outputData = outputString.getBytes(StandardCharsets.UTF_8);
                        }
                        this.val$outputStream.write(outputData);
                        this.val$outputStream.flush();
                    }
                    catch (HopValueException e) {
                        throw new HopTransformException("Error getting output field '" + fieldName + " from row: " + rowMeta.toStringMeta(), (Throwable)e);
                    }
                    catch (IOException e) {
                        throw new HopTransformException("Error writing output of '" + fieldName + "'", (Throwable)e);
                    }
                }
            });
            pipeline.startThreads();
            pipeline.waitUntilFinished();
        }
        catch (Exception e) {
            throw new ServletException("Error producing web service output", (Throwable)e);
        }
    }

    public String toString() {
        return "Web Service Servlet";
    }

    @Override
    public String getService() {
        return "/hop/webService (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

