/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.engines.remote;

import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.server.HopServerMeta;
import org.apache.hop.workflow.config.IWorkflowEngineRunConfiguration;
import org.apache.hop.workflow.config.WorkflowRunConfiguration;
import org.apache.hop.workflow.engines.empty.EmptyWorkflowRunConfiguration;

@GuiPlugin(description="Remote workflow run configuration widgets")
public class RemoteWorkflowRunConfiguration
extends EmptyWorkflowRunConfiguration
implements IWorkflowEngineRunConfiguration {
    @GuiWidgetElement(order="10", parentId="WorkflowRunConfiguration-PluginSpecific-Options", type=GuiElementType.METADATA, label="i18n:org.apache.hop.ui.workflow.config:WorkflowRunConfigurationDialog.HopServer.Label", metadata=HopServerMeta.class)
    @HopMetadataProperty(key="hop_server")
    protected String hopServerName;
    @GuiWidgetElement(order="20", parentId="WorkflowRunConfiguration-PluginSpecific-Options", type=GuiElementType.METADATA, label="i18n:org.apache.hop.ui.workflow.config:WorkflowRunConfigurationDialog.RunConfiguration.Label", metadata=WorkflowRunConfiguration.class)
    @HopMetadataProperty(key="run_config")
    protected String runConfigurationName;
    @GuiWidgetElement(order="30", parentId="WorkflowRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n:org.apache.hop.ui.workflow.config:WorkflowRunConfigurationDialog.ServerPollDelay.Label")
    @HopMetadataProperty(key="server_poll_delay")
    protected String serverPollDelay;
    @GuiWidgetElement(order="40", parentId="WorkflowRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n:org.apache.hop.ui.workflow.config:WorkflowRunConfigurationDialog.ServerPollInterval.Label")
    @HopMetadataProperty(key="server_poll_interval")
    protected String serverPollInterval;
    @GuiWidgetElement(order="50", parentId="WorkflowRunConfiguration-PluginSpecific-Options", type=GuiElementType.CHECKBOX, label="i18n:org.apache.hop.ui.workflow.config:WorkflowRunConfigurationDialog.ExportResources.Label", toolTip="i18n:org.apache.hop.ui.workflow.config:WorkflowRunConfigurationDialog.ExportResources.ToolTip")
    @HopMetadataProperty(key="export_resources")
    protected boolean exportingResources;
    @GuiWidgetElement(order="60", parentId="WorkflowRunConfiguration-PluginSpecific-Options", type=GuiElementType.FOLDER, label="i18n:org.apache.hop.ui.workflow.config:WorkflowRunConfigurationDialog.NamedResourceSourceFolder.Label", toolTip="i18n:org.apache.hop.ui.workflow.config:WorkflowRunConfigurationDialog.NamedResourceSourceFolder.ToolTip")
    @HopMetadataProperty(key="resources_source_folder")
    protected String namedResourcesSourceFolder;
    @GuiWidgetElement(order="70", parentId="WorkflowRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n:org.apache.hop.ui.workflow.config:WorkflowRunConfigurationDialog.NamedResourceTargetFolder.Label", toolTip="i18n:org.apache.hop.ui.workflow.config:WorkflowRunConfigurationDialog.NamedResourceTargetFolder.ToolTip")
    @HopMetadataProperty(key="resources_target_folder")
    protected String namedResourcesTargetFolder;

    public RemoteWorkflowRunConfiguration() {
    }

    public RemoteWorkflowRunConfiguration(RemoteWorkflowRunConfiguration config) {
        super(config);
        this.hopServerName = config.hopServerName;
        this.runConfigurationName = config.runConfigurationName;
        this.serverPollDelay = config.serverPollDelay;
        this.serverPollInterval = config.serverPollInterval;
        this.exportingResources = config.exportingResources;
        this.namedResourcesSourceFolder = config.namedResourcesSourceFolder;
        this.namedResourcesTargetFolder = config.namedResourcesTargetFolder;
    }

    @Override
    public RemoteWorkflowRunConfiguration clone() {
        return new RemoteWorkflowRunConfiguration(this);
    }

    public String getHopServerName() {
        return this.hopServerName;
    }

    public void setHopServerName(String hopServerName) {
        this.hopServerName = hopServerName;
    }

    public String getRunConfigurationName() {
        return this.runConfigurationName;
    }

    public void setRunConfigurationName(String runConfigurationName) {
        this.runConfigurationName = runConfigurationName;
    }

    public String getServerPollDelay() {
        return this.serverPollDelay;
    }

    public void setServerPollDelay(String serverPollDelay) {
        this.serverPollDelay = serverPollDelay;
    }

    public String getServerPollInterval() {
        return this.serverPollInterval;
    }

    public void setServerPollInterval(String serverPollInterval) {
        this.serverPollInterval = serverPollInterval;
    }

    public boolean isExportingResources() {
        return this.exportingResources;
    }

    public void setExportingResources(boolean exportingResources) {
        this.exportingResources = exportingResources;
    }

    public String getNamedResourcesSourceFolder() {
        return this.namedResourcesSourceFolder;
    }

    public void setNamedResourcesSourceFolder(String namedResourcesSourceFolder) {
        this.namedResourcesSourceFolder = namedResourcesSourceFolder;
    }

    public String getNamedResourcesTargetFolder() {
        return this.namedResourcesTargetFolder;
    }

    public void setNamedResourcesTargetFolder(String namedResourcesTargetFolder) {
        this.namedResourcesTargetFolder = namedResourcesTargetFolder;
    }
}

