/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.processfiles;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.processfiles.ProcessFiles;
import org.apache.hop.pipeline.transforms.processfiles.ProcessFilesData;

@Transform(id="ProcessFiles", image="processfiles.svg", description="i18n::ProcessFiles.Description", name="i18n::ProcessFiles.Name", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Utility", keywords={"i18n::ProcessFilesMeta.keyword"}, documentationUrl="/pipeline/transforms/processfiles.html")
public class ProcessFilesMeta
extends BaseTransformMeta<ProcessFiles, ProcessFilesData> {
    private static final Class<?> PKG = ProcessFilesMeta.class;
    @HopMetadataProperty(key="addresultfilenames", injectionKeyDescription="ProcessFiles.Injection.AddResultFilenames")
    private boolean addResultFilenames;
    @HopMetadataProperty(key="overwritetargetfile", injectionKeyDescription="ProcessFiles.Injection.OverwriteTargetFile")
    private boolean overwriteTargetFile;
    @HopMetadataProperty(key="createparentfolder", injectionKeyDescription="ProcessFiles.Injection.CreateParentFolder")
    private boolean createParentFolder;
    @HopMetadataProperty(key="simulate", injectionKeyDescription="ProcessFiles.Injection.Simulate")
    public boolean simulate;
    @HopMetadataProperty(key="sourcefilenamefield", injectionKeyDescription="ProcessFiles.Injection.SourceFilenameField")
    private String sourceFilenameField;
    @HopMetadataProperty(key="targetfilenamefield", injectionKeyDescription="ProcessFiles.Injection.TargetFilenameField")
    private String targetFilenameField;
    private int operationType;
    @HopMetadataProperty(key="operation_type", injectionKeyDescription="ProcessFiles.Injection.OperationType")
    private String operationTypeMeta;
    public static final String[] operationTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"ProcessFilesMeta.operationType.Copy", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProcessFilesMeta.operationType.Move", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProcessFilesMeta.operationType.Delete", (String[])new String[0])};
    public static final String[] operationTypeCode = new String[]{"copy", "move", "delete"};
    public static final int OPERATION_TYPE_COPY = 0;
    public static final int OPERATION_TYPE_MOVE = 1;
    public static final int OPERATION_TYPE_DELETE = 2;

    public int getOperationType() {
        return this.operationType;
    }

    public static int getOperationTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < operationTypeDesc.length; ++i) {
            if (!operationTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ProcessFilesMeta.getOperationTypeByCode(tt);
    }

    public void setOperationType(int operationType) {
        this.operationType = operationType;
        this.operationTypeMeta = ProcessFilesMeta.getOperationTypeCode(operationType);
    }

    public static String getOperationTypeDesc(int i) {
        if (i < 0 || i >= operationTypeDesc.length) {
            return operationTypeDesc[0];
        }
        return operationTypeDesc[i];
    }

    public String getSourceFilenameField() {
        return this.sourceFilenameField;
    }

    public void setSourceFilenameField(String sourceFilenameFieldield) {
        this.sourceFilenameField = sourceFilenameFieldield;
    }

    public String getTargetFilenameField() {
        return this.targetFilenameField;
    }

    public void setTargetFilenameField(String targetFilenameField) {
        this.targetFilenameField = targetFilenameField;
    }

    public boolean isOverwriteTargetFile() {
        return this.overwriteTargetFile;
    }

    public boolean isCreateParentFolder() {
        return this.createParentFolder;
    }

    public void setAddResultFilenames(boolean addresultfilenames) {
        this.addResultFilenames = addresultfilenames;
    }

    public void setOverwriteTargetFile(boolean overwritetargetfile) {
        this.overwriteTargetFile = overwritetargetfile;
    }

    public void setCreateParentFolder(boolean createparentfolder) {
        this.createParentFolder = createparentfolder;
    }

    public void setSimulate(boolean simulate) {
        this.simulate = simulate;
    }

    public boolean isSimulate() {
        return this.simulate;
    }

    public boolean isAddResultFilenames() {
        return this.addResultFilenames;
    }

    public String getOperationTypeMeta() {
        return this.operationTypeMeta;
    }

    public void setOperationTypeMeta(String operationTypeMeta) {
        this.operationTypeMeta = operationTypeMeta;
        this.setOperationType(ProcessFilesMeta.getOperationTypeByCode(operationTypeMeta));
    }

    public void setDefault() {
        this.addResultFilenames = false;
        this.overwriteTargetFile = false;
        this.createParentFolder = false;
        this.simulate = true;
        this.operationType = 0;
    }

    private static String getOperationTypeCode(int i) {
        if (i < 0 || i >= operationTypeCode.length) {
            return operationTypeCode[0];
        }
        return operationTypeCode[i];
    }

    private static int getOperationTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < operationTypeCode.length; ++i) {
            if (!operationTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        String errorMessage = "";
        if (Utils.isEmpty((CharSequence)this.sourceFilenameField)) {
            errorMessage = BaseMessages.getString(PKG, (String)"ProcessFilesMeta.CheckResult.SourceFileFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"ProcessFilesMeta.CheckResult.TargetFileFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.operationType != 2 && Utils.isEmpty((CharSequence)this.targetFilenameField)) {
            errorMessage = BaseMessages.getString(PKG, (String)"ProcessFilesMeta.CheckResult.TargetFileFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"ProcessFilesMeta.CheckResult.SourceFileFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ProcessFilesMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ProcessFilesMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

