/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.services;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.kie.api.internal.io.ResourceTypePackage;
import org.kie.api.internal.weaver.KieWeaverService;
import org.kie.api.internal.weaver.KieWeavers;
import org.kie.api.io.ResourceType;

public class KieWeaversImpl
implements KieWeavers,
Consumer<KieWeaverService> {
    private Map<ResourceType, KieWeaverService> weavers = new HashMap<ResourceType, KieWeaverService>();

    public Map<ResourceType, KieWeaverService> getWeavers() {
        return this.weavers;
    }

    @Override
    public void accept(KieWeaverService weaver) {
        this.weavers.put(weaver.getResourceType(), weaver);
    }

    public void weave(KieBase kieBase, KiePackage newPkg, ResourceTypePackage rtkKpg) {
        KieWeaverService svc = this.weavers.get(rtkKpg.getResourceType());
        if (svc != null) {
            svc.weave(kieBase, newPkg, rtkKpg);
        }
    }

    public void merge(KieBase kieBase, KiePackage pkg, ResourceTypePackage rtkKpg) {
        KieWeaverService svc = this.weavers.get(rtkKpg.getResourceType());
        if (svc != null) {
            svc.merge(kieBase, pkg, rtkKpg);
        }
    }
}

