/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.estimator;

import java.io.Serializable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.estimator.EncodingException;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.estimator.SizeEstimator;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class CoderSizeEstimator<@UnknownKeyFor T>
implements SizeEstimator<T>,
Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 5564948506493524158L;
    private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;
    private final @UnknownKeyFor @NonNull @Initialized SizeEstimatorObserver observer;

    public CoderSizeEstimator(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        this.coder = coder;
        this.observer = new SizeEstimatorObserver();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long sizeOf(T element) {
        try {
            this.coder.registerByteSizeObserver(element, (ElementByteSizeObserver)this.observer);
            this.observer.advance();
            return this.observer.observedBytes;
        }
        catch (Exception e) {
            throw new EncodingException(e);
        }
    }

    private static class SizeEstimatorObserver
    extends ElementByteSizeObserver
    implements Serializable {
        private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 4569562919962045617L;
        private @UnknownKeyFor @NonNull @Initialized long observedBytes;

        private SizeEstimatorObserver() {
        }

        protected void reportElementSize(@UnknownKeyFor @NonNull @Initialized long elementByteSize) {
            this.observedBytes = elementByteSize;
        }
    }
}

