/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss.abbvGapsHmm;

import com.wcohen.ss.abbvGapsHmm.AbbreviationAlignmentContainer;
import com.wcohen.ss.abbvGapsHmm.AbbvGapsHMM;
import com.wcohen.ss.abbvGapsHmm.AbbvGapsHmmBackwardsEvaluator;
import com.wcohen.ss.abbvGapsHmm.Acronym;
import com.wcohen.ss.abbvGapsHmm.Matrix3D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbbvGapsHmmBackwardsViterbiEvaluator
extends AbbvGapsHmmBackwardsEvaluator {
    protected Matrix3D _alpha;
    protected Matrix3D _beta;
    protected Matrix3D _emissions;
    protected Matrix3D _states;
    protected Matrix3D _prevSF;
    protected Matrix3D _prevLF;
    protected Matrix3D _prevSF_stringPos;
    protected Matrix3D _prevLF_stringPos;
    protected Double _bestProb;
    protected Double _currProb;

    public AbbvGapsHmmBackwardsViterbiEvaluator(AbbvGapsHMM abbvGapsHMM) {
        super(abbvGapsHMM);
    }

    public AbbreviationAlignmentContainer<AbbvGapsHMM.Emissions, AbbvGapsHMM.States> backwardViterbiEvaluate(Acronym acronym, List<Double> transitionParams, List<Double> emissionParams) {
        this._transitionParams = transitionParams;
        this._emissionParams = emissionParams;
        super.evaluate(acronym);
        return this.findMostProbablePathBackwards(acronym);
    }

    @Override
    protected void initEvalMat() {
        this._emissions = new Matrix3D(this._evalMat.dimension1(), this._evalMat.dimension2(), this._evalMat.dimension3());
        this._states = new Matrix3D(this._evalMat.dimension1(), this._evalMat.dimension2(), this._evalMat.dimension3());
        this._prevSF = new Matrix3D(this._evalMat.dimension1(), this._evalMat.dimension2(), this._evalMat.dimension3());
        this._prevLF = new Matrix3D(this._evalMat.dimension1(), this._evalMat.dimension2(), this._evalMat.dimension3());
        this._prevSF_stringPos = new Matrix3D(this._evalMat.dimension1(), this._evalMat.dimension2(), this._evalMat.dimension3());
        this._prevLF_stringPos = new Matrix3D(this._evalMat.dimension1(), this._evalMat.dimension2(), this._evalMat.dimension3());
        super.initEvalMat();
    }

    protected int getLegalStringPos(int strPos, String str) {
        int legalStrPos = strPos;
        if (strPos > str.length() || strPos == -1) {
            legalStrPos = str.length();
        }
        return legalStrPos;
    }

    public AbbreviationAlignmentContainer<AbbvGapsHMM.Emissions, AbbvGapsHMM.States> findMostProbablePathBackwards(Acronym acronym) {
        int sPos = this._sParam.getRangeEnd();
        int lPos = this._lParam.getRangeEnd();
        int state = AbbvGapsHMM.States.S.ordinal();
        int stringPosS = -1;
        int stringPosL = -1;
        if (this._evalMat.at(0, 0, AbbvGapsHMM.States.S.ordinal()) == 0.0) {
            return null;
        }
        ArrayList<AbbvGapsHMM.Emissions> emmisionsPath = new ArrayList<AbbvGapsHMM.Emissions>();
        ArrayList<AbbvGapsHMM.States> statesPath = new ArrayList<AbbvGapsHMM.States>();
        ArrayList<String> lAlign = new ArrayList<String>();
        ArrayList<String> sAlign = new ArrayList<String>();
        AbbvGapsHMM.Emissions[] emissionValues = AbbvGapsHMM.Emissions.values();
        AbbvGapsHMM.States[] stateValues = AbbvGapsHMM.States.values();
        while (sPos < this._sParam.getEvalMatrixSize() - 1 || lPos < this._lParam.getEvalMatrixSize() - 1) {
            AbbvGapsHMM.Emissions currEmission = emissionValues[(int)Math.round(this._emissions.at(sPos, lPos, state))];
            Integer currSF = (int)Math.round(this._prevSF.at(sPos, lPos, state));
            Integer currLF = (int)Math.round(this._prevLF.at(sPos, lPos, state));
            Integer currState = (int)Math.round(this._states.at(sPos, lPos, state));
            Integer currSF_stringPos = (int)Math.round(this._prevSF_stringPos.at(sPos, lPos, state));
            Integer currLF_stringPos = (int)Math.round(this._prevLF_stringPos.at(sPos, lPos, state));
            if (stringPosS != -1 && stringPosL != -1) {
                stringPosS = this.getLegalStringPos(stringPosS, acronym._shortForm);
                stringPosL = this.getLegalStringPos(stringPosL, acronym._longForm);
                lAlign.add(acronym._longForm.substring(stringPosL, currLF_stringPos));
                sAlign.add(acronym._shortForm.substring(stringPosS, currSF_stringPos));
            }
            emmisionsPath.add(currEmission);
            statesPath.add(stateValues[currState]);
            sPos = currSF;
            lPos = currLF;
            state = currState;
            stringPosS = currSF_stringPos;
            stringPosL = currLF_stringPos;
        }
        return new AbbreviationAlignmentContainer<AbbvGapsHMM.Emissions, AbbvGapsHMM.States>(sAlign, lAlign, emmisionsPath, statesPath, this._evalMat.at(0, 0, AbbvGapsHMM.States.S.ordinal()));
    }

    @Override
    protected void updateLegalOutgoingEdges(int currS, int currL, AbbvGapsHMM.States currState, int prevS, int prevL, AbbvGapsHMM.States prevState, AbbvGapsHMM.Transitions transition, AbbvGapsHMM.Emissions emission) {
        Double currProb;
        Double prevProb = this._evalMat.at(currS, currL, prevState.ordinal());
        if (prevProb.compareTo(currProb = Double.valueOf(this._evalMat.at(prevS, prevL, currState.ordinal()) * (Double)this._emissionParams.get(emission.ordinal()) * (Double)this._transitionParams.get(transition.ordinal()))) < 0) {
            this._evalMat.set(currS, currL, prevState.ordinal(), currProb);
            this._emissions.set(currS, currL, prevState.ordinal(), emission.ordinal());
            this._states.set(currS, currL, prevState.ordinal(), currState.ordinal());
            this._prevSF.set(currS, currL, prevState.ordinal(), prevS);
            this._prevLF.set(currS, currL, prevState.ordinal(), prevL);
            this._prevSF_stringPos.set(currS, currL, prevState.ordinal(), this._sParam.getEvalStringPos());
            this._prevLF_stringPos.set(currS, currL, prevState.ordinal(), this._lParam.getEvalStringPos());
        }
    }
}

