/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.pipeline.delegates;

import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.undo.ChangeAction;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;

public class HopGuiPipelineUndoDelegate {
    private HopGuiPipelineGraph pipelineGraph;
    private HopGui hopGui;

    public HopGuiPipelineUndoDelegate(HopGui hopGui, HopGuiPipelineGraph pipelineGraph) {
        this.hopGui = hopGui;
        this.pipelineGraph = pipelineGraph;
    }

    public void undoPipelineAction(IHopFileTypeHandler handler, PipelineMeta pipelineMeta) {
        ChangeAction changeAction = pipelineMeta.previousUndo();
        if (changeAction == null) {
            return;
        }
        this.undoPipelineAction(handler, pipelineMeta, changeAction);
        handler.updateGui();
    }

    public void undoPipelineAction(IHopFileTypeHandler handler, PipelineMeta pipelineMeta, ChangeAction changeAction) {
        switch (changeAction.getType()) {
            case NewTransform: {
                for (int i = changeAction.getCurrent().length - 1; i >= 0; --i) {
                    int idx = changeAction.getCurrentIndex()[i];
                    pipelineMeta.removeTransform(idx);
                }
                break;
            }
            case NewNote: {
                for (int i = changeAction.getCurrent().length - 1; i >= 0; --i) {
                    int idx = changeAction.getCurrentIndex()[i];
                    pipelineMeta.removeNote(idx);
                }
                break;
            }
            case NewPipelineHop: {
                for (int i = changeAction.getCurrent().length - 1; i >= 0; --i) {
                    int idx = changeAction.getCurrentIndex()[i];
                    pipelineMeta.removePipelineHop(idx);
                }
                break;
            }
            case DeleteTransform: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    TransformMeta transformMeta = (TransformMeta)changeAction.getCurrent()[i];
                    int idx = changeAction.getCurrentIndex()[i];
                    pipelineMeta.addTransform(idx, transformMeta);
                }
                break;
            }
            case DeleteNote: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    NotePadMeta ni = (NotePadMeta)changeAction.getCurrent()[i];
                    int idx = changeAction.getCurrentIndex()[i];
                    pipelineMeta.addNote(idx, ni);
                }
                break;
            }
            case DeletePipelineHop: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    PipelineHopMeta hi = (PipelineHopMeta)changeAction.getCurrent()[i];
                    int idx = changeAction.getCurrentIndex()[i];
                    TransformMeta from = pipelineMeta.findTransform(hi.getFromTransform().getName());
                    TransformMeta to = pipelineMeta.findTransform(hi.getToTransform().getName());
                    PipelineHopMeta hinew = new PipelineHopMeta(from, to);
                    pipelineMeta.addPipelineHop(idx, hinew);
                }
                break;
            }
            case ChangeTransform: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    TransformMeta prev = (TransformMeta)((TransformMeta)changeAction.getPrevious()[i]).clone();
                    int idx = changeAction.getCurrentIndex()[i];
                    pipelineMeta.getTransform(idx).replaceMeta(prev);
                }
                break;
            }
            case ChangeNote: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    int idx = changeAction.getCurrentIndex()[i];
                    pipelineMeta.removeNote(idx);
                    NotePadMeta prev = (NotePadMeta)changeAction.getPrevious()[i];
                    pipelineMeta.addNote(idx, prev.clone());
                }
                break;
            }
            case ChangePipelineHop: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    PipelineHopMeta prev = (PipelineHopMeta)changeAction.getPrevious()[i];
                    int idx = changeAction.getCurrentIndex()[i];
                    pipelineMeta.removePipelineHop(idx);
                    pipelineMeta.addPipelineHop(idx, prev.clone());
                }
                break;
            }
            case PositionTransform: {
                for (int i = 0; i < changeAction.getCurrentIndex().length; ++i) {
                    TransformMeta transformMeta = pipelineMeta.getTransform(changeAction.getCurrentIndex()[i]);
                    transformMeta.setLocation(changeAction.getPreviousLocation()[i]);
                }
                break;
            }
            case PositionNote: {
                for (int i = 0; i < changeAction.getCurrentIndex().length; ++i) {
                    int idx = changeAction.getCurrentIndex()[i];
                    NotePadMeta npi = pipelineMeta.getNote(idx);
                    Point prev = changeAction.getPreviousLocation()[i];
                    npi.setLocation(prev);
                }
                break;
            }
        }
        if (pipelineMeta.viewNextUndo() != null && pipelineMeta.viewNextUndo().getNextAlso()) {
            this.undoPipelineAction(handler, pipelineMeta);
        }
    }

    public void redoPipelineAction(IHopFileTypeHandler handler, PipelineMeta pipelineMeta) {
        ChangeAction changeAction = pipelineMeta.nextUndo();
        if (changeAction == null) {
            return;
        }
        this.redoPipelineAction(handler, pipelineMeta, changeAction);
        handler.updateGui();
    }

    public void redoPipelineAction(IHopFileTypeHandler handler, PipelineMeta pipelineMeta, ChangeAction changeAction) {
        switch (changeAction.getType()) {
            case NewTransform: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    TransformMeta transformMeta = (TransformMeta)changeAction.getCurrent()[i];
                    int idx = changeAction.getCurrentIndex()[i];
                    pipelineMeta.addTransform(idx, transformMeta);
                }
                break;
            }
            case NewNote: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    NotePadMeta ni = (NotePadMeta)changeAction.getCurrent()[i];
                    int idx = changeAction.getCurrentIndex()[i];
                    pipelineMeta.addNote(idx, ni);
                }
                break;
            }
            case NewPipelineHop: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    PipelineHopMeta hi = (PipelineHopMeta)changeAction.getCurrent()[i];
                    int idx = changeAction.getCurrentIndex()[i];
                    pipelineMeta.addPipelineHop(idx, hi);
                }
                break;
            }
            case DeleteTransform: {
                for (int i = changeAction.getCurrent().length - 1; i >= 0; --i) {
                    int idx = changeAction.getCurrentIndex()[i];
                    pipelineMeta.removeTransform(idx);
                }
                break;
            }
            case DeleteNote: {
                for (int i = changeAction.getCurrent().length - 1; i >= 0; --i) {
                    int idx = changeAction.getCurrentIndex()[i];
                    pipelineMeta.removeNote(idx);
                }
                break;
            }
            case DeletePipelineHop: {
                for (int i = changeAction.getCurrent().length - 1; i >= 0; --i) {
                    int idx = changeAction.getCurrentIndex()[i];
                    pipelineMeta.removePipelineHop(idx);
                }
                break;
            }
            case ChangeTransform: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    TransformMeta transformMeta = (TransformMeta)((TransformMeta)changeAction.getCurrent()[i]).clone();
                    pipelineMeta.getTransform(changeAction.getCurrentIndex()[i]).replaceMeta(transformMeta);
                }
                break;
            }
            case ChangeNote: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    NotePadMeta ni = (NotePadMeta)changeAction.getCurrent()[i];
                    int idx = changeAction.getCurrentIndex()[i];
                    pipelineMeta.removeNote(idx);
                    pipelineMeta.addNote(idx, ni.clone());
                }
                break;
            }
            case ChangePipelineHop: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    PipelineHopMeta hi = (PipelineHopMeta)changeAction.getCurrent()[i];
                    int idx = changeAction.getCurrentIndex()[i];
                    pipelineMeta.removePipelineHop(idx);
                    pipelineMeta.addPipelineHop(idx, hi.clone());
                }
                break;
            }
            case PositionTransform: {
                for (int i = 0; i < changeAction.getCurrentIndex().length; ++i) {
                    TransformMeta transformMeta = pipelineMeta.getTransform(changeAction.getCurrentIndex()[i]);
                    transformMeta.setLocation(changeAction.getCurrentLocation()[i]);
                }
                break;
            }
            case PositionNote: {
                for (int i = 0; i < changeAction.getCurrentIndex().length; ++i) {
                    int idx = changeAction.getCurrentIndex()[i];
                    NotePadMeta npi = pipelineMeta.getNote(idx);
                    Point curr = changeAction.getCurrentLocation()[i];
                    npi.setLocation(curr);
                }
                break;
            }
        }
        if (pipelineMeta.viewNextUndo() != null && pipelineMeta.viewNextUndo().getNextAlso()) {
            this.redoPipelineAction(handler, pipelineMeta);
        }
    }

    public HopGuiPipelineGraph getPipelineGraph() {
        return this.pipelineGraph;
    }

    public void setPipelineGraph(HopGuiPipelineGraph pipelineGraph) {
        this.pipelineGraph = pipelineGraph;
    }

    public HopGui getHopGui() {
        return this.hopGui;
    }

    public void setHopGui(HopGui hopGui) {
        this.hopGui = hopGui;
    }
}

