/*
 * Decompiled with CFR 0.152.
 */
package io.minio.messages;

import io.minio.Utils;
import io.minio.messages.DeleteMarker;
import io.minio.messages.Metadata;
import io.minio.messages.Owner;
import io.minio.messages.ResponseDate;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

public abstract class Item {
    @Element(name="ETag", required=false)
    private String etag;
    @Element(name="Key")
    private String objectName;
    @Element(name="LastModified")
    private ResponseDate lastModified;
    @Element(name="Owner", required=false)
    private Owner owner;
    @Element(name="Size", required=false)
    private long size;
    @Element(name="StorageClass", required=false)
    private String storageClass;
    @Element(name="IsLatest", required=false)
    private boolean isLatest;
    @Element(name="VersionId", required=false)
    private String versionId;
    @Element(name="UserMetadata", required=false)
    private Metadata userMetadata;
    @Element(name="UserTags", required=false)
    private String userTags;
    @ElementList(name="ChecksumAlgorithm", inline=true, required=false)
    private List<String> checksumAlgorithm;
    @Element(name="ChecksumType", required=false)
    private String checksumType;
    @Element(name="RestoreStatus", required=false)
    private RestoreStatus restoreStatus;
    private boolean isDir = false;
    private String encodingType = null;

    public Item() {
    }

    public Item(String prefix) {
        this.objectName = prefix;
        this.isDir = true;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    public String objectName() {
        return Utils.urlDecode(this.objectName, this.encodingType);
    }

    public ZonedDateTime lastModified() {
        return this.lastModified == null ? null : this.lastModified.zonedDateTime();
    }

    public String etag() {
        return this.etag;
    }

    public long size() {
        return this.size;
    }

    public String storageClass() {
        return this.storageClass;
    }

    public Owner owner() {
        return this.owner;
    }

    public Map<String, String> userMetadata() {
        return this.userMetadata == null ? null : this.userMetadata.get();
    }

    public String userTags() {
        return this.userTags;
    }

    public boolean isLatest() {
        return this.isLatest;
    }

    public String versionId() {
        return this.versionId;
    }

    public boolean isDir() {
        return this.isDir;
    }

    public boolean isDeleteMarker() {
        return this instanceof DeleteMarker;
    }

    public List<String> checksumAlgorithm() {
        return Utils.unmodifiableList(this.checksumAlgorithm);
    }

    public String checksumType() {
        return this.checksumType;
    }

    public RestoreStatus restoreStatus() {
        return this.restoreStatus;
    }

    @Root(name="RestoreStatus", strict=false)
    public static class RestoreStatus {
        @Element(name="IsRestoreInProgress", required=false)
        private Boolean isRestoreInProgress;
        @Element(name="RestoreExpiryDate", required=false)
        private ResponseDate restoreExpiryDate;

        public RestoreStatus(@Element(name="IsRestoreInProgress", required=false) Boolean isRestoreInProgress, @Element(name="RestoreExpiryDate", required=false) ResponseDate restoreExpiryDate) {
            this.isRestoreInProgress = isRestoreInProgress;
            this.restoreExpiryDate = restoreExpiryDate;
        }

        public Boolean isRestoreInProgress() {
            return this.isRestoreInProgress;
        }

        public ZonedDateTime restoreExpiryDate() {
            return this.restoreExpiryDate == null ? null : this.restoreExpiryDate.zonedDateTime();
        }
    }
}

