/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPData;
import com.ibm.as400.access.NPCPIDOutQ;
import com.ibm.as400.access.NPCPIDPrinterFile;
import com.ibm.as400.access.NPCPIDSplF;
import com.ibm.as400.access.NPCPSplFHandle;
import com.ibm.as400.access.NPConversation;
import com.ibm.as400.access.NPDataAnalyzer;
import com.ibm.as400.access.NPDataStream;
import com.ibm.as400.access.NPSystem;
import com.ibm.as400.access.OutputQueueImpl;
import com.ibm.as400.access.OutputQueueImplRemote;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.PrinterFileImpl;
import com.ibm.as400.access.PrinterFileImplRemote;
import com.ibm.as400.access.SpooledFileOutputStreamImpl;
import com.ibm.as400.access.Trace;
import java.io.IOException;

class SpooledFileOutputStreamImplRemote
implements SpooledFileOutputStreamImpl {
    static final String DT_AUTO = "*AUTO";
    static final String DT_PRTF = "*PRTF";
    private byte[] buffer_ = new byte[4096];
    private NPConversation conversation_;
    private NPCPAttribute cpAttr_;
    private NPCPAttribute cpCPFMsg_;
    private NPCPIDSplF cpIDSplF_;
    private NPCPIDOutQ cpIDOutQ_;
    private NPCPIDPrinterFile cpIDPrtrFile_;
    private NPCPSplFHandle cpSplFHndl_;
    private boolean fCreatePending_;
    private NPSystem npSystem_;
    private int offset_ = 0;
    private AS400ImplRemote sys_;

    SpooledFileOutputStreamImplRemote() {
    }

    @Override
    public synchronized void createSpooledFileOutputStream(AS400Impl system, PrintParameterList options, PrinterFileImpl printerFile, OutputQueueImpl outputQueue) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        this.fCreatePending_ = true;
        this.sys_ = (AS400ImplRemote)system;
        this.npSystem_ = NPSystem.getSystem(this.sys_);
        this.conversation_ = this.npSystem_.getConversation();
        this.cpCPFMsg_ = new NPCPAttribute();
        this.cpIDSplF_ = new NPCPIDSplF();
        this.cpSplFHndl_ = new NPCPSplFHandle();
        if (printerFile != null) {
            this.cpIDPrtrFile_ = (NPCPIDPrinterFile)((PrinterFileImplRemote)printerFile).getIDCodePoint();
        }
        if (outputQueue != null) {
            this.cpIDOutQ_ = (NPCPIDOutQ)((OutputQueueImplRemote)outputQueue).getIDCodePoint();
        }
        String strDataType = null;
        this.cpAttr_ = new NPCPAttribute();
        if (options != null) {
            this.cpAttr_.addUpdateAttributes(options.getAttrCodePoint());
        }
        if ((strDataType = (strDataType = this.cpAttr_.getStringValue(90)) == null ? DT_AUTO : strDataType.toUpperCase().trim()).equals(DT_AUTO)) {
            this.fCreatePending_ = true;
        } else {
            if (strDataType.equals(DT_PRTF)) {
                strDataType = "";
            }
            this.makeCreateRequest(strDataType);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        if (this.offset_ != 0) {
            this.makeWriteRequest(this.buffer_, 0, this.offset_);
            this.offset_ = 0;
        }
        if (this.fCreatePending_) {
            this.makeCreateRequest(null);
        }
        NPDataStream closeReq = new NPDataStream(1);
        NPDataStream closeRep = new NPDataStream(1);
        closeReq.setAction(5);
        closeReq.addCodePoint(this.cpSplFHndl_);
        closeRep.addCodePoint(this.cpCPFMsg_);
        try {
            this.conversation_.makeRequest(closeReq, closeRep);
        }
        catch (Exception e) {
            Trace.log(2, "Caught an Exception." + e.toString());
            throw new IOException(e.toString());
        }
        finally {
            if (this.conversation_ != null) {
                this.npSystem_.returnConversation(this.conversation_);
                this.conversation_ = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.conversation_ != null) {
            if (!this.fCreatePending_) {
                NPDataStream closeReq = new NPDataStream(1);
                closeReq.setAction(5);
                closeReq.addCodePoint(this.cpSplFHndl_);
                AS400Server server = this.conversation_.getServer();
                if (server != null) {
                    closeReq.setConverter(this.conversation_.getConverter());
                    server.sendAndDiscardReply(closeReq);
                }
            }
            this.npSystem_.returnConversation(this.conversation_);
        }
        super.finalize();
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.offset_ != 0) {
            this.makeWriteRequest(this.buffer_, 0, this.offset_);
            this.offset_ = 0;
        }
    }

    @Override
    public synchronized NPCPIDSplF getSpooledFile() throws IOException {
        NPCPIDSplF sfID = null;
        if (this.conversation_ != null) {
            this.flush();
        }
        if (this.fCreatePending_) {
            Trace.log(2, "Spooled File has not been created.");
            throw new ExtendedIllegalStateException(3);
        }
        sfID = this.cpIDSplF_;
        return sfID;
    }

    private synchronized void makeCreateRequest(String strDataType) throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        if (strDataType != null && !strDataType.equals("")) {
            if (this.cpAttr_ == null) {
                this.cpAttr_ = new NPCPAttribute();
            }
            this.cpAttr_.setAttrValue(90, strDataType);
        }
        NPDataStream createReq = new NPDataStream(1);
        NPDataStream createRep = new NPDataStream(1);
        createReq.setAction(1);
        if (this.cpAttr_ != null) {
            createReq.addCodePoint(this.cpAttr_);
        }
        if (this.cpIDOutQ_ != null) {
            createReq.addCodePoint(this.cpIDOutQ_);
        }
        if (this.cpIDPrtrFile_ != null) {
            createReq.addCodePoint(this.cpIDPrtrFile_);
        }
        createRep.addCodePoint(this.cpSplFHndl_);
        createRep.addCodePoint(this.cpCPFMsg_);
        createRep.addCodePoint(this.cpIDSplF_);
        try {
            this.conversation_.makeRequest(createReq, createRep);
        }
        catch (Exception e) {
            Trace.log(2, "Caught an Exception." + e.toString());
            throw new IOException(e.toString());
        }
        this.fCreatePending_ = false;
    }

    private synchronized void makeWriteRequest(byte[] buf, int offset, int len) throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        if (this.fCreatePending_) {
            String strDataType = NPDataAnalyzer.sniff(buf, offset, len);
            this.makeCreateRequest(strDataType);
        }
        NPDataStream writeReq = new NPDataStream(1);
        NPDataStream writeRep = new NPDataStream(1);
        NPCPData cpData = new NPCPData();
        cpData.setDataBuffer(buf, len, offset);
        writeReq.setAction(4);
        writeReq.addCodePoint(this.cpSplFHndl_);
        writeReq.addCodePoint(cpData);
        writeRep.addCodePoint(this.cpCPFMsg_);
        try {
            this.conversation_.makeRequest(writeReq, writeRep);
        }
        catch (Exception e) {
            Trace.log(2, "Caught an Exception." + e.toString());
            throw new IOException(e.toString());
        }
    }

    @Override
    public synchronized void write(byte[] data, int offset, int length) throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "SpooledFileOutputStream already closed.");
            throw new IOException();
        }
        int currentSourceOffset = offset;
        int dataLeftToSend = length;
        while (dataLeftToSend > 0) {
            int availLen = this.buffer_.length - this.offset_;
            if (availLen >= dataLeftToSend) {
                System.arraycopy(data, currentSourceOffset, this.buffer_, this.offset_, dataLeftToSend);
                currentSourceOffset += dataLeftToSend;
                this.offset_ += dataLeftToSend;
                dataLeftToSend = 0;
                continue;
            }
            if (availLen != 0) {
                System.arraycopy(data, currentSourceOffset, this.buffer_, this.offset_, availLen);
                currentSourceOffset += availLen;
                this.offset_ += availLen;
                dataLeftToSend -= availLen;
            }
            if (this.offset_ == 0) continue;
            this.makeWriteRequest(this.buffer_, 0, this.offset_);
            this.offset_ = 0;
        }
    }
}

