/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConversionMaps;
import com.ibm.as400.access.CoverLetterReader;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;

public class PTFCoverLetter {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private AS400 system_;
    private String nlv_;
    private String path_;
    private int preInstructions_;
    private int postInstructions_;
    private int ccsid_;
    public static final int SPECIAL_INSTRUCTIONS_NO = 0;
    public static final int SPECIAL_INSTRUCTIONS_YES = 1;
    public static final int SPECIAL_INSTRUCTIONS_IMMEDIATE = 2;
    public static final int SPECIAL_INSTRUCTIONS_IPL = 3;
    public static final int SPECIAL_INSTRUCTIONS_UNKNOWN = 9;

    PTFCoverLetter(AS400 system, String nlv, String path, int pre, int post) {
        this.system_ = system;
        this.nlv_ = nlv;
        this.path_ = path;
        this.preInstructions_ = pre;
        this.postInstructions_ = post;
        Enumeration locales = ConversionMaps.localeNlvMap_.keys();
        int ccsid = -1;
        while (locales.hasMoreElements() && ccsid == -1) {
            Object locale = locales.nextElement();
            Object nlver = ConversionMaps.localeNlvMap_.get(locale);
            if (!nlver.equals(this.nlv_)) continue;
            Enumeration ccsidLocales = ConversionMaps.localeCcsidMap_.keys();
            while (ccsidLocales.hasMoreElements() && ccsid == -1) {
                Object loc = ccsidLocales.nextElement();
                Object ccsidNum = ConversionMaps.localeCcsidMap_.get(loc);
                if (!loc.equals(locale)) continue;
                ccsid = Integer.parseInt((String)ccsidNum);
            }
        }
        if (ccsid == -1) {
            ccsid = this.system_.getCcsid();
        }
        this.ccsid_ = ccsid;
    }

    public Reader getContents() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return new CoverLetterReader(this.system_, this.path_, this.ccsid_);
    }

    public String getNLV() {
        return this.nlv_;
    }

    public String getPath() {
        return this.path_;
    }

    public int getPostSpecialInstructions() {
        return this.postInstructions_;
    }

    public int getPreSpecialInstructions() {
        return this.preInstructions_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public String toString() {
        return this.path_;
    }
}

