/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.xp;

import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.run.HopRunBase;

@ExtensionPoint(id="HopRunCalculateFilenameExtensionPoint", extensionPointId="HopRunCalculateFilename", description="Resolves filenames specified relative to the given project")
public class HopRunCalculateFilenameExtensionPoint
implements IExtensionPoint<HopRunBase> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, HopRunBase hopRun) throws HopException {
        try {
            String alternativeFilename;
            FileObject fileObject = HopVfs.getFileObject((String)hopRun.getRealFilename());
            if (!fileObject.exists() && (fileObject = HopVfs.getFileObject((String)(alternativeFilename = variables.resolve("${PROJECT_HOME}/" + hopRun.getFilename())))).exists()) {
                hopRun.setRealFilename(alternativeFilename);
                log.logBasic("Relative path filename specified: " + hopRun.getRealFilename());
            }
        }
        catch (Exception e) {
            throw new HopException("Error calculating filename", (Throwable)e);
        }
    }
}

