/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.formula;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.formula.FormulaData;
import org.apache.hop.pipeline.transforms.formula.FormulaMeta;
import org.apache.hop.pipeline.transforms.formula.FormulaMetaFunction;
import org.apache.hop.pipeline.transforms.formula.FormulaPoi;
import org.apache.hop.pipeline.transforms.formula.util.FormulaFieldsExtractor;
import org.apache.hop.pipeline.transforms.formula.util.FormulaParser;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;

public class Formula
extends BaseTransform<FormulaMeta, FormulaData> {
    private FormulaPoi[] poi;
    private List<String>[] formulaFieldLists;
    private final HashMap<String, String> replaceMap = new HashMap();

    public boolean init() {
        return true;
    }

    public void dispose() {
        if (this.poi != null) {
            for (FormulaPoi it : this.poi) {
                try {
                    it.destroy();
                }
                catch (IOException e) {
                    this.logError("Unable to close temporary workbook", e);
                }
            }
        }
        super.dispose();
    }

    public void batchComplete() throws HopException {
        super.batchComplete();
        for (FormulaPoi it : this.poi) {
            it.reset();
        }
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            try {
                ((FormulaData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((FormulaMeta)this.meta).getFields(((FormulaData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            }
            catch (HopTransformException e) {
                throw new RuntimeException(e);
            }
            ((FormulaData)this.data).returnType = new int[((FormulaMeta)this.meta).getFormulas().size()];
            for (int i = 0; i < ((FormulaMeta)this.meta).getFormulas().size(); ++i) {
                ((FormulaData)this.data).returnType[i] = -1;
            }
            ((FormulaData)this.data).replaceIndex = new int[((FormulaMeta)this.meta).getFormulas().size()];
            for (int j = 0; j < ((FormulaMeta)this.meta).getFormulas().size(); ++j) {
                FormulaMetaFunction fn = ((FormulaMeta)this.meta).getFormulas().get(j);
                if (!Utils.isEmpty((CharSequence)fn.getReplaceField())) {
                    ((FormulaData)this.data).replaceIndex[j] = ((FormulaData)this.data).outputRowMeta.indexOfValue(fn.getReplaceField());
                    this.replaceMap.put(fn.getFieldName(), fn.getReplaceField());
                    if (((FormulaData)this.data).replaceIndex[j] >= 0) continue;
                    throw new HopException("Unknown field specified to replace with a formula result: [" + fn.getReplaceField() + "]");
                }
                ((FormulaData)this.data).replaceIndex[j] = -1;
            }
            this.poi = (FormulaPoi[])IntStream.range(0, ((FormulaMeta)this.meta).getFormulas().size()).mapToObj(it -> new FormulaPoi(arg_0 -> ((Formula)this).logDebug(arg_0))).toArray(FormulaPoi[]::new);
            this.formulaFieldLists = (List[])((FormulaMeta)this.meta).getFormulas().stream().map(FormulaMetaFunction::getFormula).map(f -> FormulaFieldsExtractor.getFormulaFieldList(this.resolve((String)f))).toArray(List[]::new);
        }
        int tempIndex = this.getInputRowMeta().size();
        if (this.isRowLevel()) {
            this.logRowlevel("Read row #" + this.getLinesRead() + " : " + Arrays.toString(r));
        }
        Object[] outputRowData = RowDataUtil.resizeArray((Object[])r, (int)((FormulaData)this.data).outputRowMeta.size());
        Object outputValue = null;
        for (int i = 0; i < ((FormulaMeta)this.meta).getFormulas().size(); ++i) {
            FormulaMetaFunction formula = ((FormulaMeta)this.meta).getFormulas().get(i);
            FormulaParser parser = new FormulaParser(formula, ((FormulaData)this.data).outputRowMeta, outputRowData, this.poi[i], this.variables, this.replaceMap, this.formulaFieldLists[i]);
            try {
                CellValue cellValue = parser.getFormulaValue();
                CellType cellType = cellValue.getCellType();
                int outputValueType = formula.getValueType();
                block2 : switch (cellType) {
                    case BLANK: {
                        break;
                    }
                    case NUMERIC: {
                        outputValue = cellValue.getNumberValue();
                        switch (outputValueType) {
                            case 1: {
                                ((FormulaData)this.data).returnType[i] = 1;
                                formula.setNeedDataConversion(outputValueType != 1);
                                break block2;
                            }
                            case 5: {
                                ((FormulaData)this.data).returnType[i] = 2;
                                formula.setNeedDataConversion(outputValueType != 1);
                                break block2;
                            }
                            case 6: {
                                ((FormulaData)this.data).returnType[i] = 5;
                                formula.setNeedDataConversion(outputValueType != 1);
                                break block2;
                            }
                            case 3: {
                                outputValue = DateUtil.getJavaDate((double)cellValue.getNumberValue());
                                ((FormulaData)this.data).returnType[i] = 4;
                                formula.setNeedDataConversion(outputValueType != 1);
                                break block2;
                            }
                            case 9: {
                                outputValue = Timestamp.from(DateUtil.getJavaDate((double)cellValue.getNumberValue()).toInstant());
                                ((FormulaData)this.data).returnType[i] = 9;
                                formula.setNeedDataConversion(outputValueType != 1);
                                break block2;
                            }
                        }
                        break;
                    }
                    case BOOLEAN: {
                        outputValue = cellValue.getBooleanValue();
                        ((FormulaData)this.data).returnType[i] = 7;
                        formula.setNeedDataConversion(outputValueType != 4);
                        break;
                    }
                    case STRING: {
                        outputValue = cellValue.getStringValue();
                        ((FormulaData)this.data).returnType[i] = 0;
                        formula.setNeedDataConversion(outputValueType != 2);
                        break;
                    }
                }
                int realIndex = ((FormulaData)this.data).replaceIndex[i] < 0 ? tempIndex++ : ((FormulaData)this.data).replaceIndex[i];
                outputRowData[realIndex] = this.getReturnValue(outputValue, ((FormulaData)this.data).returnType[i], realIndex, formula);
                continue;
            }
            catch (Exception e) {
                throw new HopException("Formula '" + formula.getFormula() + "' could not not be parsed ", (Throwable)e);
            }
        }
        this.putRow(((FormulaData)this.data).outputRowMeta, outputRowData);
        if (this.isRowLevel()) {
            this.logRowlevel("Wrote row #" + this.getLinesWritten() + " : " + Arrays.toString(r));
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        return true;
    }

    public Formula(TransformMeta transformMeta, FormulaMeta meta, FormulaData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    protected Object getReturnValue(Object formulaResult, int returnType, int realIndex, FormulaMetaFunction fn) throws HopException {
        if (formulaResult == null) {
            return null;
        }
        Object value = null;
        switch (returnType) {
            case 0: {
                if (fn.isNeedDataConversion()) {
                    value = this.convertDataToTargetValueMeta(realIndex, formulaResult);
                    break;
                }
                value = formulaResult.toString();
                break;
            }
            case 1: {
                if (fn.isNeedDataConversion()) {
                    value = this.convertDataToTargetValueMeta(realIndex, formulaResult);
                    break;
                }
                value = ((Number)formulaResult).doubleValue();
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                if (fn.isNeedDataConversion()) {
                    value = this.convertDataToTargetValueMeta(realIndex, formulaResult);
                    break;
                }
                value = formulaResult;
                break;
            }
            case 6: 
            case 7: {
                value = formulaResult;
                break;
            }
        }
        return value;
    }

    private Object convertDataToTargetValueMeta(int i, Object formulaResult) throws HopException {
        if (formulaResult == null) {
            return formulaResult;
        }
        IValueMeta target = ((FormulaData)this.data).outputRowMeta.getValueMeta(i);
        IValueMeta actual = ValueMetaFactory.guessValueMetaInterface((Object)formulaResult);
        return target.convertData(actual, formulaResult);
    }
}

