/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.schemamapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.schemamapping.SchemaMappingField;
import org.apache.hop.pipeline.transforms.schemamapping.SchemaMappingMeta;
import org.apache.hop.staticschema.metadata.SchemaDefinition;
import org.apache.hop.staticschema.metadata.SchemaFieldDefinition;
import org.apache.hop.staticschema.util.SchemaDefinitionUtil;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SchemaMappingDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = SchemaMappingDialog.class;
    private final SchemaMappingMeta input;
    private MetaSelectionLine<SchemaDefinition> wSchemaDefinition;
    private ColumnInfo[] ciFields;
    private TableView wMappingFields;
    private Button wGetFields;
    private Button wDoMapping;
    private final List<ColumnInfo> schemaFieldColumns = new ArrayList<ColumnInfo>();
    private final List<String> inputFields = new ArrayList<String>();

    public SchemaMappingDialog(Shell parent, IVariables variables, SchemaMappingMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchemaMappingDialog.this.input.setChanged();
                SchemaMappingDialog.this.fillStaticSchemaFieldset();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SchemaMappingDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"SchemaMappingDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wSchemaDefinition = new MetaSelectionLine(this.variables, this.metadataProvider, SchemaDefinition.class, (Composite)this.shell, 0, BaseMessages.getString(PKG, (String)"SchemaMappingDialog.SchemaDefinition.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SchemaMappingDialog.SchemaDefinition.Tooltip", (String[])new String[0]));
        PropsUi.setLook(this.wSchemaDefinition);
        FormData fdSchemaDefinition = new FormData();
        fdSchemaDefinition.left = new FormAttachment(0, 0);
        fdSchemaDefinition.top = new FormAttachment((Control)this.wTransformName, margin);
        fdSchemaDefinition.right = new FormAttachment(100, 0);
        this.wSchemaDefinition.setLayoutData((Object)fdSchemaDefinition);
        try {
            this.wSchemaDefinition.fillItems();
        }
        catch (Exception e2) {
            this.log.logError("Error getting schema definition items", (Throwable)e2);
        }
        this.wSchemaDefinition.addSelectionListener((SelectionListener)lsSelection);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.buildMappingTable(lsMod, margin);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.setSchemaFieldCombo();
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel.addListener(13, e -> this.cancel());
        this.wGetFields.addListener(13, e -> this.get());
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void fillStaticSchemaFieldset() {
        String schemaName = this.wSchemaDefinition.getText();
        if (!Utils.isEmpty((CharSequence)schemaName)) {
            try {
                SchemaDefinition schemaDefinition = new SchemaDefinitionUtil().loadSchemaDefinition(this.metadataProvider, schemaName);
                if (schemaDefinition != null) {
                    List fieldDefinitions = schemaDefinition.getFieldDefinitions();
                    this.wMappingFields.table.removeAll();
                    this.wMappingFields.table.setItemCount(fieldDefinitions.size());
                    for (int i = 0; i < fieldDefinitions.size(); ++i) {
                        SchemaFieldDefinition sfd = (SchemaFieldDefinition)fieldDefinitions.get(i);
                        TableItem item = this.wMappingFields.table.getItem(i);
                        if (sfd.getName() == null) continue;
                        item.setText(1, sfd.getName());
                    }
                }
            }
            catch (HopTransformException hopTransformException) {
                // empty catch block
            }
        }
    }

    private void buildMappingTable(ModifyListener lsMod, int margin) {
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"SchemaMappingDialog.MappingFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlUpIns = new FormData();
        fdlUpIns.left = new FormAttachment(0, 0);
        fdlUpIns.top = new FormAttachment(this.wSchemaDefinition, margin);
        wlFields.setLayoutData((Object)fdlUpIns);
        int tableCols = 2;
        int upInsRows = this.input.getMappingFieldset() != null && !this.input.getMappingFieldset().equals(Collections.emptyList()) ? this.input.getMappingFieldset().size() : 1;
        this.ciFields = new ColumnInfo[tableCols];
        this.ciFields[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SchemaMappingDialog.ColumnInfo.SchemaField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciFields[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SchemaMappingDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.schemaFieldColumns.add(this.ciFields[0]);
        this.wMappingFields = new TableView(this.variables, (Composite)this.shell, 68354, this.ciFields, upInsRows, lsMod, this.props);
        this.wGetFields = new Button((Composite)this.shell, 8);
        this.wGetFields.setText(BaseMessages.getString(PKG, (String)"SchemaMappingDialog.GetFields.Button", (String[])new String[0]));
        FormData fdGetFields = new FormData();
        fdGetFields.top = new FormAttachment((Control)wlFields, margin);
        fdGetFields.right = new FormAttachment(100, 0);
        this.wGetFields.setLayoutData((Object)fdGetFields);
        this.wDoMapping = new Button((Composite)this.shell, 8);
        this.wDoMapping.setText(BaseMessages.getString(PKG, (String)"SchemaMappingDialog.DoMapping.Button", (String[])new String[0]));
        FormData fdDoMapping = new FormData();
        fdDoMapping.top = new FormAttachment((Control)this.wGetFields, margin);
        fdDoMapping.right = new FormAttachment(100, 0);
        this.wDoMapping.setLayoutData((Object)fdDoMapping);
        this.wDoMapping.addListener(13, arg0 -> this.generateMappings());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment((Control)this.wDoMapping, -margin);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wMappingFields.setLayoutData((Object)fdFields);
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wMappingFields, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SchemaMappingDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SchemaMappingDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.ciFields[1].setComboValues(fieldNames);
    }

    private void setSchemaFieldCombo() {
        Runnable fieldLoader = () -> {
            block7: {
                if (!this.wSchemaDefinition.isDisposed()) {
                    String schemaName = this.wSchemaDefinition.getText();
                    for (ColumnInfo colInfo : this.schemaFieldColumns) {
                        colInfo.setComboValues(new String[0]);
                    }
                    if (!Utils.isEmpty((CharSequence)schemaName)) {
                        try {
                            String[] fieldNames;
                            IRowMeta r;
                            SchemaDefinition schemaDefinition = new SchemaDefinitionUtil().loadSchemaDefinition(this.metadataProvider, schemaName);
                            if (schemaDefinition == null || null == (r = schemaDefinition.getRowMeta()) || null == (fieldNames = r.getFieldNames())) break block7;
                            for (ColumnInfo colInfo : this.schemaFieldColumns) {
                                colInfo.setComboValues(fieldNames);
                            }
                        }
                        catch (HopPluginException | HopTransformException e) {
                            for (ColumnInfo colInfo : this.schemaFieldColumns) {
                                colInfo.setComboValues(new String[0]);
                            }
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    private void generateMappings() {
        IRowMeta sourceFields;
        try {
            sourceFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SchemaMappingDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SchemaMappingDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String schemaName = this.variables.resolve(this.wSchemaDefinition.getText());
        if (!Utils.isEmpty((CharSequence)schemaName)) {
            EnterMappingDialog d;
            IRowMeta targetFields;
            try {
                SchemaDefinition schemaDefinition = new SchemaDefinitionUtil().loadSchemaDefinition(this.metadataProvider, schemaName);
                targetFields = schemaDefinition.getRowMeta();
            }
            catch (HopException e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SchemaMappingDialog.DoMapping.UnableToFindSchemaFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SchemaMappingDialog.DoMapping.UnableToFindSchemaFields.Message", (String[])new String[0]), (Exception)((Object)e));
                return;
            }
            String[] inputNames = new String[sourceFields.size()];
            for (int i = 0; i < sourceFields.size(); ++i) {
                IValueMeta value = sourceFields.getValueMeta(i);
                inputNames[i] = value.getName();
            }
            List<SourceToTargetMapping> mappings = new ArrayList();
            StringBuilder missingSourceFields = new StringBuilder();
            StringBuilder missingTargetFields = new StringBuilder();
            int nrFields = this.wMappingFields.nrNonEmpty();
            for (int i = 0; i < nrFields; ++i) {
                int targetIndex;
                TableItem item = this.wMappingFields.getNonEmpty(i);
                String source = item.getText(2);
                String target = item.getText(1);
                int sourceIndex = sourceFields.indexOfValue(source);
                if (sourceIndex < 0) {
                    missingSourceFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
                }
                if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                    missingTargetFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
                }
                if (sourceIndex < 0 || targetIndex < 0) continue;
                SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
                mappings.add(mapping);
            }
            if (!missingSourceFields.isEmpty() || !missingTargetFields.isEmpty()) {
                boolean goOn;
                Object message = "";
                if (!missingSourceFields.isEmpty()) {
                    message = (String)message + BaseMessages.getString(PKG, (String)"SchemaMappingDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
                }
                if (!missingTargetFields.isEmpty()) {
                    message = (String)message + BaseMessages.getString(PKG, (String)"SchemaMappingDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
                }
                message = (String)message + Const.CR;
                message = (String)message + BaseMessages.getString(PKG, (String)"SchemaMappingDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
                int answer = BaseDialog.openMessageBox((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"SchemaMappingDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message, (int)196);
                boolean bl = goOn = (answer & 0x40) != 0;
                if (!goOn) {
                    return;
                }
            }
            if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
                this.wMappingFields.table.removeAll();
                this.wMappingFields.table.setItemCount(mappings.size());
                for (int i = 0; i < mappings.size(); ++i) {
                    SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                    TableItem item = this.wMappingFields.table.getItem(i);
                    item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                    item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
                }
                this.wMappingFields.setRowNums();
                this.wMappingFields.optWidth(true);
                this.input.setChanged(this.changed);
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"SchemaMappingDialog.DoMapping.SchemaNameNotProvided.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"SchemaMappingDialog.DoMapping.SchemaNameNotProvided.Title", (String[])new String[0]));
            mb.open();
        }
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo();
        this.dispose();
    }

    public void getData() {
        if (!Utils.isEmpty((CharSequence)this.input.getSchemaName())) {
            this.wSchemaDefinition.setText(this.input.getSchemaName());
        }
        if (this.input.getMappingFieldset() != null) {
            for (int i = 0; i < this.input.getMappingFieldset().size(); ++i) {
                SchemaMappingField mf = this.input.getMappingFieldset().get(i);
                TableItem item = this.wMappingFields.table.getItem(i);
                if (mf.getFieldSchemaDefinition() != null) {
                    item.setText(1, mf.getFieldSchemaDefinition());
                }
                if (mf.getFieldStream() == null) continue;
                item.setText(2, mf.getFieldStream());
            }
        }
    }

    private void getInfo() {
        this.input.setSchemaName(this.wSchemaDefinition.getText());
        int nrRows = this.wMappingFields.nrNonEmpty();
        HashMap<String, SchemaMappingField> smfMap = new HashMap<String, SchemaMappingField>();
        for (int i = 0; i < nrRows; ++i) {
            TableItem item = this.wMappingFields.getNonEmpty(i);
            SchemaMappingField sf = new SchemaMappingField(item.getText(1), Const.NVL((String)item.getText(2), (String)""));
            smfMap.put(item.getText(1), sf);
        }
        String schemaName = this.variables.resolve(this.wSchemaDefinition.getText());
        if (!Utils.isEmpty((CharSequence)schemaName)) {
            try {
                SchemaDefinition schemaDefinition = new SchemaDefinitionUtil().loadSchemaDefinition(this.metadataProvider, schemaName);
                if (this.input.getMappingFieldset() != null) {
                    this.input.getMappingFieldset().clear();
                }
                ArrayList staticFieldset = (ArrayList)schemaDefinition.getFieldDefinitions();
                for (int i = 0; i < staticFieldset.size(); ++i) {
                    SchemaFieldDefinition sfItem = (SchemaFieldDefinition)staticFieldset.get(i);
                    if (smfMap.get(sfItem.getName()) == null) continue;
                    this.input.getMappingFieldset().add((SchemaMappingField)smfMap.get(sfItem.getName()));
                }
            }
            catch (HopException e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SchemaMappingDialog.DoMapping.UnableToFindSchemaFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SchemaMappingDialog.DoMapping.UnableToFindSchemaFields.Message", (String[])new String[0]), (Exception)((Object)e));
                return;
            }
        }
        this.transformName = this.wTransformName.getText();
    }
}

