/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.fixed;

import java.util.stream.Stream;
import org.eclipse.collections.api.factory.list.FixedSizeListFactory;
import org.eclipse.collections.api.list.FixedSizeList;
import org.eclipse.collections.impl.list.fixed.ArrayAdapter;
import org.eclipse.collections.impl.list.fixed.DoubletonList;
import org.eclipse.collections.impl.list.fixed.EmptyList;
import org.eclipse.collections.impl.list.fixed.QuadrupletonList;
import org.eclipse.collections.impl.list.fixed.QuintupletonList;
import org.eclipse.collections.impl.list.fixed.SextupletonList;
import org.eclipse.collections.impl.list.fixed.SingletonList;
import org.eclipse.collections.impl.list.fixed.TripletonList;
import org.eclipse.collections.impl.utility.Iterate;

public class FixedSizeListFactoryImpl
implements FixedSizeListFactory {
    public static final FixedSizeListFactory INSTANCE = new FixedSizeListFactoryImpl();
    private static final FixedSizeList<?> EMPTY_LIST = new EmptyList();

    public <T> FixedSizeList<T> empty() {
        return EMPTY_LIST;
    }

    public <T> FixedSizeList<T> of() {
        return this.empty();
    }

    public <T> FixedSizeList<T> with() {
        return this.empty();
    }

    public <T> FixedSizeList<T> of(T one) {
        return this.with(one);
    }

    public <T> FixedSizeList<T> with(T one) {
        return new SingletonList<T>(one);
    }

    public <T> FixedSizeList<T> of(T one, T two) {
        return this.with(one, two);
    }

    public <T> FixedSizeList<T> with(T one, T two) {
        return new DoubletonList<T>(one, two);
    }

    public <T> FixedSizeList<T> of(T one, T two, T three) {
        return this.with(one, two, three);
    }

    public <T> FixedSizeList<T> with(T one, T two, T three) {
        return new TripletonList<T>(one, two, three);
    }

    public <T> FixedSizeList<T> of(T one, T two, T three, T four) {
        return this.with(one, two, three, four);
    }

    public <T> FixedSizeList<T> with(T one, T two, T three, T four) {
        return new QuadrupletonList<T>(one, two, three, four);
    }

    public <T> FixedSizeList<T> of(T one, T two, T three, T four, T five) {
        return this.with(one, two, three, four, five);
    }

    public <T> FixedSizeList<T> with(T one, T two, T three, T four, T five) {
        return new QuintupletonList<T>(one, two, three, four, five);
    }

    public <T> FixedSizeList<T> of(T one, T two, T three, T four, T five, T six) {
        return this.with(one, two, three, four, five, six);
    }

    public <T> FixedSizeList<T> with(T one, T two, T three, T four, T five, T six) {
        return new SextupletonList<T>(one, two, three, four, five, six);
    }

    public <T> FixedSizeList<T> of(T ... items) {
        return this.with(items);
    }

    public <T> FixedSizeList<T> with(T ... items) {
        switch (items.length) {
            case 0: {
                return this.of();
            }
            case 1: {
                return this.of(items[0]);
            }
            case 2: {
                return this.of(items[0], items[1]);
            }
            case 3: {
                return this.of(items[0], items[1], items[2]);
            }
            case 4: {
                return this.of(items[0], items[1], items[2], items[3]);
            }
            case 5: {
                return this.of(items[0], items[1], items[2], items[3], items[4]);
            }
            case 6: {
                return this.of(items[0], items[1], items[2], items[3], items[4], items[5]);
            }
        }
        return ArrayAdapter.newArrayWith(items);
    }

    public <T> FixedSizeList<T> ofAll(Iterable<? extends T> items) {
        return this.withAll(items);
    }

    public <T> FixedSizeList<T> withAll(Iterable<? extends T> items) {
        return this.of(Iterate.toArray(items));
    }

    public <T> FixedSizeList<T> fromStream(Stream<? extends T> stream) {
        return this.of(stream.toArray());
    }
}

