/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mongo.wrapper;

import com.mongodb.BasicDBList;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ReplicaSetStatus;
import com.mongodb.ServerAddress;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.mongo.MongoDbException;
import org.apache.hop.mongo.MongoProp;
import org.apache.hop.mongo.MongoProperties;
import org.apache.hop.mongo.MongoUtilLogger;
import org.apache.hop.mongo.Util;
import org.apache.hop.mongo.wrapper.DefaultMongoClientFactory;
import org.apache.hop.mongo.wrapper.MongoClientFactory;
import org.apache.hop.mongo.wrapper.MongoClientWrapper;
import org.apache.hop.mongo.wrapper.MongoDBAction;
import org.apache.hop.mongo.wrapper.collection.DefaultMongoCollectionWrapper;
import org.apache.hop.mongo.wrapper.collection.MongoCollectionWrapper;
import org.bson.Document;
import org.bson.conversions.Bson;

class NoAuthMongoClientWrapper
implements MongoClientWrapper {
    private static final Class<?> PKG = NoAuthMongoClientWrapper.class;
    public static final int MONGO_DEFAULT_PORT = 27017;
    public static final String LOCAL_DB = "local";
    public static final String REPL_SET_COLLECTION = "system.replset";
    public static final String REPL_SET_SETTINGS = "settings";
    public static final String REPL_SET_LAST_ERROR_MODES = "getLastErrorModes";
    public static final String REPL_SET_MEMBERS = "members";
    public static final String CONST_MONGO_NO_AUTH_WRAPPER_MESSAGE_WARNING_NO_REPLICA_SET_MEMBERS_DEFINED = "MongoNoAuthWrapper.Message.Warning.NoReplicaSetMembersDefined";
    static MongoClientFactory clientFactory = new DefaultMongoClientFactory();
    private final MongoClient mongo;
    private final MongoUtilLogger log;
    protected MongoProperties props;

    NoAuthMongoClientWrapper(MongoProperties props, MongoUtilLogger log) throws MongoDbException {
        this.log = log;
        this.props = props;
        this.mongo = this.getClient(props.buildMongoClientOptions(log));
    }

    NoAuthMongoClientWrapper(MongoClient mongo, MongoProperties props, MongoUtilLogger log) {
        this.mongo = mongo;
        this.log = log;
        this.props = props;
    }

    MongoClient getMongo() {
        return this.mongo;
    }

    @Override
    public void test() throws MongoDbException {
        String databaseName = this.props.get(MongoProp.DBNAME);
        try {
            this.mongo.getDatabase(databaseName).runCommand((Bson)new Document("ping", (Object)1));
        }
        catch (Exception e) {
            throw new MongoDbException("Error pinging database " + databaseName, e);
        }
    }

    private List<ServerAddress> getServerAddressList() throws MongoDbException {
        String[] parts;
        String hostsPorts = this.props.get(MongoProp.HOST);
        String singlePort = this.props.get(MongoProp.PORT);
        int singlePortI = -1;
        try {
            singlePortI = Integer.parseInt(singlePort);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (Util.isEmpty(hostsPorts)) {
            throw new MongoDbException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.Error.EmptyHostsString", (String[])new String[0]));
        }
        ArrayList<ServerAddress> serverList = new ArrayList<ServerAddress>();
        for (String part : parts = hostsPorts.trim().split(",")) {
            int port = singlePortI != -1 ? singlePortI : 27017;
            String[] hp = part.split(":");
            if (hp.length > 2) {
                throw new MongoDbException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.Error.MalformedHost", (String[])new String[]{part}));
            }
            String host = hp[0];
            if (hp.length == 2) {
                try {
                    port = Integer.parseInt(hp[1].trim());
                }
                catch (NumberFormatException n) {
                    throw new MongoDbException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.Error.UnableToParsePortNumber", (String[])new String[]{hp[1]}));
                }
            }
            try {
                ServerAddress s = new ServerAddress(host, port);
                serverList.add(s);
            }
            catch (Throwable u) {
                throw new MongoDbException(u);
            }
        }
        return serverList;
    }

    protected MongoClient getClient(MongoClientOptions opts) throws MongoDbException {
        List<MongoCredential> credList = this.getCredentialList();
        List<ServerAddress> serverAddressList = this.getServerAddressList();
        if (serverAddressList.isEmpty()) {
            throw new MongoDbException(BaseMessages.getString(MongoClientWrapper.class, (String)"MongoNoAuthWrapper.Message.Error.NoHostSet", (String[])new String[0]));
        }
        return this.getClientFactory(this.props).getMongoClient(serverAddressList, credList, opts, this.props.useAllReplicaSetMembers());
    }

    @Override
    public List<String> getDatabaseNames() throws MongoDbException {
        try {
            return this.getMongo().getDatabaseNames();
        }
        catch (Exception e) {
            throw new MongoDbException(e);
        }
    }

    protected DB getDb(String dbName) throws MongoDbException {
        try {
            return this.getMongo().getDB(dbName);
        }
        catch (Exception e) {
            throw new MongoDbException(e);
        }
    }

    @Override
    public Set<String> getCollectionsNames(String dB) throws MongoDbException {
        try {
            return this.getDb(dB).getCollectionNames();
        }
        catch (Exception e) {
            if (e instanceof MongoDbException) {
                MongoDbException mongoDbException = (MongoDbException)e;
                throw mongoDbException;
            }
            throw new MongoDbException(e);
        }
    }

    @Override
    public List<String> getLastErrorModes() throws MongoDbException {
        ArrayList<String> customLastErrorModes = new ArrayList<String>();
        DB local = this.getDb(LOCAL_DB);
        if (local != null) {
            try {
                DBCollection replset = local.getCollection(REPL_SET_COLLECTION);
                if (replset != null) {
                    DBObject config = replset.findOne();
                    this.extractLastErrorModes(config, customLastErrorModes);
                }
            }
            catch (Exception e) {
                throw new MongoDbException(e);
            }
        }
        return customLastErrorModes;
    }

    protected void extractLastErrorModes(DBObject config, List<String> customLastErrorModes) {
        Object getLastErrModes;
        Object settings;
        if (config != null && (settings = config.get(REPL_SET_SETTINGS)) != null && (getLastErrModes = ((DBObject)settings).get(REPL_SET_LAST_ERROR_MODES)) != null) {
            for (String m : ((DBObject)getLastErrModes).keySet()) {
                customLastErrorModes.add(m);
            }
        }
    }

    @Override
    public List<String> getIndexInfo(String dbName, String collection) throws MongoDbException {
        try {
            DBCollection coll;
            DB db = this.getDb(dbName);
            if (db == null) {
                throw new MongoDbException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.NonExistentDB", (String[])new String[]{dbName}));
            }
            if (Util.isEmpty(collection)) {
                throw new MongoDbException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.NoCollectionSpecified", (String[])new String[0]));
            }
            if (!db.collectionExists(collection)) {
                db.createCollection(collection, null);
            }
            if ((coll = db.getCollection(collection)) == null) {
                throw new MongoDbException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.UnableToGetInfoForCollection", (String[])new String[]{collection}));
            }
            List collInfo = coll.getIndexInfo();
            ArrayList<String> result = new ArrayList<String>();
            if (Utils.isEmpty((Collection)collInfo)) {
                throw new MongoDbException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.UnableToGetInfoForCollection", (String[])new String[]{collection}));
            }
            for (DBObject index : collInfo) {
                result.add(index.toString());
            }
            return result;
        }
        catch (Exception e) {
            this.log.error(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.GeneralError.Message", (String[])new String[0]) + ":\n\n" + e.getMessage(), e);
            if (e instanceof MongoDbException) {
                MongoDbException mongoDbException = (MongoDbException)e;
                throw mongoDbException;
            }
            throw new MongoDbException(e);
        }
    }

    @Override
    public List<String> getAllTags() throws MongoDbException {
        return this.setupAllTags(this.getRepSetMemberRecords());
    }

    private BasicDBList getRepSetMemberRecords() throws MongoDbException {
        BasicDBList setMembers = null;
        try {
            DB local = this.getDb(LOCAL_DB);
            if (local != null) {
                DBCollection replset = local.getCollection(REPL_SET_COLLECTION);
                if (replset != null) {
                    DBObject config = replset.findOne();
                    if (config != null) {
                        Object members = config.get(REPL_SET_MEMBERS);
                        if (members instanceof BasicDBList) {
                            BasicDBList basicDBList = (BasicDBList)members;
                            if (basicDBList.isEmpty()) {
                                this.logInfo(BaseMessages.getString(PKG, (String)CONST_MONGO_NO_AUTH_WRAPPER_MESSAGE_WARNING_NO_REPLICA_SET_MEMBERS_DEFINED, (String[])new String[0]));
                            } else {
                                setMembers = (BasicDBList)members;
                            }
                        } else {
                            this.logInfo(BaseMessages.getString(PKG, (String)CONST_MONGO_NO_AUTH_WRAPPER_MESSAGE_WARNING_NO_REPLICA_SET_MEMBERS_DEFINED, (String[])new String[0]));
                        }
                    } else {
                        this.logInfo(BaseMessages.getString(PKG, (String)CONST_MONGO_NO_AUTH_WRAPPER_MESSAGE_WARNING_NO_REPLICA_SET_MEMBERS_DEFINED, (String[])new String[0]));
                    }
                } else {
                    this.logInfo(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.Warning.ReplicaSetCollectionUnavailable", (String[])new String[0]));
                }
            } else {
                this.logInfo(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.Warning.LocalDBNotAvailable", (String[])new String[0]));
            }
        }
        catch (Exception ex) {
            throw new MongoDbException(ex);
        }
        finally {
            if (this.getMongo() != null) {
                this.getMongo().close();
            }
        }
        return setMembers;
    }

    private void logInfo(String message) {
        if (this.log != null) {
            this.log.info(message);
        }
    }

    protected List<String> setupAllTags(BasicDBList members) {
        HashSet<CallSite> tempTags = new HashSet<CallSite>();
        if (!Utils.isEmpty((Collection)members)) {
            for (Object member : members) {
                DBObject tags;
                if (member == null || (tags = (DBObject)((DBObject)member).get("tags")) == null) continue;
                for (String tagName : tags.keySet()) {
                    String tagVal = tags.get(tagName).toString();
                    String combined = NoAuthMongoClientWrapper.quote(tagName) + " : " + NoAuthMongoClientWrapper.quote(tagVal);
                    tempTags.add((CallSite)((Object)combined));
                }
            }
        }
        return new ArrayList<String>(tempTags);
    }

    protected static String quote(String string) {
        if (((String)string).indexOf(34) >= 0) {
            string = ((String)string).replace("\"", "\\\"");
        }
        string = "\"" + (String)string + "\"";
        return string;
    }

    @Override
    public List<String> getReplicaSetMembersThatSatisfyTagSets(List<DBObject> tagSets) throws MongoDbException {
        try {
            ArrayList<String> result = new ArrayList<String>();
            for (DBObject object : this.checkForReplicaSetMembersThatSatisfyTagSets(tagSets, this.getRepSetMemberRecords())) {
                result.add(object.toString());
            }
            return result;
        }
        catch (Exception ex) {
            if (ex instanceof MongoDbException) {
                MongoDbException mongoDbException = (MongoDbException)ex;
                throw mongoDbException;
            }
            throw new MongoDbException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.UnableToGetReplicaSetMembers", (String[])new String[0]), ex);
        }
    }

    protected List<DBObject> checkForReplicaSetMembersThatSatisfyTagSets(List<DBObject> tagSets, BasicDBList members) {
        ArrayList<DBObject> satisfy = new ArrayList<DBObject>();
        if (!Utils.isEmpty((Collection)members)) {
            for (Object m : members) {
                DBObject tags;
                if (m == null || (tags = (DBObject)((DBObject)m).get("tags")) == null) continue;
                for (DBObject toMatch : tagSets) {
                    boolean match = true;
                    for (String tagName : toMatch.keySet()) {
                        String tagValue = toMatch.get(tagName).toString();
                        Object matchVal = tags.get(tagName);
                        if (matchVal == null) {
                            match = false;
                            break;
                        }
                        if (matchVal.toString().equals(tagValue)) continue;
                        match = false;
                        break;
                    }
                    if (!match || satisfy.contains(m)) continue;
                    satisfy.add((DBObject)m);
                }
            }
        }
        return satisfy;
    }

    @Override
    public MongoCollectionWrapper getCollection(String db, String name) throws MongoDbException {
        return this.wrap(this.getDb(db).getCollection(name));
    }

    @Override
    public MongoCollectionWrapper createCollection(String db, String name) throws MongoDbException {
        return this.wrap(this.getDb(db).createCollection(name, null));
    }

    @Override
    public List<MongoCredential> getCredentialList() {
        return new ArrayList<MongoCredential>();
    }

    protected MongoCollectionWrapper wrap(DBCollection collection) {
        return new DefaultMongoCollectionWrapper(collection);
    }

    @Override
    public void dispose() {
        this.getMongo().close();
    }

    @Override
    public ReplicaSetStatus getReplicaSetStatus() {
        return this.getMongo().getReplicaSetStatus();
    }

    @Override
    public <ReturnType> ReturnType perform(String db, MongoDBAction<ReturnType> action) throws MongoDbException {
        return action.perform(this.getDb(db));
    }

    public MongoClientFactory getClientFactory(MongoProperties opts) {
        return clientFactory;
    }
}

