/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mongo;

import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.mongo.MongoDbException;
import org.apache.hop.mongo.MongoProp;
import org.apache.hop.mongo.MongoProperties;
import org.apache.hop.mongo.MongoUtilLogger;
import org.apache.hop.mongo.NamedReadPreference;
import org.apache.hop.mongo.Util;

class MongoPropToOption {
    private static final Class<?> PKG = MongoPropToOption.class;
    private MongoUtilLogger log;

    MongoPropToOption(MongoUtilLogger log) {
        this.log = log;
    }

    public int intValue(String value, int defaultVal) {
        if (!Util.isEmpty(value)) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException n) {
                this.logWarn(BaseMessages.getString(PKG, (String)"MongoPropToOption.Warning.Message.NumberFormat", (String[])new String[]{value, Integer.toString(defaultVal)}));
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public long longValue(String value, long defaultVal) {
        if (!Util.isEmpty(value)) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException n) {
                this.logWarn(BaseMessages.getString(PKG, (String)"MongoPropToOption.Warning.Message.NumberFormat", (String[])new String[]{value, Long.toString(defaultVal)}));
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public boolean boolValue(String value, boolean defaultVal) {
        if (!Util.isEmpty(value)) {
            return Boolean.parseBoolean(value);
        }
        return defaultVal;
    }

    public ReadPreference readPrefValue(MongoProperties props) throws MongoDbException {
        String readPreference = props.get(MongoProp.readPreference);
        if (Util.isEmpty(readPreference)) {
            return null;
        }
        Object[] tagSets = this.getTagSets(props);
        NamedReadPreference preference = NamedReadPreference.byName(readPreference);
        if (preference == null) {
            throw new MongoDbException(BaseMessages.getString(PKG, (String)"MongoPropToOption.ErrorMessage.ReadPreferenceNotFound", (String[])new String[]{readPreference, this.getPrettyListOfValidPreferences()}));
        }
        this.logInfo(BaseMessages.getString(PKG, (String)"MongoPropToOption.Message.UsingReadPreference", (String[])new String[]{preference.getName()}));
        if (preference == NamedReadPreference.PRIMARY && tagSets.length > 0) {
            this.logWarn(BaseMessages.getString(PKG, (String)"MongoPropToOption.Message.Warning.PrimaryReadPrefWithTagSets", (String[])new String[0]));
            return preference.getPreference();
        }
        if (tagSets.length > 0) {
            this.logInfo(BaseMessages.getString(PKG, (String)"MongoPropToOption.Message.UsingReadPreferenceTagSets", (String[])new String[]{Arrays.toString(tagSets)}));
            DBObject[] remainder = tagSets.length > 1 ? (DBObject[])Arrays.copyOfRange(tagSets, 1, tagSets.length) : new DBObject[]{};
            return preference.getTaggableReadPreference((DBObject)tagSets[0], remainder);
        }
        this.logInfo(BaseMessages.getString(PKG, (String)"MongoPropToOption.Message.NoReadPreferenceTagSetsDefined", (String[])new String[0]));
        return preference.getPreference();
    }

    private String getPrettyListOfValidPreferences() {
        return Arrays.toString(new ArrayList<String>(NamedReadPreference.getPreferenceNames()).toArray());
    }

    DBObject[] getTagSets(MongoProperties props) throws MongoDbException {
        Object tagSet = props.get(MongoProp.tagSet);
        if (tagSet != null) {
            if (!((String)tagSet).trim().startsWith("[")) {
                tagSet = "[" + (String)tagSet + "]";
            }
            try {
                BasicDBList list = (BasicDBList)JSON.parse((String)tagSet);
                return (DBObject[])list.toArray((Object[])new DBObject[list.size()]);
            }
            catch (Exception parseException) {
                throw new MongoDbException(BaseMessages.getString(PKG, (String)"MongoPropToOption.ErrorMessage.UnableToParseTagSets", (String[])new String[]{tagSet}), parseException);
            }
        }
        return new DBObject[0];
    }

    public WriteConcern writeConcernValue(MongoProperties props) throws MongoDbException {
        WriteConcern concern;
        String writeConcern = props.get(MongoProp.writeConcern);
        String wTimeout = props.get(MongoProp.wTimeout);
        boolean journaled = Boolean.valueOf(props.get(MongoProp.JOURNALED));
        if (!Util.isEmpty(writeConcern) && Util.isEmpty(wTimeout) && !journaled) {
            concern = new WriteConcern(1);
            if (this.log != null) {
                this.log.info(BaseMessages.getString(PKG, (String)"MongoPropToOption.Message.ConfiguringWithDefaultWriteConcern", (String[])new String[0]));
            }
        } else {
            int wt = 0;
            if (!Util.isEmpty(wTimeout)) {
                try {
                    wt = Integer.parseInt(wTimeout);
                }
                catch (NumberFormatException n) {
                    throw new MongoDbException(n);
                }
            }
            if (!Util.isEmpty(writeConcern)) {
                try {
                    int wc = Integer.parseInt(writeConcern);
                    concern = new WriteConcern(wc, wt, false, journaled);
                }
                catch (NumberFormatException n) {
                    concern = new WriteConcern(writeConcern, wt, false, journaled);
                }
            } else {
                concern = new WriteConcern(1, wt, false, journaled);
            }
            if (this.log != null) {
                String lwc = "w = " + String.valueOf(concern.getWObject()) + ", wTimeout = " + concern.getWtimeout() + ", journaled = " + concern.getJ();
                this.log.info(BaseMessages.getString(PKG, (String)"MongoPropToOption.Message.ConfiguringWithWriteConcern", (String[])new String[]{lwc}));
            }
        }
        return concern;
    }

    private void logInfo(String message) {
        if (this.log != null) {
            this.log.info(message);
        }
    }

    private void logWarn(String message) {
        if (this.log != null) {
            this.log.warn(message, null);
        }
    }
}

