/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.textfileoutput;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hop.core.compress.CompressionOutputStream;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.pipeline.transform.BaseTransformData;
import org.apache.hop.pipeline.transform.ITransformData;

public class TextFileOutputData
extends BaseTransformData
implements ITransformData {
    public int splitnr;
    public int[] fieldnrs;
    public NumberFormat nf = NumberFormat.getInstance();
    public DecimalFormat df = (DecimalFormat)this.nf;
    public DecimalFormatSymbols dfs = new DecimalFormatSymbols();
    public SimpleDateFormat daf = new SimpleDateFormat();
    public DateFormatSymbols dafs = new DateFormatSymbols();
    public CompressionOutputStream out;
    public OutputStream writer;
    public DecimalFormat defaultDecimalFormat = (DecimalFormat)NumberFormat.getInstance();
    public DecimalFormatSymbols defaultDecimalFormatSymbols = new DecimalFormatSymbols();
    public SimpleDateFormat defaultDateFormat = new SimpleDateFormat();
    public DateFormatSymbols defaultDateFormatSymbols = new DateFormatSymbols();
    public Process cmdProc = null;
    public OutputStream fos;
    public IRowMeta outputRowMeta;
    public byte[] binarySeparator;
    public byte[] binaryEnclosure;
    public byte[] binaryNewline;
    public boolean hasEncoding;
    public byte[][] binaryNullValue;
    public boolean oneFileOpened = false;
    public int fileNameFieldIndex = -1;
    public IValueMeta fileNameMeta;
    public IFileStreamsCollection fileStreamsCollection;
    public long lastFileFlushTime = 0L;
    public String fileName;
    public int splitEvery;

    public IFileStreamsCollection getFileStreamsCollection() {
        if (this.fileStreamsCollection == null) {
            this.fileStreamsCollection = this.splitnr > 0 ? new FileStreamsList() : new FileStreamsMap();
        }
        return this.fileStreamsCollection;
    }

    static interface IFileStreamsCollection {
        public FileStream getStream(String var1);

        public void closeOldestOpenFile(boolean var1) throws IOException;

        public void flushOpenFiles(boolean var1) throws IOException;

        public String getLastFileName();

        public FileStream getLastStream();

        public int getNumOpenFiles();

        public void closeFile(String var1) throws IOException;

        public void closeStream(OutputStream var1) throws IOException;

        public int size();

        public void add(String var1, FileStream var2);
    }

    public class FileStreamsList
    implements IFileStreamsCollection {
        ArrayList<FileStream> streamsList = new ArrayList();
        ArrayList<String> namesList = new ArrayList();
        int numOpenFiles = 0;

        @Override
        public FileStream getStream(String filename) {
            int index = this.namesList.indexOf(filename);
            return index == -1 ? null : this.streamsList.get(index);
        }

        @Override
        public void closeOldestOpenFile(boolean removeFileFromCollection) throws IOException {
            int i;
            FileStream oldestOpenStream = null;
            for (i = 0; i < this.streamsList.size(); ++i) {
                FileStream existingStream = this.streamsList.get(i);
                if (!existingStream.isOpen()) continue;
                oldestOpenStream = existingStream;
                break;
            }
            if (oldestOpenStream != null) {
                oldestOpenStream.flush();
                oldestOpenStream.close();
                --this.numOpenFiles;
                if (removeFileFromCollection) {
                    this.streamsList.remove(i);
                    this.namesList.remove(i);
                }
            }
        }

        @Override
        public void flushOpenFiles(boolean closeAfterFlush) throws IOException {
            for (FileStream outputStream : this.streamsList) {
                if (!outputStream.isDirty()) continue;
                try {
                    outputStream.flush();
                    if (!closeAfterFlush || !outputStream.isOpen()) continue;
                    outputStream.close();
                    --this.numOpenFiles;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public String getLastFileName() {
            return !this.namesList.isEmpty() ? this.namesList.get(this.namesList.size() - 1) : null;
        }

        @Override
        public FileStream getLastStream() {
            return !this.streamsList.isEmpty() ? this.streamsList.get(this.streamsList.size() - 1) : null;
        }

        @Override
        public int getNumOpenFiles() {
            return this.numOpenFiles;
        }

        @Override
        public void closeFile(String filename) throws IOException {
            FileStream existingStream;
            int index = this.namesList.indexOf(filename);
            if (index >= 0 && (existingStream = this.streamsList.get(index)).isOpen()) {
                existingStream.flush();
                existingStream.close();
                --this.numOpenFiles;
            }
        }

        @Override
        public void closeStream(OutputStream outputStream) throws IOException {
            for (int i = 0; i < this.streamsList.size(); ++i) {
                FileStream fileStream = this.streamsList.get(i);
                if (fileStream.getBufferedOutputStream() != outputStream && fileStream.getCompressedOutputStream() != outputStream && fileStream.getFileOutputStream() != outputStream) continue;
                this.closeFile(this.namesList.get(i));
            }
        }

        @Override
        public int size() {
            return this.streamsList.size();
        }

        @Override
        public void add(String filename, FileStream fileStreams) {
            this.namesList.add(filename);
            this.streamsList.add(fileStreams);
            if (fileStreams.isOpen()) {
                ++this.numOpenFiles;
            }
        }
    }

    public class FileStreamsMap
    implements IFileStreamsCollection {
        private int numOpenFiles = 0;
        private TreeMap<String, FileStreamsCollectionEntry> fileNameMap = new TreeMap();
        private TreeMap<Long, FileStreamsCollectionEntry> indexMap = new TreeMap();

        @Override
        public int size() {
            return this.fileNameMap.size();
        }

        @Override
        public void add(String fileName, FileStream fileWriterOutputStream) {
            long index = 0L;
            if (this.size() > 0) {
                index = this.indexMap.lastKey() + 1L;
            }
            FileStreamsCollectionEntry newEntry = new FileStreamsCollectionEntry(fileName, index, fileWriterOutputStream);
            this.fileNameMap.put(fileName, newEntry);
            this.indexMap.put(index, newEntry);
            if (fileWriterOutputStream.isOpen()) {
                ++this.numOpenFiles;
            }
        }

        @Override
        public FileStream getStream(String filename) {
            if (this.fileNameMap.containsKey(filename)) {
                return this.fileNameMap.get(filename).getFileStream();
            }
            return null;
        }

        @Override
        public String getLastFileName() {
            String filename = null;
            if (!this.indexMap.isEmpty()) {
                filename = this.indexMap.lastEntry().getValue().getFileName();
            }
            return filename;
        }

        @Override
        public FileStream getLastStream() {
            FileStream lastStream = null;
            if (!this.indexMap.isEmpty()) {
                lastStream = this.indexMap.lastEntry().getValue().getFileStream();
            }
            return lastStream;
        }

        @Override
        public int getNumOpenFiles() {
            return this.numOpenFiles;
        }

        @Override
        public void closeOldestOpenFile(boolean removeFileFromCollection) throws IOException {
            FileStream oldestOpenStream = null;
            String oldestOpenFileName = null;
            Long oldestOpenFileIndex = null;
            for (Map.Entry<Long, FileStreamsCollectionEntry> mapEntry : this.indexMap.entrySet()) {
                FileStreamsCollectionEntry existingStream = mapEntry.getValue();
                if (!existingStream.getFileStream().isOpen()) continue;
                oldestOpenStream = existingStream.getFileStream();
                oldestOpenFileName = existingStream.getFileName();
                oldestOpenFileIndex = existingStream.getIndex();
                break;
            }
            if (oldestOpenStream != null) {
                oldestOpenStream.flush();
                oldestOpenStream.close();
                --this.numOpenFiles;
                if (removeFileFromCollection) {
                    this.fileNameMap.remove(oldestOpenFileName);
                    this.indexMap.remove(oldestOpenFileIndex);
                }
            }
        }

        @Override
        public void flushOpenFiles(boolean closeAfterFlush) {
            for (FileStreamsCollectionEntry collectionEntry : this.indexMap.values()) {
                if (!collectionEntry.getFileStream().isDirty()) continue;
                try {
                    collectionEntry.getFileStream().flush();
                    if (!closeAfterFlush) continue;
                    collectionEntry.getFileStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void closeFile(String filename) throws IOException {
            FileStream outputStreams = this.getStream(filename);
            if (outputStreams != null && outputStreams.isOpen()) {
                outputStreams.flush();
                outputStreams.close();
                --this.numOpenFiles;
            }
        }

        @Override
        public void closeStream(OutputStream outputStream) throws IOException {
            for (Map.Entry<Long, FileStreamsCollectionEntry> mapEntry : this.indexMap.entrySet()) {
                FileStream fileStream = mapEntry.getValue().getFileStream();
                if (fileStream.getBufferedOutputStream() != outputStream && fileStream.getCompressedOutputStream() != outputStream && fileStream.getFileOutputStream() != outputStream) continue;
                this.closeFile(mapEntry.getValue().getFileName());
            }
        }
    }

    public class FileStream {
        OutputStream fileOutputStream;
        CompressionOutputStream compressedOutputStream;
        BufferedOutputStream bufferedOutputStream;
        boolean isDirty;

        public FileStream(OutputStream fileOutputStream, CompressionOutputStream compressedOutputStream, BufferedOutputStream bufferedOutputStream) {
            this.fileOutputStream = fileOutputStream;
            this.compressedOutputStream = compressedOutputStream;
            this.bufferedOutputStream = bufferedOutputStream;
            this.isDirty = false;
        }

        public boolean isDirty() {
            return this.isDirty;
        }

        public void setDirty(boolean dirty) {
            this.isDirty = dirty;
        }

        public void flush() throws IOException {
            if (this.isDirty) {
                this.getBufferedOutputStream().flush();
                this.isDirty = false;
            }
        }

        public void close() throws IOException {
            this.setBufferedOutputStream(null);
            this.getCompressedOutputStream().close();
            this.setCompressedOutputStream(null);
            this.getFileOutputStream().close();
            this.setFileOutputStream(null);
            this.isDirty = false;
        }

        public boolean isOpen() {
            return this.fileOutputStream != null || this.compressedOutputStream != null || this.bufferedOutputStream != null;
        }

        public BufferedOutputStream getBufferedOutputStream() {
            return this.bufferedOutputStream;
        }

        public void setBufferedOutputStream(BufferedOutputStream outputStream) {
            this.bufferedOutputStream = outputStream;
        }

        public OutputStream getFileOutputStream() {
            return this.fileOutputStream;
        }

        public void setFileOutputStream(OutputStream fileOutputStream) {
            this.fileOutputStream = fileOutputStream;
        }

        public CompressionOutputStream getCompressedOutputStream() {
            return this.compressedOutputStream;
        }

        public void setCompressedOutputStream(CompressionOutputStream compressedOutputStream) {
            this.compressedOutputStream = compressedOutputStream;
        }
    }

    public class FileStreamsCollectionEntry {
        private String fileName;
        private long index = 0L;
        private FileStream fileStream;

        public FileStreamsCollectionEntry(String fileName, long index, FileStream fileStream) {
            this.fileName = fileName;
            this.index = index;
            this.fileStream = fileStream;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public long getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public FileStream getFileStream() {
            return this.fileStream;
        }

        public void setFileStream(FileStream fileStream) {
            this.fileStream = fileStream;
        }
    }
}

