/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fileinput.text;

import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.playlist.FilePlayListAll;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.file.BaseFileField;
import org.apache.hop.pipeline.transforms.file.BaseFileInputMeta;
import org.apache.hop.pipeline.transforms.file.BaseFileInputTransform;
import org.apache.hop.pipeline.transforms.file.BaseFileInputTransformData;
import org.apache.hop.pipeline.transforms.file.IBaseFileInputReader;
import org.apache.hop.pipeline.transforms.file.IBaseFileInputTransformControl;
import org.apache.hop.pipeline.transforms.fileinput.text.TextFileFilterProcessor;
import org.apache.hop.pipeline.transforms.fileinput.text.TextFileInputData;
import org.apache.hop.pipeline.transforms.fileinput.text.TextFileInputMeta;
import org.apache.hop.pipeline.transforms.fileinput.text.TextFileInputReader;
import org.apache.hop.staticschema.metadata.SchemaDefinition;
import org.apache.hop.staticschema.metadata.SchemaFieldDefinition;
import org.apache.hop.staticschema.util.SchemaDefinitionUtil;

public class TextFileInput
extends BaseFileInputTransform<TextFileInputMeta, TextFileInputData> {
    private static final Class<?> PKG = TextFileInputMeta.class;

    public TextFileInput(TransformMeta transformMeta, TextFileInputMeta meta, TextFileInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (BaseFileInputMeta)meta, (BaseFileInputTransformData)data, copyNr, pipelineMeta, pipeline);
    }

    protected IBaseFileInputReader createReader(TextFileInputMeta meta, TextFileInputData data, FileObject file) throws Exception {
        return new TextFileInputReader((IBaseFileInputTransformControl)this, meta, data, file, this.getLogChannel());
    }

    public boolean init() {
        if (!super.init()) {
            return false;
        }
        ((TextFileInputData)this.data).filePlayList = FilePlayListAll.INSTANCE;
        ((TextFileInputData)this.data).filterProcessor = new TextFileFilterProcessor(((TextFileInputMeta)this.meta).getFilter(), (IVariables)this);
        ((TextFileInputData)this.data).fileFormatType = ((TextFileInputMeta)this.meta).getFileFormatTypeNr();
        ((TextFileInputData)this.data).fileType = ((TextFileInputMeta)this.meta).getFileTypeNr();
        ((TextFileInputData)this.data).separator = this.resolve(((TextFileInputMeta)this.meta).content.separator);
        ((TextFileInputData)this.data).enclosure = this.resolve(((TextFileInputMeta)this.meta).content.enclosure);
        ((TextFileInputData)this.data).escapeCharacter = this.resolve(((TextFileInputMeta)this.meta).content.escapeCharacter);
        if (((TextFileInputMeta)this.meta).content.fileType.equalsIgnoreCase("CSV") && Utils.isEmpty((CharSequence)((TextFileInputMeta)this.meta).content.separator)) {
            this.logError(BaseMessages.getString(PKG, (String)"TextFileInput.Exception.NoSeparator", (String[])new String[0]));
            return false;
        }
        if (((TextFileInputMeta)this.meta).ignoreFields) {
            try {
                IRowMeta r;
                SchemaDefinition loadedSchemaDefinition = new SchemaDefinitionUtil().loadSchemaDefinition(this.metadataProvider, ((TextFileInputMeta)this.meta).getSchemaDefinition());
                if (loadedSchemaDefinition != null && (r = loadedSchemaDefinition.getRowMeta()) != null) {
                    ((TextFileInputMeta)this.meta).inputFields = new BaseFileField[r.size()];
                    for (int i = 0; i < r.size(); ++i) {
                        SchemaFieldDefinition schemaFieldDefinition = (SchemaFieldDefinition)loadedSchemaDefinition.getFieldDefinitions().get(i);
                        BaseFileField f = new BaseFileField();
                        f.setName(schemaFieldDefinition.getName());
                        f.setType(r.getValueMeta(i).getType());
                        f.setFormat(r.getValueMeta(i).getFormatMask());
                        f.setLength(r.getValueMeta(i).getLength());
                        f.setPrecision(r.getValueMeta(i).getPrecision());
                        f.setCurrencySymbol(r.getValueMeta(i).getCurrencySymbol());
                        f.setDecimalSymbol(r.getValueMeta(i).getDecimalSymbol());
                        f.setGroupSymbol(r.getValueMeta(i).getGroupingSymbol());
                        f.setIfNullValue(schemaFieldDefinition.getIfNullValue());
                        f.setTrimType(r.getValueMeta(i).getTrimType());
                        f.setRepeated(false);
                        ((TextFileInputMeta)this.meta).inputFields[i] = f;
                    }
                }
            }
            catch (HopPluginException | HopTransformException throwable) {
                // empty catch block
            }
        }
        return true;
    }
}

