/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.exception.DataElementParseErrorException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.DataElementData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StorageManifestRootDeclare;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StorageManifestSchemaGUID;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectHeaderStart;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectTypeHeaderStart;

public class StorageManifestDataElementData
extends DataElementData {
    public StorageManifestSchemaGUID storageManifestSchemaGUID = new StorageManifestSchemaGUID();
    public List<StorageManifestRootDeclare> storageManifestRootDeclareList = new ArrayList<StorageManifestRootDeclare>();

    @Override
    public List<Byte> serializeToByteList() throws TikaException, IOException {
        ArrayList<Byte> byteList = new ArrayList<Byte>(this.storageManifestSchemaGUID.serializeToByteList());
        if (this.storageManifestRootDeclareList != null) {
            for (StorageManifestRootDeclare storageManifestRootDeclare : this.storageManifestRootDeclareList) {
                byteList.addAll(storageManifestRootDeclare.serializeToByteList());
            }
        }
        return byteList;
    }

    @Override
    public int deserializeDataElementDataFromByteArray(byte[] byteArray, int startIndex) throws TikaException, IOException {
        AtomicInteger index = new AtomicInteger(startIndex);
        this.storageManifestSchemaGUID = StreamObject.getCurrent(byteArray, index, StorageManifestSchemaGUID.class);
        this.storageManifestRootDeclareList = new ArrayList<StorageManifestRootDeclare>();
        AtomicReference<StreamObjectHeaderStart> header = new AtomicReference<StreamObjectHeaderStart>();
        int headerLength = 0;
        while ((headerLength = StreamObjectHeaderStart.tryParse(byteArray, index.get(), header)) != 0) {
            if (header.get().type == StreamObjectTypeHeaderStart.StorageManifestRootDeclare) {
                index.addAndGet(headerLength);
                this.storageManifestRootDeclareList.add((StorageManifestRootDeclare)StreamObject.parseStreamObject(header.get(), byteArray, index));
                continue;
            }
            throw new DataElementParseErrorException(index.get(), "Failed to parse StorageManifestDataElement, expect the inner object type StorageManifestRootDeclare, but actual type value is " + String.valueOf((Object)header.get().type), null);
        }
        return index.get() - startIndex;
    }
}

