/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.hop.pipeline.transforms.splunkinput;

import com.splunk.Service;
import com.splunk.ServiceArgs;
import java.io.InputStream;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.pipeline.transform.BaseTransformData;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.splunk.SplunkConnection;

@SuppressWarnings("java:S1104")
public class SplunkInputData extends BaseTransformData implements ITransformData {

  public IRowMeta outputRowMeta;
  public SplunkConnection splunkConnection;
  public int[] fieldIndexes;
  public String query;

  public ServiceArgs serviceArgs;
  public Service service;
  public InputStream eventsStream;

  public SplunkInputData() {
    super();
  }
}
