/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

class ListUtilities {
    private static final int DEFAULT_MAX_WAIT_TIME = 60;
    static final int LIST_INFO_LENGTH = 80;
    static final char INFORMATION_COMPLETE = 'C';
    static final char INFORMATION_INTERRUPTED = 'I';
    static final char INFORMATION_PARTIAL = 'P';
    static final char LIST_PENDING = '0';
    static final char LIST_BEING_BUILT = '1';
    static final char LIST_COMPLETE = '2';
    static final char LIST_ERROR = '3';
    static final char LIST_PRIMED = '4';
    static final char LIST_TOO_MUCH_DATA = '5';

    ListUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char checkListStatus(byte[] listInformation) throws ErrorCompletingRequestException {
        char listStatusIndicator;
        char infoCompleteIndicator;
        try {
            byte[] arry = new byte[]{listInformation[16]};
            infoCompleteIndicator = new CharConverter(37).byteArrayToString(arry, 0, 1).charAt(0);
            arry[0] = listInformation[30];
            listStatusIndicator = new CharConverter(37).byteArrayToString(arry, 0, 1).charAt(0);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalErrorException(10, (Throwable)e);
        }
        switch (listStatusIndicator) {
            case '2': {
                break;
            }
            case '0': 
            case '1': {
                if (!Trace.traceOn_) break;
                Trace.log(1, "List status indicator:", listStatusIndicator);
                break;
            }
            default: {
                StringBuffer msg = new StringBuffer("Unable to synchronously build object list on server.");
                try {
                    msg.append("\n  List status indicator: " + listStatusIndicator);
                    msg.append("\n  Info complete indicator: " + infoCompleteIndicator);
                    msg.append("\n  Total records:    " + BinaryConverter.byteArrayToInt(listInformation, 0));
                    msg.append("\n  Records returned: " + BinaryConverter.byteArrayToInt(listInformation, 4));
                }
                catch (Throwable throwable) {
                }
                finally {
                    Trace.log(2, msg.toString());
                }
                throw new ErrorCompletingRequestException(1);
            }
        }
        if (infoCompleteIndicator == 'I') {
            Trace.log(2, "Info complete indicator: " + infoCompleteIndicator);
            throw new ErrorCompletingRequestException(1);
        }
        return listStatusIndicator;
    }

    static void closeList(AS400 system, byte[] listHandle) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (listHandle == null || !system.isConnected()) {
            return;
        }
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(listHandle), new ErrorCodeParameter()};
        ProgramCall pc = new ProgramCall(system, "/QSYS.LIB/QGYCLST.PGM", parameters);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
    }

    private static byte[] refreshListInformation(byte[] listHandle, ProgramCall pgmCall) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (pgmCall.getParameterList().length == 0) {
            ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(8), new ProgramParameter(BinaryConverter.intToByteArray(8)), new ProgramParameter(listHandle), new ProgramParameter(80), new ProgramParameter(new byte[]{0, 0, 0, 0}), new ProgramParameter(new byte[]{-1, -1, -1, -1}), new ErrorCodeParameter()};
            try {
                pgmCall.setProgram("/QSYS.LIB/QGYGTLE.PGM", parameters);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (!pgmCall.run()) {
            throw new AS400Exception(pgmCall.getMessageList());
        }
        return pgmCall.getParameterList()[3].getOutputData();
    }

    static byte[] waitForListToComplete(AS400 system, byte[] listHandle, byte[] listInformation) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramCall pgmCall = null;
        boolean waitSecondsPerIteration = true;
        int accumulatedWaitSeconds = 0;
        int maxWaitSeconds = ListUtilities.getMaxWaitTime();
        char listStatus = ListUtilities.checkListStatus(listInformation);
        while (listStatus != '2' && accumulatedWaitSeconds < maxWaitSeconds) {
            try {
                Thread.sleep(1000L);
                ++accumulatedWaitSeconds;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Calling QGYGTLE.PGM to wait for list to be completely built.");
            }
            if (pgmCall == null) {
                pgmCall = new ProgramCall(system);
            }
            listInformation = ListUtilities.refreshListInformation(listHandle, pgmCall);
            listStatus = ListUtilities.checkListStatus(listInformation);
        }
        if (listStatus != '2') {
            Trace.log(2, "The building of the list did not complete within the specified time limit of " + maxWaitSeconds + " seconds.");
            throw new ErrorCompletingRequestException(1);
        }
        return listInformation;
    }

    static byte[] retrieveListEntries(AS400 system, byte[] listHandle, int lengthOfReceiverVariable, int number, int listOffset, Object[] outputListInfoContainer) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] listInformation;
        int recordsReturned;
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(lengthOfReceiverVariable), new ProgramParameter(BinaryConverter.intToByteArray(lengthOfReceiverVariable)), new ProgramParameter(listHandle), new ProgramParameter(80), new ProgramParameter(BinaryConverter.intToByteArray(number)), new ProgramParameter(BinaryConverter.intToByteArray(listOffset == -1 ? -1 : listOffset + 1)), new ErrorCodeParameter()};
        ProgramCall pc = new ProgramCall(system, "/QSYS.LIB/QGYGTLE.PGM", parameters);
        do {
            if (pc.run()) {
                listInformation = parameters[3].getOutputData();
                ListUtilities.checkListStatus(listInformation);
                recordsReturned = BinaryConverter.byteArrayToInt(listInformation, 4);
            } else {
                listInformation = null;
                recordsReturned = 0;
                AS400Message[] messages = pc.getMessageList();
                if (!messages[0].getID().equals("GUI0002")) {
                    throw new AS400Exception(messages);
                }
            }
            if (recordsReturned >= number) continue;
            if (listInformation != null) {
                int totalRecords = BinaryConverter.byteArrayToInt(listInformation, 0);
                int firstRecordInReceiverVariable = BinaryConverter.byteArrayToInt(listInformation, 36);
                if (firstRecordInReceiverVariable + recordsReturned > totalRecords) break;
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Retrieved messages, records returned: " + recordsReturned + ", number:", number);
            }
            if (recordsReturned < 0) {
                throw new InternalErrorException(6, "Records returned: " + recordsReturned, null);
            }
            lengthOfReceiverVariable *= 1 + number / (recordsReturned + 1);
            if (Trace.traceOn_) {
                Trace.log(1, "Updated length: ", lengthOfReceiverVariable);
            }
            parameters[0] = new ProgramParameter(lengthOfReceiverVariable);
            parameters[1] = new ProgramParameter(BinaryConverter.intToByteArray(lengthOfReceiverVariable));
        } while (recordsReturned < number);
        if (outputListInfoContainer != null && listInformation != null) {
            outputListInfoContainer[0] = listInformation;
        }
        return parameters[0].getOutputData();
    }

    private static int getMaxWaitTime() {
        int listWaitTimeout;
        block4: {
            listWaitTimeout = 60;
            String propVal = SystemProperties.getProperty("com.ibm.as400.access.ListUtilities.listWaitTimeout");
            if (propVal != null) {
                try {
                    listWaitTimeout = Integer.parseInt(propVal);
                    if (listWaitTimeout == 0) {
                        listWaitTimeout = Integer.MAX_VALUE;
                    }
                }
                catch (Exception e) {
                    if (!Trace.traceOn_) break block4;
                    Trace.log(4, "Error retrieving listWaitTimeout property value:", (Throwable)e);
                }
            }
        }
        return listWaitTimeout;
    }
}

