/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ArabicOptionSet;
import com.ibm.as400.access.BidiFlag;
import com.ibm.as400.access.BidiFlagSet;
import com.ibm.as400.access.BidiText;
import com.ibm.as400.access.BidiTransform;
import com.ibm.as400.access.Mlog;
import java.nio.CharBuffer;
import java.util.StringTokenizer;

public class BidiConvert {
    static final char[] DEFAULT_U = new char[]{'I', 'L', 'Y', 'N', 'N', 'U', 'A', 'A', 'A', 'A'};
    static final char[] DEFAULT_S = new char[]{'V', 'L', 'N', 'S', 'N', 'U', 'A', 'A', 'A', 'A'};
    static final char DEFCHAR = '-';
    private String lastEncoding;
    private String lastBidiParms;
    private boolean lastMatching;
    private BidiFlagSet bfs_U;
    private BidiFlagSet bfs_S;

    private String getPart(String str, String prefix) {
        StringTokenizer stok = new StringTokenizer(str, ",)");
        String part = "";
        while (stok.hasMoreTokens()) {
            part = stok.nextToken();
            if (!part.startsWith(prefix)) continue;
            return part.substring(2);
        }
        return "";
    }

    private char[] getChars(String str, String prefix, char[] defChars) {
        int lenDef;
        String part = this.getPart(str, prefix);
        int len = part.length();
        if (len > (lenDef = defChars.length)) {
            len = lenDef;
        }
        char[] ans = new char[lenDef];
        part.getChars(0, len, ans, 0);
        for (int i = 0; i < lenDef; ++i) {
            if (i < len && '-' != ans[i]) continue;
            ans[i] = defChars[i];
        }
        return ans;
    }

    private boolean isMatchingEncoding(String encoding, String bidiParms) {
        if (encoding == this.lastEncoding && bidiParms == this.lastBidiParms) {
            return this.lastMatching;
        }
        this.lastEncoding = encoding;
        this.lastBidiParms = bidiParms;
        this.bfs_U = null;
        this.bfs_S = null;
        String part = this.getPart(bidiParms, "C(");
        if (part.equals("")) {
            this.lastMatching = true;
            return true;
        }
        StringTokenizer stok = new StringTokenizer(part, ";");
        while (stok.hasMoreTokens()) {
            String enc = stok.nextToken();
            if (!enc.equals(encoding)) continue;
            this.lastMatching = true;
            return true;
        }
        this.lastMatching = false;
        return false;
    }

    private boolean isFlagRtl(String bidiParms) {
        BidiFlag bf;
        if (null == this.bfs_U) {
            this.bfs_U = new BidiFlagSet(this.getChars(bidiParms, "U(", DEFAULT_U));
        }
        if (BidiFlag.ORIENTATION_RTL == (bf = this.bfs_U.getOrientation())) {
            return true;
        }
        if (BidiFlag.ORIENTATION_CONTEXT_RTL == bf) {
            return true;
        }
        if (null == this.bfs_S) {
            this.bfs_S = new BidiFlagSet(this.getChars(bidiParms, "S(", DEFAULT_S));
        }
        if (BidiFlag.ORIENTATION_RTL == (bf = this.bfs_S.getOrientation())) {
            return true;
        }
        return BidiFlag.ORIENTATION_CONTEXT_RTL == bf;
    }

    private boolean isBidiData(char[] input, int inStart, int inEnd) {
        for (int i = inStart; i < inEnd; ++i) {
            char c = input[i];
            if (c >= '\u0590' && c <= '\u07bf') {
                return true;
            }
            if (c >= '\ufb1d' && c <= '\ufdff') {
                return true;
            }
            if (c >= '\ufe70' && c <= '\ufefc') {
                return true;
            }
            if (c == '\u200f') {
                return true;
            }
            if (c != '\u202b' && c != '\u202e') continue;
            return true;
        }
        return false;
    }

    public boolean isBidiEnv(String bidiParms, String encoding) {
        if (encoding.equals("Cp850")) {
            return false;
        }
        Mlog.putLine("isBidiEnv " + bidiParms + " encoding=" + encoding);
        if (bidiParms == null) {
            return Mlog.logReturn(false);
        }
        if (bidiParms.equals("NO")) {
            return Mlog.logReturn(false);
        }
        if (!this.isMatchingEncoding(encoding, bidiParms)) {
            return Mlog.logReturn(false);
        }
        return Mlog.logReturn(true);
    }

    public boolean isBidiData(char[] input, int inStart, int inEnd, String bidiParms, String encoding) {
        if (!this.isBidiEnv(bidiParms, encoding)) {
            return false;
        }
        Mlog.putLine("isBidiData_char[]  inStart=" + inStart + "  inEnd=" + inEnd);
        Mlog.putHexLine(input, inStart, inEnd, true);
        if (inEnd <= inStart) {
            return Mlog.logReturn(false);
        }
        if (this.isFlagRtl(bidiParms)) {
            return Mlog.logReturn(true);
        }
        return Mlog.logReturn(this.isBidiData(input, inStart, inEnd));
    }

    public boolean isBidiData(String input, String bidiParms, String encoding) {
        if (!this.isBidiEnv(bidiParms, encoding)) {
            return false;
        }
        Mlog.putLine("isBidiData_String");
        Mlog.putHexLine(input, true);
        if (input.length() <= 0) {
            return Mlog.logReturn(false);
        }
        if (this.isFlagRtl(bidiParms)) {
            return Mlog.logReturn(true);
        }
        char[] text = input.toCharArray();
        return Mlog.logReturn(this.isBidiData(text, 0, text.length));
    }

    public boolean isBidiData(CharBuffer input, boolean UseBuffer, String bidiParms, String encoding) {
        if (!this.isBidiEnv(bidiParms, encoding)) {
            return false;
        }
        Mlog.putLine("isBidiData_CharBuffer  UseBuffer=" + UseBuffer + "  position=" + input.position() + "  limit=" + input.limit());
        Mlog.putHexLine(input.toString(), true);
        if (!input.hasRemaining()) {
            return Mlog.logReturn(false);
        }
        if (this.isFlagRtl(bidiParms)) {
            return Mlog.logReturn(true);
        }
        if (input.hasArray() && !UseBuffer) {
            char[] text = input.array();
            int offset = input.arrayOffset();
            boolean flag = this.isBidiData(text, offset + input.position(), offset + input.limit());
            return Mlog.logReturn(flag);
        }
        int oldPos = input.position();
        char[] text = new char[1];
        boolean flag = false;
        while (input.hasRemaining()) {
            text[0] = input.get();
            if (!this.isBidiData(text, 0, 1)) continue;
            flag = true;
            break;
        }
        input.position(oldPos);
        return Mlog.logReturn(flag);
    }

    private char[] subchars(char[] input, int inStart, int inEnd) {
        int len = inEnd - inStart;
        char[] result = new char[len];
        System.arraycopy(input, inStart, result, 0, len);
        return result;
    }

    private char[] toUnicode(char[] input, int inStart, int inEnd, String bidiParms) {
        char[] charsU = this.getChars(bidiParms, "U(", DEFAULT_U);
        char[] charsS = this.getChars(bidiParms, "S(", DEFAULT_S);
        BidiTransform bdx = new BidiTransform();
        if (null == this.bfs_U) {
            this.bfs_U = new BidiFlagSet(charsU);
        }
        bdx.flags = this.bfs_U;
        bdx.roundTrip = 'R' == charsU[5];
        bdx.options = new ArabicOptionSet(charsU);
        if (null == this.bfs_S) {
            this.bfs_S = new BidiFlagSet(charsS);
        }
        BidiText src = new BidiText(this.bfs_S);
        src.setCharsRef(input, inStart, inEnd - inStart);
        BidiText dst = src.transform(bdx);
        return dst.data;
    }

    public char[] toUnicode(char[] input, int inStart, int inEnd, String bidiParms, String encoding) {
        Mlog.printStackTrace("toUnicode_char[]");
        Mlog.putLine("toUnicode_char[]  inStart=" + inStart + "  inEnd=" + inEnd);
        Mlog.putHexLine(input, inStart, inEnd, true);
        if (!this.isBidiEnv(bidiParms, encoding)) {
            return Mlog.logReturn(this.subchars(input, inStart, inEnd));
        }
        return Mlog.logReturn(this.toUnicode(input, inStart, inEnd, bidiParms));
    }

    public String toUnicode(String input, String bidiParms, String encoding) {
        Mlog.printStackTrace("toUnicode_String");
        Mlog.putLine("toUnicode_String input:");
        Mlog.putHexLine(input, true);
        if (!this.isBidiEnv(bidiParms, encoding)) {
            return Mlog.logReturn(input);
        }
        return new String(Mlog.logReturn(this.toUnicode(input.toCharArray(), 0, input.length(), bidiParms)));
    }

    public CharBuffer toUnicode(CharBuffer input, boolean UseBuffer, String bidiParms, String encoding) {
        Mlog.printStackTrace("toUnicode_CharBuffer");
        Mlog.putLine("toUnicode_CharBuffer  UseBuffer=" + UseBuffer + "  position=" + input.position() + "  limit=" + input.limit());
        Mlog.putHexLine(input.toString(), true);
        if (!this.isBidiEnv(bidiParms, encoding)) {
            return Mlog.logReturn(input);
        }
        if (input.hasArray() && !UseBuffer) {
            char[] text = input.array();
            int offset = input.arrayOffset();
            text = this.toUnicode(text, offset + input.position(), offset + input.limit(), bidiParms);
            Mlog.putLine("after array: position=" + input.position() + "  limit=" + input.limit());
            return Mlog.logReturn(CharBuffer.wrap(text));
        }
        int oldPos = input.position();
        char[] text = new char[input.remaining()];
        input.get(text);
        input.position(oldPos);
        text = this.toUnicode(text, 0, text.length, bidiParms);
        Mlog.putLine("after buffer: position=" + input.position() + "  limit=" + input.limit());
        return Mlog.logReturn(CharBuffer.wrap(text));
    }

    private char[] toSbcs(char[] input, int inStart, int inEnd, String bidiParms) {
        char[] charsU = this.getChars(bidiParms, "U(", DEFAULT_U);
        char[] charsS = this.getChars(bidiParms, "S(", DEFAULT_S);
        BidiTransform bdx = new BidiTransform();
        if (null == this.bfs_S) {
            this.bfs_S = new BidiFlagSet(charsS);
        }
        bdx.flags = this.bfs_S;
        bdx.roundTrip = 'R' == charsS[5];
        bdx.options = new ArabicOptionSet(charsS);
        if (null == this.bfs_U) {
            this.bfs_U = new BidiFlagSet(charsU);
        }
        BidiText src = new BidiText(this.bfs_U);
        src.setCharsRef(input, inStart, inEnd - inStart);
        BidiText dst = src.transform(bdx);
        return dst.data;
    }

    public char[] toSbcs(char[] input, int inStart, int inEnd, String bidiParms, String encoding) {
        Mlog.printStackTrace("toSbcs_char[]");
        Mlog.putLine("toSbcs_char[]  inStart=" + inStart + "  inEnd=" + inEnd);
        Mlog.putHexLine(input, inStart, inEnd, true);
        if (!this.isBidiEnv(bidiParms, encoding)) {
            return Mlog.logReturn(this.subchars(input, inStart, inEnd));
        }
        return Mlog.logReturn(this.toSbcs(input, inStart, inEnd, bidiParms));
    }

    public String toSbcs(String input, String bidiParms, String encoding) {
        Mlog.printStackTrace("toSbcs_String input:");
        Mlog.putHexLine(input, true);
        if (!this.isBidiEnv(bidiParms, encoding)) {
            return Mlog.logReturn(input);
        }
        return Mlog.logReturn(new String(this.toSbcs(input.toCharArray(), 0, input.length(), bidiParms)));
    }

    public CharBuffer toSbcs(CharBuffer input, boolean UseBuffer, String bidiParms, String encoding) {
        Mlog.printStackTrace("toSbcs_CharBuffer");
        Mlog.putLine("toSbcs_CharBuffer  UseBuffer=" + UseBuffer + "  position=" + input.position() + "  limit=" + input.limit());
        Mlog.putHexLine(input.toString(), true);
        if (!this.isBidiEnv(bidiParms, encoding)) {
            return Mlog.logReturn(input);
        }
        if (input.hasArray() && !UseBuffer) {
            char[] text = input.array();
            int offset = input.arrayOffset();
            text = this.toSbcs(text, offset + input.position(), offset + input.limit(), bidiParms);
            Mlog.putLine("after array: position=" + input.position() + "  limit=" + input.limit());
            return Mlog.logReturn(CharBuffer.wrap(text));
        }
        int oldPos = input.position();
        char[] text = new char[input.remaining()];
        input.get(text);
        input.position(oldPos);
        text = this.toSbcs(text, 0, text.length, bidiParms);
        Mlog.putLine("after buffer: position=" + input.position() + "  limit=" + input.limit());
        return Mlog.logReturn(CharBuffer.wrap(text));
    }
}

