/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.eventhubs.listen;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.row.value.ValueMetaTimestamp;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.eventhubs.listen.AzureListener;
import org.apache.hop.pipeline.transforms.eventhubs.listen.AzureListenerData;

@Transform(id="AzureListener", name="i18n::AzureListenerMeta.name", description="i18n::AzureListenerMeta.description", image="event-hubs-listener.svg", categoryDescription="i18n::AzureListenerMeta.categoryDescription", keywords={"i18n::AzureListenerMeta.keyword"}, documentationUrl="/pipeline/transforms/azure-event-hubs-listener.html")
public class AzureListenerMeta
extends BaseTransformMeta<AzureListener, AzureListenerData> {
    @HopMetadataProperty(key="namespace")
    private String namespace;
    @HopMetadataProperty(key="event_hub_name")
    private String eventHubName;
    @HopMetadataProperty(key="sas_key_name")
    private String sasKeyName;
    @HopMetadataProperty(key="sas_key", password=true)
    private String sasKey;
    @HopMetadataProperty(key="consumer_group_name")
    private String consumerGroupName;
    @HopMetadataProperty(key="storage_connection_string")
    private String storageConnectionString;
    @HopMetadataProperty(key="storage_container_name")
    private String storageContainerName;
    @HopMetadataProperty(key="prefetch_size")
    private String prefetchSize;
    @HopMetadataProperty(key="batch_size")
    private String batchSize;
    @HopMetadataProperty(key="output_field")
    private String outputField;
    @HopMetadataProperty(key="partition_id_field")
    private String partitionIdField;
    @HopMetadataProperty(key="offset_field")
    private String offsetField;
    @HopMetadataProperty(key="sequence_number_field")
    private String sequenceNumberField;
    @HopMetadataProperty(key="host_field")
    private String hostField;
    @HopMetadataProperty(key="enqueued_time_field")
    private String enqueuedTimeField;
    @HopMetadataProperty(key="batch_transformation")
    private String batchPipeline;
    @HopMetadataProperty(key="batch_input_Transform")
    private String batchInputTransform;
    @HopMetadataProperty(key="batch_output_Transform")
    private String batchOutputTransform;
    @HopMetadataProperty(key="batch_max_wait_time")
    private String batchMaxWaitTime;

    public AzureListenerMeta() {
    }

    public AzureListenerMeta(AzureListenerMeta m) {
        this();
        this.namespace = m.namespace;
        this.eventHubName = m.eventHubName;
        this.sasKeyName = m.sasKeyName;
        this.sasKey = m.sasKey;
        this.consumerGroupName = m.consumerGroupName;
        this.storageConnectionString = m.storageConnectionString;
        this.storageContainerName = m.storageContainerName;
        this.prefetchSize = m.prefetchSize;
        this.batchSize = m.batchSize;
        this.outputField = m.outputField;
        this.partitionIdField = m.partitionIdField;
        this.offsetField = m.offsetField;
        this.sequenceNumberField = m.sequenceNumberField;
        this.hostField = m.hostField;
        this.enqueuedTimeField = m.enqueuedTimeField;
        this.batchPipeline = m.batchPipeline;
        this.batchInputTransform = m.batchInputTransform;
        this.batchOutputTransform = m.batchOutputTransform;
        this.batchMaxWaitTime = m.batchMaxWaitTime;
    }

    public AzureListenerMeta clone() {
        return new AzureListenerMeta(this);
    }

    public void setDefault() {
        this.consumerGroupName = "$Default";
        this.outputField = "message";
        this.partitionIdField = "partitionId";
        this.offsetField = "offset";
        this.sequenceNumberField = "sequenceNumber";
        this.hostField = "host";
        this.enqueuedTimeField = "enqueuedTime";
    }

    public void getFields(IRowMeta rowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (StringUtils.isNotEmpty((String)this.batchPipeline) && StringUtils.isNotEmpty((String)this.batchInputTransform)) {
            try {
                PipelineMeta batchTransMeta = AzureListenerMeta.loadBatchPipelineMeta(this, metadataProvider, variables);
                IRowMeta transformFields = batchTransMeta.getTransformFields(variables, variables.resolve(this.batchOutputTransform));
                rowMeta.clear();
                rowMeta.addRowMeta(transformFields);
                return;
            }
            catch (Exception e) {
                throw new HopTransformException("Unable to get fields from batch pipeline Transform " + this.batchOutputTransform, (Throwable)e);
            }
        }
        this.getRegularRowMeta(rowMeta, variables);
    }

    public void getRegularRowMeta(IRowMeta rowMeta, IVariables variables) {
        String enqueuedTimeFieldName;
        String hostFieldName;
        String sequenceNumberFieldName;
        String offsetFieldName;
        String partitionIdFieldName;
        String outputFieldName = variables.resolve(this.outputField);
        if (StringUtils.isNotEmpty((String)outputFieldName)) {
            ValueMetaString outputValueMeta = new ValueMetaString(outputFieldName);
            rowMeta.addValueMeta((IValueMeta)outputValueMeta);
        }
        if (StringUtils.isNotEmpty((String)(partitionIdFieldName = variables.resolve(this.partitionIdField)))) {
            ValueMetaString outputValueMeta = new ValueMetaString(partitionIdFieldName);
            rowMeta.addValueMeta((IValueMeta)outputValueMeta);
        }
        if (StringUtils.isNotEmpty((String)(offsetFieldName = variables.resolve(this.offsetField)))) {
            ValueMetaString outputValueMeta = new ValueMetaString(offsetFieldName);
            rowMeta.addValueMeta((IValueMeta)outputValueMeta);
        }
        if (StringUtils.isNotEmpty((String)(sequenceNumberFieldName = variables.resolve(this.sequenceNumberField)))) {
            ValueMetaInteger outputValueMeta = new ValueMetaInteger(sequenceNumberFieldName);
            rowMeta.addValueMeta((IValueMeta)outputValueMeta);
        }
        if (StringUtils.isNotEmpty((String)(hostFieldName = variables.resolve(this.hostField)))) {
            ValueMetaString outputValueMeta = new ValueMetaString(hostFieldName);
            rowMeta.addValueMeta((IValueMeta)outputValueMeta);
        }
        if (StringUtils.isNotEmpty((String)(enqueuedTimeFieldName = variables.resolve(this.enqueuedTimeField)))) {
            ValueMetaTimestamp outputValueMeta = new ValueMetaTimestamp(enqueuedTimeFieldName);
            rowMeta.addValueMeta((IValueMeta)outputValueMeta);
        }
    }

    public static final synchronized PipelineMeta loadBatchPipelineMeta(AzureListenerMeta azureListenerMeta, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        PipelineMeta batchPipelineMeta;
        String realFilename = variables.resolve(azureListenerMeta.getBatchPipeline());
        try {
            batchPipelineMeta = new PipelineMeta(realFilename, metadataProvider, variables);
        }
        catch (Exception e) {
            throw new HopException("Unable to load batch pipeline", (Throwable)e);
        }
        return batchPipelineMeta;
    }

    public String[] getReferencedObjectDescriptions() {
        return new String[]{"Batch pipeline"};
    }

    private boolean isPipelineDefined() {
        return StringUtils.isNotEmpty((String)this.batchPipeline);
    }

    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{this.isPipelineDefined()};
    }

    public IHasFilename loadReferencedObject(int index, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        return AzureListenerMeta.loadBatchPipelineMeta(this, metadataProvider, variables);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getEventHubName() {
        return this.eventHubName;
    }

    public void setEventHubName(String eventHubName) {
        this.eventHubName = eventHubName;
    }

    public String getSasKeyName() {
        return this.sasKeyName;
    }

    public void setSasKeyName(String sasKeyName) {
        this.sasKeyName = sasKeyName;
    }

    public String getSasKey() {
        return this.sasKey;
    }

    public void setSasKey(String sasKey) {
        this.sasKey = sasKey;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public String getOutputField() {
        return this.outputField;
    }

    public void setOutputField(String outputField) {
        this.outputField = outputField;
    }

    public String getConsumerGroupName() {
        return this.consumerGroupName;
    }

    public void setConsumerGroupName(String consumerGroupName) {
        this.consumerGroupName = consumerGroupName;
    }

    public String getStorageConnectionString() {
        return this.storageConnectionString;
    }

    public void setStorageConnectionString(String storageConnectionString) {
        this.storageConnectionString = storageConnectionString;
    }

    public String getStorageContainerName() {
        return this.storageContainerName;
    }

    public void setStorageContainerName(String storageContainerName) {
        this.storageContainerName = storageContainerName;
    }

    public String getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchSize(String prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public String getPartitionIdField() {
        return this.partitionIdField;
    }

    public void setPartitionIdField(String partitionIdField) {
        this.partitionIdField = partitionIdField;
    }

    public String getOffsetField() {
        return this.offsetField;
    }

    public void setOffsetField(String offsetField) {
        this.offsetField = offsetField;
    }

    public String getSequenceNumberField() {
        return this.sequenceNumberField;
    }

    public void setSequenceNumberField(String sequenceNumberField) {
        this.sequenceNumberField = sequenceNumberField;
    }

    public String getHostField() {
        return this.hostField;
    }

    public void setHostField(String hostField) {
        this.hostField = hostField;
    }

    public String getEnqueuedTimeField() {
        return this.enqueuedTimeField;
    }

    public void setEnqueuedTimeField(String enqueuedTimeField) {
        this.enqueuedTimeField = enqueuedTimeField;
    }

    public String getBatchPipeline() {
        return this.batchPipeline;
    }

    public void setBatchPipeline(String batchPipeline) {
        this.batchPipeline = batchPipeline;
    }

    public String getBatchInputTransform() {
        return this.batchInputTransform;
    }

    public void setBatchInputTransform(String batchInputTransform) {
        this.batchInputTransform = batchInputTransform;
    }

    public String getBatchOutputTransform() {
        return this.batchOutputTransform;
    }

    public void setBatchOutputTransform(String batchOutputTransform) {
        this.batchOutputTransform = batchOutputTransform;
    }

    public String getBatchMaxWaitTime() {
        return this.batchMaxWaitTime;
    }

    public void setBatchMaxWaitTime(String batchMaxWaitTime) {
        this.batchMaxWaitTime = batchMaxWaitTime;
    }
}

