/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.source;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.io.CheckpointableInputFormat;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.state.JavaSerializer;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.functions.source.TimestampedInputSplit;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.OutputTypeConfigurable;
import org.apache.flink.streaming.api.operators.StreamSourceContexts;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.mailbox.MailboxExecutorImpl;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.RunnableWithException;
import org.apache.flink.util.function.ThrowingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ContinuousFileReaderOperator<OUT, T extends TimestampedInputSplit>
extends AbstractStreamOperator<OUT>
implements OneInputStreamOperator<T, OUT>,
OutputTypeConfigurable<OUT> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ContinuousFileReaderOperator.class);
    private transient InputFormat<OUT, ? super T> format;
    private TypeSerializer<OUT> serializer;
    private transient MailboxExecutorImpl executor;
    private transient OUT reusedRecord;
    private transient SourceFunction.SourceContext<OUT> sourceContext;
    private transient ListState<T> checkpointedState;
    private transient ReaderState state = ReaderState.IDLE;
    private transient PriorityQueue<T> splits = new PriorityQueue();
    private transient T currentSplit;
    private transient Counter completedSplitsCounter;
    private final transient RunnableWithException processRecordAction = () -> {
        try {
            this.processRecord();
        }
        catch (Exception e) {
            this.switchState(ReaderState.FAILED);
            throw e;
        }
    };

    ContinuousFileReaderOperator(InputFormat<OUT, ? super T> format, ProcessingTimeService processingTimeService, MailboxExecutor mailboxExecutor) {
        this.format = (InputFormat)Preconditions.checkNotNull(format);
        this.processingTimeService = (ProcessingTimeService)Preconditions.checkNotNull((Object)processingTimeService);
        this.executor = (MailboxExecutorImpl)Preconditions.checkNotNull((Object)mailboxExecutor);
    }

    @Override
    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        Preconditions.checkState((this.checkpointedState == null ? 1 : 0) != 0, (Object)"The reader state has already been initialized.");
        this.checkpointedState = context.getOperatorStateStore().getListState(new ListStateDescriptor("splits", (TypeSerializer)new JavaSerializer()));
        int subtaskIdx = this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask();
        if (!context.isRestored()) {
            LOG.info("No state to restore for the {} (taskIdx={}).", (Object)this.getClass().getSimpleName(), (Object)subtaskIdx);
            return;
        }
        LOG.info("Restoring state for the {} (taskIdx={}).", (Object)this.getClass().getSimpleName(), (Object)subtaskIdx);
        this.splits = this.splits == null ? new PriorityQueue<T>() : this.splits;
        for (TimestampedInputSplit split : (Iterable)this.checkpointedState.get()) {
            this.splits.add(split);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} (taskIdx={}) restored {}.", new Object[]{this.getClass().getSimpleName(), subtaskIdx, this.splits});
        }
    }

    @Override
    public void open() throws Exception {
        super.open();
        Preconditions.checkState((this.serializer != null ? 1 : 0) != 0, (Object)"The serializer has not been set. Probably the setOutputType() was not called. Please report it.");
        this.state = ReaderState.IDLE;
        if (this.format instanceof RichInputFormat) {
            ((RichInputFormat)this.format).setRuntimeContext((RuntimeContext)this.getRuntimeContext());
        }
        this.format.configure(new Configuration());
        this.sourceContext = StreamSourceContexts.getSourceContext(this.getOperatorConfig().getTimeCharacteristic(), this.getProcessingTimeService(), new Object(), this.output, this.getExecutionConfig().getAutoWatermarkInterval(), -1L, true);
        this.reusedRecord = this.serializer.createInstance();
        this.completedSplitsCounter = this.getMetricGroup().counter("numSplitsProcessed");
        PriorityQueue<T> priorityQueue = this.splits = this.splits == null ? new PriorityQueue<T>() : this.splits;
        if (!this.splits.isEmpty()) {
            this.enqueueProcessRecord();
        }
    }

    @Override
    public void processElement(StreamRecord<T> element) throws Exception {
        Preconditions.checkState((boolean)this.state.isAcceptingSplits());
        this.splits.offer(element.getValue());
        if (this.state == ReaderState.IDLE) {
            this.enqueueProcessRecord();
        }
    }

    private void enqueueProcessRecord() {
        Preconditions.checkState((!this.state.isTerminal() ? 1 : 0) != 0, (String)"can't enqueue mail in terminal state %s", (Object[])new Object[]{this.state});
        this.executor.execute((ThrowingRunnable)this.processRecordAction, "ContinuousFileReaderOperator");
        if (this.state == ReaderState.IDLE) {
            this.switchState(ReaderState.OPENING);
        }
    }

    private void processRecord() throws IOException {
        do {
            if (!this.state.prepareToProcessRecord(this)) {
                return;
            }
            this.readAndCollectRecord();
            if (!this.format.reachedEnd()) continue;
            this.onSplitProcessed();
            return;
        } while (this.executor.isIdle());
        this.enqueueProcessRecord();
    }

    private void onSplitProcessed() throws IOException {
        this.completedSplitsCounter.inc();
        LOG.debug("split {} processed: {}", (Object)this.completedSplitsCounter.getCount(), this.currentSplit);
        this.format.close();
        this.currentSplit = null;
        if (this.splits.isEmpty()) {
            this.state.onNoMoreData(this);
            return;
        }
        if (this.state == ReaderState.READING) {
            this.switchState(ReaderState.OPENING);
        }
        this.enqueueProcessRecord();
    }

    private void readAndCollectRecord() throws IOException {
        Preconditions.checkState((this.state == ReaderState.READING || this.state == ReaderState.FINISHING ? 1 : 0) != 0, (String)"can't process record in state %s", (Object[])new Object[]{this.state});
        if (this.format.reachedEnd()) {
            return;
        }
        Object out = this.format.nextRecord(this.reusedRecord);
        if (out != null) {
            this.sourceContext.collect(out);
        }
    }

    private void loadSplit(T split) throws IOException {
        Preconditions.checkState((this.state != ReaderState.READING && this.state != ReaderState.FINISHED ? 1 : 0) != 0, (String)"can't load split in state %s", (Object[])new Object[]{this.state});
        Preconditions.checkNotNull(split, (String)"split is null");
        LOG.debug("load split: {}", split);
        this.currentSplit = split;
        if (this.format instanceof RichInputFormat) {
            ((RichInputFormat)this.format).openInputFormat();
        }
        if (this.format instanceof CheckpointableInputFormat && this.currentSplit.getSplitState() != null) {
            ((CheckpointableInputFormat)this.format).reopen(this.currentSplit, this.currentSplit.getSplitState());
        } else {
            this.format.open(this.currentSplit);
        }
        this.currentSplit.resetSplitState();
    }

    private void switchState(ReaderState newState) {
        if (this.state != newState) {
            Preconditions.checkState((boolean)this.state.canSwitchTo(newState), (String)"can't switch state from terminal state %s to %s", (Object[])new Object[]{this.state, newState});
            LOG.debug("switch state: {} -> {}", (Object)this.state, (Object)newState);
            this.state = newState;
        }
    }

    @Override
    public void processWatermark(Watermark mark) throws Exception {
    }

    @Override
    public void finish() throws Exception {
        LOG.debug("finishing");
        super.finish();
        switch (this.state) {
            case IDLE: {
                this.switchState(ReaderState.FINISHED);
                break;
            }
            case FINISHED: {
                LOG.warn("operator is already closed, doing nothing");
                return;
            }
            default: {
                this.switchState(ReaderState.FINISHING);
                while (!this.state.isTerminal()) {
                    this.executor.yield();
                }
                break block1;
            }
        }
        try {
            this.sourceContext.emitWatermark(Watermark.MAX_WATERMARK);
        }
        catch (Exception e) {
            LOG.warn("unable to emit watermark while closing", (Throwable)e);
        }
    }

    @Override
    public void close() throws Exception {
        Exception e = null;
        try {
            this.cleanUp();
        }
        catch (Exception ex) {
            e = ex;
        }
        this.checkpointedState = null;
        this.completedSplitsCounter = null;
        this.currentSplit = null;
        this.executor = null;
        this.format = null;
        this.sourceContext = null;
        this.reusedRecord = null;
        this.serializer = null;
        this.splits = null;
        try {
            super.close();
        }
        catch (Exception ex) {
            e = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)ex, (Throwable)e);
        }
        if (e != null) {
            throw e;
        }
    }

    private void cleanUp() throws Exception {
        LOG.debug("cleanup, state={}", (Object)this.state);
        RunnableWithException[] runClose = new RunnableWithException[]{() -> this.sourceContext.close(), () -> this.format.close(), () -> {
            if (this.format instanceof RichInputFormat) {
                ((RichInputFormat)this.format).closeInputFormat();
            }
        }};
        Exception firstException = null;
        for (RunnableWithException r : runClose) {
            try {
                r.run();
            }
            catch (Exception e) {
                firstException = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, firstException);
            }
        }
        this.currentSplit = null;
        if (firstException != null) {
            throw firstException;
        }
    }

    @Override
    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        Preconditions.checkState((this.checkpointedState != null ? 1 : 0) != 0, (Object)"The operator state has not been properly initialized.");
        int subtaskIdx = this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask();
        List<T> readerState = this.getReaderState();
        try {
            this.checkpointedState.update(readerState);
        }
        catch (Exception e) {
            this.checkpointedState.clear();
            throw new Exception("Could not add timestamped file input splits to operator state backend of operator " + this.getOperatorName() + '.', e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} (taskIdx={}) checkpointed {} splits: {}.", new Object[]{this.getClass().getSimpleName(), subtaskIdx, readerState.size(), readerState});
        }
    }

    private List<T> getReaderState() throws IOException {
        ArrayList<T> snapshot = new ArrayList<T>(this.splits.size());
        if (this.currentSplit != null) {
            if (this.format instanceof CheckpointableInputFormat && this.state == ReaderState.READING) {
                Serializable formatState = ((CheckpointableInputFormat)this.format).getCurrentState();
                this.currentSplit.setSplitState(formatState);
            }
            snapshot.add(this.currentSplit);
        }
        snapshot.addAll(this.splits);
        return snapshot;
    }

    public void setOutputType(TypeInformation<OUT> outTypeInfo, ExecutionConfig executionConfig) {
        this.serializer = outTypeInfo.createSerializer(executionConfig.getSerializerConfig());
    }

    private static enum ReaderState {
        IDLE{

            @Override
            public <T extends TimestampedInputSplit> boolean prepareToProcessRecord(ContinuousFileReaderOperator<?, T> op) throws IOException {
                throw new IllegalStateException("not processing any records in IDLE state");
            }
        }
        ,
        OPENING{

            @Override
            public <T extends TimestampedInputSplit> boolean prepareToProcessRecord(ContinuousFileReaderOperator<?, T> op) throws IOException {
                if (((ContinuousFileReaderOperator)op).splits.isEmpty()) {
                    ((ContinuousFileReaderOperator)op).switchState(IDLE);
                    return false;
                }
                ((ContinuousFileReaderOperator)op).loadSplit((TimestampedInputSplit)((ContinuousFileReaderOperator)op).splits.poll());
                ((ContinuousFileReaderOperator)op).switchState(READING);
                return true;
            }
        }
        ,
        READING{

            @Override
            public <T extends TimestampedInputSplit> boolean prepareToProcessRecord(ContinuousFileReaderOperator<?, T> op) throws IOException {
                return true;
            }

            @Override
            public void onNoMoreData(ContinuousFileReaderOperator<?, ?> op) {
                ((ContinuousFileReaderOperator)op).switchState(IDLE);
            }
        }
        ,
        FAILED{

            @Override
            public <T extends TimestampedInputSplit> boolean prepareToProcessRecord(ContinuousFileReaderOperator<?, T> op) throws IOException {
                throw new IllegalStateException("not processing any records in ERRORED state");
            }
        }
        ,
        FINISHING{

            @Override
            public <T extends TimestampedInputSplit> boolean prepareToProcessRecord(ContinuousFileReaderOperator<?, T> op) throws IOException {
                if (((ContinuousFileReaderOperator)op).currentSplit == null && !((ContinuousFileReaderOperator)op).splits.isEmpty()) {
                    ((ContinuousFileReaderOperator)op).loadSplit((TimestampedInputSplit)((ContinuousFileReaderOperator)op).splits.poll());
                }
                return true;
            }

            @Override
            public void onNoMoreData(ContinuousFileReaderOperator<?, ?> op) {
                ((ContinuousFileReaderOperator)op).enqueueProcessRecord();
                ((ContinuousFileReaderOperator)op).switchState(5.FINISHED);
            }
        }
        ,
        FINISHED{

            @Override
            public <T extends TimestampedInputSplit> boolean prepareToProcessRecord(ContinuousFileReaderOperator<?, T> op) {
                LOG.warn("not processing any records while closed");
                return false;
            }
        };

        private static final Set<ReaderState> ACCEPT_SPLITS;
        private static final Map<ReaderState, Set<ReaderState>> VALID_TRANSITIONS;

        public boolean isAcceptingSplits() {
            return ACCEPT_SPLITS.contains((Object)this);
        }

        public final boolean isTerminal() {
            return this == FINISHED;
        }

        public boolean canSwitchTo(ReaderState next) {
            return ((Set)VALID_TRANSITIONS.getOrDefault((Object)this, EnumSet.noneOf(ReaderState.class))).contains((Object)next);
        }

        public abstract <T extends TimestampedInputSplit> boolean prepareToProcessRecord(ContinuousFileReaderOperator<?, T> var1) throws IOException;

        public void onNoMoreData(ContinuousFileReaderOperator<?, ?> op) {
        }

        static {
            ACCEPT_SPLITS = EnumSet.of(IDLE, OPENING, READING);
            HashMap<ReaderState, EnumSet<ReaderState>> tmpTransitions = new HashMap<ReaderState, EnumSet<ReaderState>>();
            tmpTransitions.put(IDLE, EnumSet.of(OPENING, FINISHED, FAILED));
            tmpTransitions.put(OPENING, EnumSet.of(READING, FINISHING, FAILED));
            tmpTransitions.put(READING, EnumSet.of(IDLE, OPENING, FINISHING, FAILED));
            tmpTransitions.put(FINISHING, EnumSet.of(FINISHED, FAILED));
            tmpTransitions.put(FAILED, EnumSet.of(FINISHED));
            tmpTransitions.put(FINISHED, EnumSet.noneOf(ReaderState.class));
            VALID_TRANSITIONS = new EnumMap<ReaderState, Set<ReaderState>>(tmpTransitions);
        }
    }
}

