/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import net.snowflake.client.jdbc.internal.google.api.core.BetaApi;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BidiBlobWriteSessionConfig;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BlobWriteSessionConfig;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BufferToDiskThenUpload;
import net.snowflake.client.jdbc.internal.google.cloud.storage.DefaultBlobWriteSessionConfig;
import net.snowflake.client.jdbc.internal.google.cloud.storage.JournalingBlobWriteSessionConfig;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ParallelCompositeUploadBlobWriteSessionConfig;
import net.snowflake.client.jdbc.internal.google.cloud.storage.TransportCompatibility;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableList;

@BetaApi
public final class BlobWriteSessionConfigs {
    private BlobWriteSessionConfigs() {
    }

    @BetaApi
    @TransportCompatibility(value={TransportCompatibility.Transport.GRPC, TransportCompatibility.Transport.HTTP})
    public static DefaultBlobWriteSessionConfig getDefault() {
        return new DefaultBlobWriteSessionConfig(0x1000000);
    }

    @BetaApi
    @TransportCompatibility(value={TransportCompatibility.Transport.GRPC})
    public static BidiBlobWriteSessionConfig bidiWrite() {
        return new BidiBlobWriteSessionConfig(0x1000000);
    }

    @BetaApi
    @TransportCompatibility(value={TransportCompatibility.Transport.GRPC, TransportCompatibility.Transport.HTTP})
    public static BlobWriteSessionConfig bufferToTempDirThenUpload() throws IOException {
        return BlobWriteSessionConfigs.bufferToDiskThenUpload(Paths.get(System.getProperty("java.io.tmpdir"), "google-cloud-storage"));
    }

    @BetaApi
    @TransportCompatibility(value={TransportCompatibility.Transport.GRPC, TransportCompatibility.Transport.HTTP})
    public static BufferToDiskThenUpload bufferToDiskThenUpload(Path path) throws IOException {
        return BlobWriteSessionConfigs.bufferToDiskThenUpload(ImmutableList.of(path));
    }

    @BetaApi
    @TransportCompatibility(value={TransportCompatibility.Transport.GRPC, TransportCompatibility.Transport.HTTP})
    public static BufferToDiskThenUpload bufferToDiskThenUpload(Collection<Path> paths) throws IOException {
        return new BufferToDiskThenUpload(ImmutableList.copyOf(paths), false);
    }

    @BetaApi
    @TransportCompatibility(value={TransportCompatibility.Transport.GRPC})
    public static JournalingBlobWriteSessionConfig journaling(Collection<Path> paths) {
        return new JournalingBlobWriteSessionConfig(ImmutableList.copyOf(paths), false);
    }

    @BetaApi
    @TransportCompatibility(value={TransportCompatibility.Transport.GRPC, TransportCompatibility.Transport.HTTP})
    public static ParallelCompositeUploadBlobWriteSessionConfig parallelCompositeUpload() {
        return ParallelCompositeUploadBlobWriteSessionConfig.withDefaults();
    }
}

