/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.rpc;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.snowflake.client.jdbc.internal.google.api.core.BetaApi;
import net.snowflake.client.jdbc.internal.google.api.core.InternalExtensionOnly;
import net.snowflake.client.jdbc.internal.google.api.core.ObsoleteApi;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.RetrySettings;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.RetryingContext;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.EndpointContext;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.StatusCode;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.TransportChannel;
import net.snowflake.client.jdbc.internal.google.api.gax.tracing.ApiTracer;
import net.snowflake.client.jdbc.internal.google.auth.Credentials;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.javax.annotation.Nonnull;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

@InternalExtensionOnly
public interface ApiCallContext
extends RetryingContext {
    public ApiCallContext withCredentials(Credentials var1);

    public ApiCallContext withTransportChannel(TransportChannel var1);

    public ApiCallContext withEndpointContext(EndpointContext var1);

    @ObsoleteApi(value="Use withTimeoutDuration(java.time.Duration) instead")
    public ApiCallContext withTimeout(@Nullable net.snowflake.client.jdbc.internal.threeten.bp.Duration var1);

    public ApiCallContext withTimeoutDuration(@Nullable Duration var1);

    @Nullable
    @ObsoleteApi(value="Use getTimeoutDuration() instead")
    public net.snowflake.client.jdbc.internal.threeten.bp.Duration getTimeout();

    @Nullable
    public Duration getTimeoutDuration();

    @ObsoleteApi(value="Use withStreamWaitTimeoutDuration(java.time.Duration) instead")
    public ApiCallContext withStreamWaitTimeout(@Nullable net.snowflake.client.jdbc.internal.threeten.bp.Duration var1);

    public ApiCallContext withStreamWaitTimeoutDuration(@Nullable Duration var1);

    @Nullable
    @ObsoleteApi(value="Use getStreamWaitTimeoutDuration() instead")
    public net.snowflake.client.jdbc.internal.threeten.bp.Duration getStreamWaitTimeout();

    @Nullable
    public Duration getStreamWaitTimeoutDuration();

    @ObsoleteApi(value="Use withStreamIdleTimeoutDuration(java.time.Duration) instead")
    public ApiCallContext withStreamIdleTimeout(@Nullable net.snowflake.client.jdbc.internal.threeten.bp.Duration var1);

    public ApiCallContext withStreamIdleTimeoutDuration(@Nullable Duration var1);

    @Nullable
    @ObsoleteApi(value="Use getStreamIdleTimeoutDuration() instead")
    public net.snowflake.client.jdbc.internal.threeten.bp.Duration getStreamIdleTimeout();

    @Nullable
    public Duration getStreamIdleTimeoutDuration();

    @Override
    @BetaApi(value="The surface for tracing is not stable yet and may change in the future")
    @Nonnull
    public ApiTracer getTracer();

    @BetaApi(value="The surface for tracing is not stable yet and may change in the future")
    public ApiCallContext withTracer(@Nonnull ApiTracer var1);

    @BetaApi
    public ApiCallContext withRetrySettings(RetrySettings var1);

    @BetaApi
    public ApiCallContext withRetryableCodes(Set<StatusCode.Code> var1);

    public ApiCallContext nullToSelf(ApiCallContext var1);

    public ApiCallContext merge(ApiCallContext var1);

    @BetaApi(value="The surface for extra headers is not stable yet and may change in the future.")
    public ApiCallContext withExtraHeaders(Map<String, List<String>> var1);

    @BetaApi(value="The surface for extra headers is not stable yet and may change in the future.")
    public Map<String, List<String>> getExtraHeaders();

    @BetaApi(value="The surface for call context options is not stable yet and may change in the future.")
    public <T> ApiCallContext withOption(Key<T> var1, T var2);

    @BetaApi(value="The surface for call context options is not stable yet and may change in the future.")
    public <T> T getOption(Key<T> var1);

    public static final class Key<T> {
        private final String name;

        private Key(String name) {
            this.name = name;
        }

        public static <T> Key<T> create(String name) {
            Preconditions.checkNotNull(name, "Key name cannot be null.");
            return new Key<T>(name);
        }
    }
}

