/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.impl;

import java.io.IOException;
import java.util.Collection;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerator;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonToken;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.type.WritableTypeId;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.BeanProperty;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonMappingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializationFeature;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializerProvider;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.TypeSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.std.StaticListSerializerBase;

@JacksonStdImpl
public class StringCollectionSerializer
extends StaticListSerializerBase<Collection<String>> {
    public static final StringCollectionSerializer instance = new StringCollectionSerializer();

    protected StringCollectionSerializer() {
        super(Collection.class);
    }

    protected StringCollectionSerializer(StringCollectionSerializer src, Boolean unwrapSingle) {
        super(src, unwrapSingle);
    }

    @Override
    public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
        return new StringCollectionSerializer(this, unwrapSingle);
    }

    @Override
    protected JsonNode contentSchema() {
        return this.createSchemaNode("string", true);
    }

    @Override
    protected void acceptContentVisitor(JsonArrayFormatVisitor visitor) throws JsonMappingException {
        visitor.itemsFormat(JsonFormatTypes.STRING);
    }

    @Override
    public void serialize(Collection<String> value, JsonGenerator g2, SerializerProvider provider) throws IOException {
        int len = value.size();
        if (len == 1 && (this._unwrapSingle == null && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(value, g2, provider);
            return;
        }
        g2.writeStartArray(value, len);
        this.serializeContents(value, g2, provider);
        g2.writeEndArray();
    }

    @Override
    public void serializeWithType(Collection<String> value, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value, JsonToken.START_ARRAY));
        g2.assignCurrentValue(value);
        this.serializeContents(value, g2, provider);
        typeSer.writeTypeSuffix(g2, typeIdDef);
    }

    private final void serializeContents(Collection<String> value, JsonGenerator g2, SerializerProvider provider) throws IOException {
        int i = 0;
        try {
            for (String str : value) {
                if (str == null) {
                    provider.defaultSerializeNull(g2);
                } else {
                    g2.writeString(str);
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(provider, (Throwable)e, value, i);
        }
    }
}

