/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.trust.marks;

import java.util.Map;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSObject;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.SignedJWT;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.Identifier;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.Immutable;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;

@Immutable
public final class TrustMarkEntry
implements Map.Entry<Identifier, SignedJWT> {
    private final Identifier id;
    private final SignedJWT trustMark;

    public TrustMarkEntry(Identifier id, SignedJWT trustMark) {
        Objects.requireNonNull(id);
        this.id = id;
        Objects.requireNonNull(trustMark);
        if (JWSObject.State.UNSIGNED.equals((Object)trustMark.getState())) {
            throw new IllegalArgumentException("The trust mark must be in a signed state");
        }
        this.trustMark = trustMark;
    }

    public Identifier getID() {
        return this.id;
    }

    public SignedJWT getTrustMark() {
        return this.trustMark;
    }

    @Override
    public Identifier getKey() {
        return this.getID();
    }

    @Override
    public SignedJWT getValue() {
        return this.getTrustMark();
    }

    @Override
    public SignedJWT setValue(SignedJWT signedJWT) {
        throw new UnsupportedOperationException();
    }

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        o.put("id", this.getID().getValue());
        o.put("trust_mark", this.getTrustMark().serialize());
        return o;
    }

    public static TrustMarkEntry parse(JSONObject jsonObject) throws ParseException {
        String idString = JSONObjectUtils.getNonBlankString(jsonObject, "id");
        String jwtString = JSONObjectUtils.getNonBlankString(jsonObject, "trust_mark");
        try {
            return new TrustMarkEntry(new Identifier(idString), SignedJWT.parse(jwtString));
        }
        catch (java.text.ParseException e) {
            throw new ParseException(e.getMessage(), e);
        }
    }
}

