/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.JWT;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.http.HTTPMessage;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.http.ReadOnlyHTTPResponse;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.Nonce;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.ThreadSafe;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONArray;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;

@ThreadSafe
public class HTTPResponse
extends HTTPMessage
implements ReadOnlyHTTPResponse {
    public static final int SC_OK = 200;
    public static final int SC_CREATED = 201;
    public static final int SC_FOUND = 302;
    public static final int SC_BAD_REQUEST = 400;
    public static final int SC_UNAUTHORIZED = 401;
    public static final int SC_FORBIDDEN = 403;
    public static final int SC_NOT_FOUND = 404;
    public static final int SC_SERVER_ERROR = 500;
    public static final int SC_SERVICE_UNAVAILABLE = 503;
    private final int statusCode;
    private String statusMessage;

    public HTTPResponse(int statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean indicatesSuccess() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }

    public void ensureStatusCode(int ... expectedStatusCode) throws ParseException {
        for (int c : expectedStatusCode) {
            if (this.statusCode != c) continue;
            return;
        }
        throw new ParseException("Unexpected HTTP status code " + this.statusCode + ", must be " + Arrays.toString(expectedStatusCode));
    }

    public void ensureStatusCodeNotOK() throws ParseException {
        if (this.statusCode == 200) {
            throw new ParseException("Unexpected HTTP status code, must not be 200 (OK)");
        }
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String message) {
        this.statusMessage = message;
    }

    public URI getLocation() {
        String value = this.getHeaderValue("Location");
        if (value == null) {
            return null;
        }
        try {
            return new URI(value);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public void setLocation(URI location) {
        this.setHeader("Location", new String[]{location != null ? location.toString() : null});
    }

    public String getCacheControl() {
        return this.getHeaderValue("Cache-Control");
    }

    public void setCacheControl(String cacheControl) {
        this.setHeader("Cache-Control", new String[]{cacheControl});
    }

    public String getPragma() {
        return this.getHeaderValue("Pragma");
    }

    public void setPragma(String pragma) {
        this.setHeader("Pragma", new String[]{pragma});
    }

    public String getWWWAuthenticate() {
        return this.getHeaderValue("WWW-Authenticate");
    }

    public void setWWWAuthenticate(String wwwAuthenticate) {
        this.setHeader("WWW-Authenticate", new String[]{wwwAuthenticate});
    }

    public Nonce getDPoPNonce() {
        String nonce = this.getHeaderValue("DPoP-Nonce");
        if (nonce == null) {
            return null;
        }
        try {
            return new Nonce(nonce);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public void setDPoPNonce(Nonce nonce) {
        if (nonce != null) {
            this.setHeader("DPoP-Nonce", new String[]{nonce.getValue()});
        } else {
            this.setHeader("DPoP-Nonce", null);
        }
    }

    @Deprecated
    public String getContent() {
        return this.getBody();
    }

    @Deprecated
    public JSONObject getContentAsJSONObject() throws ParseException {
        return this.getBodyAsJSONObject();
    }

    @Deprecated
    public JSONArray getContentAsJSONArray() throws ParseException {
        return this.getBodyAsJSONArray();
    }

    @Deprecated
    public JWT getContentAsJWT() throws ParseException {
        return this.getBodyAsJWT();
    }

    @Deprecated
    public void setContent(String content) {
        this.setBody(content);
    }
}

