SELECT 'Upgrading MetaStore schema from 4.0.0 to 4.1.0';

-- HIVE-27725
DROP INDEX "TAB_COL_STATS_IDX";
CREATE INDEX "TAB_COL_STATS_IDX" ON "TAB_COL_STATS" USING btree ("TBL_ID","COLUMN_NAME");
DROP INDEX "TAB_COL_STATS_N49";
ALTER TABLE "TAB_COL_STATS" DROP COLUMN "CAT_NAME", DROP COLUMN "DB_NAME", DROP COLUMN "TABLE_NAME";

DROP INDEX "PCS_STATS_IDX";
CREATE INDEX "PCS_STATS_IDX" ON "PART_COL_STATS" USING btree ("PART_ID","COLUMN_NAME");
DROP INDEX "PART_COL_STATS_N49";
ALTER TABLE "PART_COL_STATS" DROP COLUMN "CAT_NAME", DROP COLUMN "DB_NAME", DROP COLUMN "TABLE_NAME", DROP COLUMN "PARTITION_NAME";

-- HIVE-28292
ALTER TABLE ONLY "TBLS" DROP CONSTRAINT "UNIQUETABLE";
ALTER TABLE ONLY "TBLS" ADD CONSTRAINT "UNIQUETABLE" UNIQUE ("DB_ID", "TBL_NAME");
DROP INDEX "TBLS_N49";

-- These lines need to be last. Insert any changes above.
UPDATE "VERSION" SET "SCHEMA_VERSION"='4.1.0', "VERSION_COMMENT"='Hive release version 4.1.0' where "VER_ID"=1;
SELECT 'Finished upgrading MetaStore schema from 4.0.0 to 4.1.0';
