/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.ExpressionUtils;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.util.Localiser;

public class StringSubstring2Method
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List<SQLExpression> args) {
        if (args == null || args.size() == 0 || args.size() > 2) {
            throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"substring", "StringExpression", 0, "NumericExpression/IntegerLiteral/ParameterLiteral"}));
        }
        if (args.size() == 1) {
            SQLExpression startExpr = args.get(0);
            if (!(startExpr instanceof NumericExpression) && !(startExpr instanceof ParameterLiteral)) {
                throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"substring", "StringExpression", 0, "NumericExpression/IntegerLiteral/ParameterLiteral"}));
            }
            SQLExpression one = ExpressionUtils.getLiteralForOne(stmt);
            List<SQLExpression> funcArgs = List.of(expr, startExpr.add(one));
            return new StringExpression(stmt, stmt.getSQLExpressionFactory().getMappingForType(String.class), "SUBSTRING", funcArgs);
        }
        SQLExpression startExpr = args.get(0);
        if (!(startExpr instanceof NumericExpression)) {
            throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"substring", "StringExpression", 0, "NumericExpression"}));
        }
        SQLExpression endExpr = args.get(1);
        if (!(endExpr instanceof NumericExpression)) {
            throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"substring", "StringExpression", 1, "NumericExpression"}));
        }
        SQLExpression one = ExpressionUtils.getLiteralForOne(stmt);
        List<SQLExpression> funcArgs = List.of(expr, startExpr.add(one), endExpr.sub(startExpr));
        return new StringExpression(stmt, stmt.getSQLExpressionFactory().getMappingForType(String.class), "SUBSTRING", funcArgs);
    }
}

