/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.common.ArrayOfBooleansSerDe;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;

final class KllMemoryValidate {
    final Memory srcMem;
    final ArrayOfItemsSerDe<?> serDe;
    final KllSketch.SketchType sketchType;
    final KllSketch.SketchStructure sketchStructure;
    final int preInts;
    final int serVer;
    final int familyID;
    final int flags;
    final int k;
    final int m;
    final boolean emptyFlag;
    final boolean level0SortedFlag;
    long n;
    int minK;
    int numLevels;
    int[] levelsArr;
    int sketchBytes = 0;
    private int typeBytes = 0;
    static final String EMPTY_FLAG_AND_COMPACT_EMPTY = "A compact empty sketch should have empty flag set. ";
    static final String EMPTY_FLAG_AND_COMPACT_FULL = "A compact full sketch should not have empty flag set. ";
    static final String EMPTY_FLAG_AND_COMPACT_SINGLE = "A single item sketch should not have empty flag set. ";
    static final String SRC_NOT_KLL = "FamilyID Field must be: " + Family.KLL.getID() + ", NOT: ";
    static final String MEMORY_TOO_SMALL = "A sketch memory image must be at least 8 bytes. ";

    KllMemoryValidate(Memory srcMem, KllSketch.SketchType sketchType) {
        this(srcMem, sketchType, null);
    }

    KllMemoryValidate(Memory srcMem, KllSketch.SketchType sketchType, ArrayOfItemsSerDe<?> serDe) {
        long memCapBytes = srcMem.getCapacity();
        if (memCapBytes < 8L) {
            throw new SketchesArgumentException(MEMORY_TOO_SMALL + memCapBytes);
        }
        this.srcMem = srcMem;
        this.sketchType = sketchType;
        this.serDe = serDe;
        this.preInts = KllPreambleUtil.getMemoryPreInts(srcMem);
        this.serVer = KllPreambleUtil.getMemorySerVer(srcMem);
        this.sketchStructure = KllSketch.SketchStructure.getSketchStructure(this.preInts, this.serVer);
        this.familyID = KllPreambleUtil.getMemoryFamilyID(srcMem);
        if (this.familyID != Family.KLL.getID()) {
            throw new SketchesArgumentException(SRC_NOT_KLL + this.familyID);
        }
        this.flags = KllPreambleUtil.getMemoryFlags(srcMem);
        this.k = KllPreambleUtil.getMemoryK(srcMem);
        this.m = KllPreambleUtil.getMemoryM(srcMem);
        KllHelper.checkM(this.m);
        KllHelper.checkK(this.k, this.m);
        this.emptyFlag = KllPreambleUtil.getMemoryEmptyFlag(srcMem);
        this.level0SortedFlag = KllPreambleUtil.getMemoryLevelZeroSortedFlag(srcMem);
        this.typeBytes = sketchType == KllSketch.SketchType.DOUBLES_SKETCH ? 8 : (sketchType == KllSketch.SketchType.FLOATS_SKETCH ? 4 : 0);
        this.validate();
    }

    private void validate() {
        switch (this.sketchStructure) {
            case COMPACT_FULL: {
                int capacityItems;
                if (this.emptyFlag) {
                    throw new SketchesArgumentException(EMPTY_FLAG_AND_COMPACT_FULL);
                }
                this.n = KllPreambleUtil.getMemoryN(this.srcMem);
                this.minK = KllPreambleUtil.getMemoryMinK(this.srcMem);
                this.numLevels = KllPreambleUtil.getMemoryNumLevels(this.srcMem);
                this.levelsArr = new int[this.numLevels + 1];
                this.srcMem.getIntArray(20L, this.levelsArr, 0, this.numLevels);
                this.levelsArr[this.numLevels] = capacityItems = KllHelper.computeTotalItemCapacity(this.k, this.m, this.numLevels);
                this.sketchBytes = KllMemoryValidate.computeSketchBytes(this.srcMem, this.sketchType, this.levelsArr, false, this.serDe);
                break;
            }
            case COMPACT_EMPTY: {
                if (!this.emptyFlag) {
                    throw new SketchesArgumentException(EMPTY_FLAG_AND_COMPACT_EMPTY);
                }
                this.n = 0L;
                this.minK = this.k;
                this.numLevels = 1;
                this.levelsArr = new int[]{this.k, this.k};
                this.sketchBytes = 8;
                break;
            }
            case COMPACT_SINGLE: {
                if (this.emptyFlag) {
                    throw new SketchesArgumentException(EMPTY_FLAG_AND_COMPACT_SINGLE);
                }
                this.n = 1L;
                this.minK = this.k;
                this.numLevels = 1;
                this.levelsArr = new int[]{this.k - 1, this.k};
                if (this.sketchType == KllSketch.SketchType.ITEMS_SKETCH) {
                    this.sketchBytes = 8 + this.serDe.sizeOf(this.srcMem, 8L, 1);
                    break;
                }
                this.sketchBytes = 8 + this.typeBytes;
                break;
            }
            case UPDATABLE: {
                this.n = KllPreambleUtil.getMemoryN(this.srcMem);
                this.minK = KllPreambleUtil.getMemoryMinK(this.srcMem);
                this.numLevels = KllPreambleUtil.getMemoryNumLevels(this.srcMem);
                this.levelsArr = new int[this.numLevels + 1];
                this.srcMem.getIntArray(20L, this.levelsArr, 0, this.numLevels + 1);
                this.sketchBytes = KllMemoryValidate.computeSketchBytes(this.srcMem, this.sketchType, this.levelsArr, true, this.serDe);
                break;
            }
        }
    }

    static int computeSketchBytes(Memory srcMem, KllSketch.SketchType sketchType, int[] levelsArr, boolean updatable, ArrayOfItemsSerDe<?> serDe) {
        int numLevels = levelsArr.length - 1;
        int capacityItems = levelsArr[numLevels];
        int retainedItems = levelsArr[numLevels] - levelsArr[0];
        int levelsLen = updatable ? levelsArr.length : levelsArr.length - 1;
        int numItems = updatable ? capacityItems : retainedItems;
        int offsetBytes = 20 + levelsLen * 4;
        if (sketchType == KllSketch.SketchType.ITEMS_SKETCH) {
            offsetBytes = serDe instanceof ArrayOfBooleansSerDe ? (offsetBytes += serDe.sizeOf(srcMem, offsetBytes, numItems) + 2) : (offsetBytes += serDe.sizeOf(srcMem, offsetBytes, numItems + 2));
        } else {
            int typeBytes = sketchType.getBytes();
            offsetBytes += (numItems + 2) * typeBytes;
        }
        return offsetBytes;
    }
}

