/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.util.Optional;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHook;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHookContext;
import org.apache.hadoop.hive.ql.session.SessionStateUtil;
import org.apache.iceberg.mr.Catalogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveIcebergQueryLifeTimeHook
implements QueryLifeTimeHook {
    private static final Logger LOG = LoggerFactory.getLogger(HiveIcebergQueryLifeTimeHook.class);

    public void beforeCompile(QueryLifeTimeHookContext ctx) {
    }

    public void afterCompile(QueryLifeTimeHookContext ctx, boolean hasError) {
        if (hasError) {
            this.checkAndRollbackIcebergCTAS(ctx);
        }
    }

    public void beforeExecution(QueryLifeTimeHookContext ctx) {
    }

    public void afterExecution(QueryLifeTimeHookContext ctx, boolean hasError) {
        if (hasError) {
            this.checkAndRollbackIcebergCTAS(ctx);
        }
    }

    private void checkAndRollbackIcebergCTAS(QueryLifeTimeHookContext ctx) {
        HiveConf conf = ctx.getHiveConf();
        Optional tableName = SessionStateUtil.getProperty((Configuration)conf, (String)"iceberg.mr.ctas.table.name");
        if (tableName.isPresent()) {
            LOG.info("Dropping the following CTAS target table as part of rollback: {}", tableName.get());
            Properties props = new Properties();
            props.put("name", tableName.get());
            Catalogs.dropTable((Configuration)conf, props);
        }
    }
}

