/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.theta;

import java.util.Arrays;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.theta.UnionState;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.Sketch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

public abstract class UnionEvaluator
extends GenericUDAFEvaluator {
    protected static final String NOMINAL_ENTRIES_FIELD = "nominalEntries";
    protected static final String SEED_FIELD = "seed";
    protected static final String SKETCH_FIELD = "sketch";
    protected transient PrimitiveObjectInspector inputObjectInspector;
    protected transient PrimitiveObjectInspector nominalEntriesObjectInspector;
    protected transient PrimitiveObjectInspector seedObjectInspector;
    protected transient StructObjectInspector intermediateObjectInspector;

    public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
        UnionState state = (UnionState)agg;
        Sketch intermediate = state.getResult();
        if (intermediate == null) {
            return null;
        }
        byte[] bytes = intermediate.toByteArray();
        return Arrays.asList(new IntWritable(state.getNominalEntries()), new LongWritable(state.getSeed()), new BytesWritable(bytes));
    }

    public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
        if (partial == null) {
            return;
        }
        UnionState state = (UnionState)agg;
        if (!state.isInitialized()) {
            this.initializeState(state, partial);
        }
        Memory serializedSketch = BytesWritableHelper.wrapAsMemory((BytesWritable)this.intermediateObjectInspector.getStructFieldData(partial, this.intermediateObjectInspector.getStructFieldRef(SKETCH_FIELD)));
        state.update(serializedSketch);
    }

    private void initializeState(UnionState state, Object partial) {
        int nominalEntries = ((IntWritable)this.intermediateObjectInspector.getStructFieldData(partial, this.intermediateObjectInspector.getStructFieldRef(NOMINAL_ENTRIES_FIELD))).get();
        long seed = ((LongWritable)this.intermediateObjectInspector.getStructFieldData(partial, this.intermediateObjectInspector.getStructFieldRef(SEED_FIELD))).get();
        state.init(nominalEntries, seed);
    }

    public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
        UnionState state = (UnionState)agg;
        Sketch result = state.getResult();
        if (result == null) {
            return null;
        }
        return new BytesWritable(result.toByteArray());
    }

    public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
        UnionState state = (UnionState)agg;
        state.reset();
    }

    public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new UnionState();
    }
}

