/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.vmplugin;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.groovy.util.Maps;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.vmplugin.VMPlugin;

public class VMPluginFactory {
    private static final Map<Integer, String> PLUGIN_MAP = Maps.of(16, "org.codehaus.groovy.vmplugin.v16.Java16", 10, "org.codehaus.groovy.vmplugin.v10.Java10");
    private static final VMPlugin PLUGIN = VMPluginFactory.createPlugin();

    private static VMPlugin createPlugin() {
        return VMPluginFactory.doPrivileged(() -> {
            ClassLoader loader = VMPluginFactory.class.getClassLoader();
            int specVer = Runtime.version().feature();
            for (Map.Entry<Integer, String> entry : PLUGIN_MAP.entrySet()) {
                if (specVer < entry.getKey()) continue;
                String fullName = entry.getValue();
                try {
                    return (VMPlugin)loader.loadClass(fullName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    Logger log = Logger.getLogger(VMPluginFactory.class.getName());
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Trying to create VM plugin `" + fullName + "`, but failed:\n" + DefaultGroovyMethods.asString(t));
                    }
                    return null;
                }
            }
            return null;
        });
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return AccessController.doPrivileged(action);
    }

    public static VMPlugin getPlugin() {
        return PLUGIN;
    }
}

