/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NonEmptyEntityException;
import org.apache.gravitino.meta.BaseMetalake;
import org.apache.gravitino.meta.CatalogEntity;
import org.apache.gravitino.metrics.MethodMonitorAspect;
import org.apache.gravitino.metrics.Monitored;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.storage.relational.mapper.CatalogMetaMapper;
import org.apache.gravitino.storage.relational.mapper.FilesetMetaMapper;
import org.apache.gravitino.storage.relational.mapper.FilesetVersionMapper;
import org.apache.gravitino.storage.relational.mapper.GroupMetaMapper;
import org.apache.gravitino.storage.relational.mapper.GroupRoleRelMapper;
import org.apache.gravitino.storage.relational.mapper.JobMetaMapper;
import org.apache.gravitino.storage.relational.mapper.JobTemplateMetaMapper;
import org.apache.gravitino.storage.relational.mapper.MetalakeMetaMapper;
import org.apache.gravitino.storage.relational.mapper.ModelMetaMapper;
import org.apache.gravitino.storage.relational.mapper.ModelVersionAliasRelMapper;
import org.apache.gravitino.storage.relational.mapper.ModelVersionMetaMapper;
import org.apache.gravitino.storage.relational.mapper.OwnerMetaMapper;
import org.apache.gravitino.storage.relational.mapper.PolicyMetaMapper;
import org.apache.gravitino.storage.relational.mapper.PolicyVersionMapper;
import org.apache.gravitino.storage.relational.mapper.RoleMetaMapper;
import org.apache.gravitino.storage.relational.mapper.SchemaMetaMapper;
import org.apache.gravitino.storage.relational.mapper.SecurableObjectMapper;
import org.apache.gravitino.storage.relational.mapper.StatisticMetaMapper;
import org.apache.gravitino.storage.relational.mapper.TableColumnMapper;
import org.apache.gravitino.storage.relational.mapper.TableMetaMapper;
import org.apache.gravitino.storage.relational.mapper.TagMetaMapper;
import org.apache.gravitino.storage.relational.mapper.TagMetadataObjectRelMapper;
import org.apache.gravitino.storage.relational.mapper.TopicMetaMapper;
import org.apache.gravitino.storage.relational.mapper.UserMetaMapper;
import org.apache.gravitino.storage.relational.mapper.UserRoleRelMapper;
import org.apache.gravitino.storage.relational.po.MetalakePO;
import org.apache.gravitino.storage.relational.service.CatalogMetaService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class MetalakeMetaService {
    private static final MetalakeMetaService INSTANCE;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ Annotation ajc$anno$6;

    public static MetalakeMetaService getInstance() {
        return INSTANCE;
    }

    private MetalakeMetaService() {
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listMetalakes")
    public List<BaseMetalake> listMetalakes() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = MetalakeMetaService.class.getDeclaredMethod("listMetalakes", new Class[0]).getAnnotation(Monitored.class);
        }
        return (List)MetalakeMetaService.listMetalakes_aroundBody1$advice(this, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getMetalakeIdByName")
    public Long getMetalakeIdByName(String metalakeName) {
        String string = metalakeName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = MetalakeMetaService.class.getDeclaredMethod("getMetalakeIdByName", String.class).getAnnotation(Monitored.class);
        }
        return (Long)MetalakeMetaService.getMetalakeIdByName_aroundBody3$advice(this, string, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getMetalakeByIdentifier")
    public BaseMetalake getMetalakeByIdentifier(NameIdentifier ident) {
        NameIdentifier nameIdentifier = ident;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = MetalakeMetaService.class.getDeclaredMethod("getMetalakeByIdentifier", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return (BaseMetalake)MetalakeMetaService.getMetalakeByIdentifier_aroundBody5$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="insertMetalake")
    public void insertMetalake(BaseMetalake baseMetalake, boolean overwrite) throws IOException {
        BaseMetalake baseMetalake2 = baseMetalake;
        boolean bl = overwrite;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)baseMetalake2, (Object)Conversions.booleanObject((boolean)bl));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = MetalakeMetaService.class.getDeclaredMethod("insertMetalake", BaseMetalake.class, Boolean.TYPE).getAnnotation(Monitored.class);
        }
        MetalakeMetaService.insertMetalake_aroundBody7$advice(this, baseMetalake2, bl, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="updateMetalake")
    public <E extends Entity & HasIdentifier> BaseMetalake updateMetalake(NameIdentifier ident, Function<E, E> updater) throws IOException {
        NameIdentifier nameIdentifier = ident;
        Function<E, E> function = updater;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)nameIdentifier, function);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = MetalakeMetaService.class.getDeclaredMethod("updateMetalake", NameIdentifier.class, Function.class).getAnnotation(Monitored.class);
        }
        return (BaseMetalake)MetalakeMetaService.updateMetalake_aroundBody9$advice(this, nameIdentifier, function, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteMetalake")
    public boolean deleteMetalake(NameIdentifier ident, boolean cascade) {
        NameIdentifier nameIdentifier = ident;
        boolean bl = cascade;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)nameIdentifier, (Object)Conversions.booleanObject((boolean)bl));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = MetalakeMetaService.class.getDeclaredMethod("deleteMetalake", NameIdentifier.class, Boolean.TYPE).getAnnotation(Monitored.class);
        }
        return Conversions.booleanValue((Object)MetalakeMetaService.deleteMetalake_aroundBody11$advice(this, nameIdentifier, bl, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteMetalakeMetasByLegacyTimeline")
    public int deleteMetalakeMetasByLegacyTimeline(Long legacyTimeline, int limit) {
        Long l = legacyTimeline;
        int n = limit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)l, (Object)Conversions.intObject((int)n));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = MetalakeMetaService.class.getDeclaredMethod("deleteMetalakeMetasByLegacyTimeline", Long.class, Integer.TYPE).getAnnotation(Monitored.class);
        }
        return Conversions.intValue((Object)MetalakeMetaService.deleteMetalakeMetasByLegacyTimeline_aroundBody13$advice(this, l, n, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    static {
        MetalakeMetaService.ajc$preClinit();
        INSTANCE = new MetalakeMetaService();
    }

    private static final /* synthetic */ List listMetalakes_aroundBody0(MetalakeMetaService ajc$this, JoinPoint joinPoint) {
        List metalakePOS = SessionUtils.getWithoutCommit(MetalakeMetaMapper.class, MetalakeMetaMapper::listMetalakePOs);
        return POConverters.fromMetalakePOs(metalakePOS);
    }

    private static final /* synthetic */ Object listMetalakes_aroundBody1$advice(MetalakeMetaService ajc$this, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetalakeMetaService.listMetalakes_aroundBody0(ajc$this, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetalakeMetaService.listMetalakes_aroundBody0(ajc$this, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = MetalakeMetaService.listMetalakes_aroundBody0(ajc$this, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ Long getMetalakeIdByName_aroundBody2(MetalakeMetaService ajc$this, String metalakeName, JoinPoint joinPoint) {
        Long metalakeId = SessionUtils.getWithoutCommit(MetalakeMetaMapper.class, mapper -> mapper.selectMetalakeIdMetaByName(metalakeName));
        if (metalakeId == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.METALAKE.name().toLowerCase(), metalakeName});
        }
        return metalakeId;
    }

    private static final /* synthetic */ Object getMetalakeIdByName_aroundBody3$advice(MetalakeMetaService ajc$this, String metalakeName, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Long l;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetalakeMetaService.getMetalakeIdByName_aroundBody2(ajc$this, metalakeName, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetalakeMetaService.getMetalakeIdByName_aroundBody2(ajc$this, metalakeName, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Long result = MetalakeMetaService.getMetalakeIdByName_aroundBody2(ajc$this, metalakeName, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                l = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return l;
    }

    private static final /* synthetic */ BaseMetalake getMetalakeByIdentifier_aroundBody4(MetalakeMetaService ajc$this, NameIdentifier ident, JoinPoint joinPoint) {
        NameIdentifierUtil.checkMetalake(ident);
        MetalakePO metalakePO = SessionUtils.getWithoutCommit(MetalakeMetaMapper.class, mapper -> mapper.selectMetalakeMetaByName(ident.name()));
        if (metalakePO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.METALAKE.name().toLowerCase(), ident.toString()});
        }
        return POConverters.fromMetalakePO(metalakePO);
    }

    private static final /* synthetic */ Object getMetalakeByIdentifier_aroundBody5$advice(MetalakeMetaService ajc$this, NameIdentifier ident, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        BaseMetalake baseMetalake;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetalakeMetaService.getMetalakeByIdentifier_aroundBody4(ajc$this, ident, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetalakeMetaService.getMetalakeByIdentifier_aroundBody4(ajc$this, ident, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                BaseMetalake result = MetalakeMetaService.getMetalakeByIdentifier_aroundBody4(ajc$this, ident, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                baseMetalake = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return baseMetalake;
    }

    private static final /* synthetic */ void insertMetalake_aroundBody6(MetalakeMetaService ajc$this, BaseMetalake baseMetalake, boolean overwrite, JoinPoint joinPoint) {
        try {
            NameIdentifierUtil.checkMetalake(baseMetalake.nameIdentifier());
            SessionUtils.doWithCommit(MetalakeMetaMapper.class, mapper -> {
                MetalakePO po = POConverters.initializeMetalakePOWithVersion(baseMetalake);
                if (overwrite) {
                    mapper.insertMetalakeMetaOnDuplicateKeyUpdate(po);
                } else {
                    mapper.insertMetalakeMeta(po);
                }
            });
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.METALAKE, baseMetalake.nameIdentifier().toString());
            throw re;
        }
    }

    private static final /* synthetic */ Object insertMetalake_aroundBody7$advice(MetalakeMetaService ajc$this, BaseMetalake baseMetalake, boolean overwrite, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object var14_19;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                MetalakeMetaService.insertMetalake_aroundBody6(ajc$this, baseMetalake, overwrite, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                MetalakeMetaService.insertMetalake_aroundBody6(ajc$this, baseMetalake, overwrite, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                MetalakeMetaService.insertMetalake_aroundBody6(ajc$this, baseMetalake, overwrite, (JoinPoint)proceedingJoinPoint);
                Object result = null;
                successMeter.mark();
                var14_19 = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return var14_19;
    }

    private static final /* synthetic */ BaseMetalake updateMetalake_aroundBody8(MetalakeMetaService ajc$this, NameIdentifier ident, Function updater, JoinPoint joinPoint) {
        Integer updateResult;
        NameIdentifierUtil.checkMetalake(ident);
        MetalakePO oldMetalakePO = SessionUtils.getWithoutCommit(MetalakeMetaMapper.class, mapper -> mapper.selectMetalakeMetaByName(ident.name()));
        if (oldMetalakePO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.METALAKE.name().toLowerCase(), ident.toString()});
        }
        BaseMetalake oldMetalakeEntity = POConverters.fromMetalakePO(oldMetalakePO);
        BaseMetalake newMetalakeEntity = (BaseMetalake)updater.apply(oldMetalakeEntity);
        Preconditions.checkArgument((boolean)Objects.equals(oldMetalakeEntity.id(), newMetalakeEntity.id()), (String)"The updated metalake entity id: %s should be same with the metalake entity id before: %s", (Object)newMetalakeEntity.id(), (Object)oldMetalakeEntity.id());
        MetalakePO newMetalakePO = POConverters.updateMetalakePOWithVersion(oldMetalakePO, newMetalakeEntity);
        try {
            updateResult = SessionUtils.doWithCommitAndFetchResult(MetalakeMetaMapper.class, mapper -> mapper.updateMetalakeMeta(newMetalakePO, oldMetalakePO));
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.METALAKE, newMetalakeEntity.nameIdentifier().toString());
            throw re;
        }
        if (updateResult > 0) {
            return newMetalakeEntity;
        }
        throw new IOException("Failed to update the entity: " + String.valueOf(ident));
    }

    private static final /* synthetic */ Object updateMetalake_aroundBody9$advice(MetalakeMetaService ajc$this, NameIdentifier ident, Function updater, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        BaseMetalake baseMetalake;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetalakeMetaService.updateMetalake_aroundBody8(ajc$this, ident, updater, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetalakeMetaService.updateMetalake_aroundBody8(ajc$this, ident, updater, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                BaseMetalake result = MetalakeMetaService.updateMetalake_aroundBody8(ajc$this, ident, updater, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                baseMetalake = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return baseMetalake;
    }

    private static final /* synthetic */ boolean deleteMetalake_aroundBody10(MetalakeMetaService ajc$this, NameIdentifier ident, boolean cascade, JoinPoint joinPoint) {
        NameIdentifierUtil.checkMetalake(ident);
        Long metalakeId = ajc$this.getMetalakeIdByName(ident.name());
        if (metalakeId != null) {
            if (cascade) {
                SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(MetalakeMetaMapper.class, mapper -> mapper.softDeleteMetalakeMetaByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(CatalogMetaMapper.class, mapper -> mapper.softDeleteCatalogMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(SchemaMetaMapper.class, mapper -> mapper.softDeleteSchemaMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(TableMetaMapper.class, mapper -> mapper.softDeleteTableMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(TableColumnMapper.class, mapper -> mapper.softDeleteColumnsByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(FilesetMetaMapper.class, mapper -> mapper.softDeleteFilesetMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(FilesetVersionMapper.class, mapper -> mapper.softDeleteFilesetVersionsByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(TopicMetaMapper.class, mapper -> mapper.softDeleteTopicMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(UserRoleRelMapper.class, mapper -> mapper.softDeleteUserRoleRelByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(UserMetaMapper.class, mapper -> mapper.softDeleteUserMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(GroupRoleRelMapper.class, mapper -> mapper.softDeleteGroupRoleRelByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(GroupMetaMapper.class, mapper -> mapper.softDeleteGroupMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(RoleMetaMapper.class, mapper -> mapper.softDeleteRoleMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(SecurableObjectMapper.class, mapper -> mapper.softDeleteSecurableObjectsByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(TagMetaMapper.class, mapper -> mapper.softDeleteTagMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(TagMetadataObjectRelMapper.class, mapper -> mapper.softDeleteTagMetadataObjectRelsByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(PolicyMetaMapper.class, mapper -> mapper.softDeletePolicyMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(PolicyVersionMapper.class, mapper -> mapper.softDeletePolicyVersionsByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.softDeleteOwnerRelByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> mapper.softDeleteModelVersionAliasRelsByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(ModelVersionMetaMapper.class, mapper -> mapper.softDeleteModelVersionMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(ModelMetaMapper.class, mapper -> mapper.softDeleteModelMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(StatisticMetaMapper.class, mapper -> mapper.softDeleteStatisticsByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(JobTemplateMetaMapper.class, mapper -> mapper.softDeleteJobTemplateMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(JobMetaMapper.class, mapper -> mapper.softDeleteJobMetasByMetalakeId(metalakeId)));
            } else {
                List<CatalogEntity> catalogEntities = CatalogMetaService.getInstance().listCatalogsByNamespace(NamespaceUtil.ofCatalog(ident.name()));
                if (!catalogEntities.isEmpty()) {
                    throw new NonEmptyEntityException("Entity %s has sub-entities, you should remove sub-entities first", new Object[]{ident});
                }
                SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(MetalakeMetaMapper.class, mapper -> mapper.softDeleteMetalakeMetaByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(UserRoleRelMapper.class, mapper -> mapper.softDeleteUserRoleRelByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(UserMetaMapper.class, mapper -> mapper.softDeleteUserMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(GroupRoleRelMapper.class, mapper -> mapper.softDeleteGroupRoleRelByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(GroupMetaMapper.class, mapper -> mapper.softDeleteGroupMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(RoleMetaMapper.class, mapper -> mapper.softDeleteRoleMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(SecurableObjectMapper.class, mapper -> mapper.softDeleteSecurableObjectsByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(TagMetaMapper.class, mapper -> mapper.softDeleteTagMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(TagMetadataObjectRelMapper.class, mapper -> mapper.softDeleteTagMetadataObjectRelsByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.softDeleteOwnerRelByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(StatisticMetaMapper.class, mapper -> mapper.softDeleteStatisticsByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(JobTemplateMetaMapper.class, mapper -> mapper.softDeleteJobTemplateMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(JobMetaMapper.class, mapper -> mapper.softDeleteJobMetasByMetalakeId(metalakeId)));
            }
        }
        return true;
    }

    private static final /* synthetic */ Object deleteMetalake_aroundBody11$advice(MetalakeMetaService ajc$this, NameIdentifier ident, boolean cascade, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)MetalakeMetaService.deleteMetalake_aroundBody10(ajc$this, ident, cascade, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)MetalakeMetaService.deleteMetalake_aroundBody10(ajc$this, ident, cascade, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.booleanObject((boolean)MetalakeMetaService.deleteMetalake_aroundBody10(ajc$this, ident, cascade, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static final /* synthetic */ int deleteMetalakeMetasByLegacyTimeline_aroundBody12(MetalakeMetaService ajc$this, Long legacyTimeline, int limit, JoinPoint joinPoint) {
        int[] metalakeDeleteCount = new int[]{0};
        int[] ownerRelDeleteCount = new int[]{0};
        SessionUtils.doMultipleWithCommit(() -> {
            metalakeDeleteCount[0] = SessionUtils.getWithoutCommit(MetalakeMetaMapper.class, mapper -> mapper.deleteMetalakeMetasByLegacyTimeline(legacyTimeline, limit));
        }, () -> {
            ownerRelDeleteCount[0] = SessionUtils.getWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.deleteOwnerMetasByLegacyTimeline(legacyTimeline, limit));
        });
        return metalakeDeleteCount[0] + ownerRelDeleteCount[0];
    }

    private static final /* synthetic */ Object deleteMetalakeMetasByLegacyTimeline_aroundBody13$advice(MetalakeMetaService ajc$this, Long legacyTimeline, int limit, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)MetalakeMetaService.deleteMetalakeMetasByLegacyTimeline_aroundBody12(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)MetalakeMetaService.deleteMetalakeMetasByLegacyTimeline_aroundBody12(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.intObject((int)MetalakeMetaService.deleteMetalakeMetasByLegacyTimeline_aroundBody12(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MetalakeMetaService.java", MetalakeMetaService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listMetalakes", "org.apache.gravitino.storage.relational.service.MetalakeMetaService", "", "", "", "java.util.List"), 85);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMetalakeIdByName", "org.apache.gravitino.storage.relational.service.MetalakeMetaService", "java.lang.String", "metalakeName", "", "java.lang.Long"), 95);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMetalakeByIdentifier", "org.apache.gravitino.storage.relational.service.MetalakeMetaService", "org.apache.gravitino.NameIdentifier", "ident", "", "org.apache.gravitino.meta.BaseMetalake"), 111);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "insertMetalake", "org.apache.gravitino.storage.relational.service.MetalakeMetaService", "org.apache.gravitino.meta.BaseMetalake:boolean", "baseMetalake:overwrite", "java.io.IOException", "void"), 129);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateMetalake", "org.apache.gravitino.storage.relational.service.MetalakeMetaService", "org.apache.gravitino.NameIdentifier:java.util.function.Function", "ident:updater", "java.io.IOException", "org.apache.gravitino.meta.BaseMetalake"), 152);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteMetalake", "org.apache.gravitino.storage.relational.service.MetalakeMetaService", "org.apache.gravitino.NameIdentifier:boolean", "ident:cascade", "", "boolean"), 195);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteMetalakeMetasByLegacyTimeline", "org.apache.gravitino.storage.relational.service.MetalakeMetaService", "java.lang.Long:int", "legacyTimeline:limit", "", "int"), 370);
    }
}

