/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.info;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.gravitino.Audit;
import org.apache.gravitino.annotation.DeveloperApi;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Distributions;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.indexes.Indexes;

@DeveloperApi
public final class TableInfo {
    private final String name;
    private final Column[] columns;
    @Nullable
    private final String comment;
    private final Map<String, String> properties;
    private final Transform[] partitions;
    private final Distribution distribution;
    private final SortOrder[] sortOrders;
    private final Index[] indexes;
    @Nullable
    private final Audit auditInfo;

    public TableInfo(Table table) {
        this(table.name(), table.columns(), table.comment(), table.properties(), table.partitioning(), table.distribution(), table.sortOrder(), table.index(), table.auditInfo());
    }

    public TableInfo(String name, Column[] columns, String comment, Map<String, String> properties, Transform[] partitions, Distribution distribution, SortOrder[] sortOrders, Index[] indexes, Audit auditInfo) {
        this.name = name;
        this.columns = (Column[])columns.clone();
        this.comment = comment;
        this.properties = properties == null ? ImmutableMap.of() : ImmutableMap.copyOf(properties);
        this.partitions = partitions == null ? new Transform[]{} : (Transform[])partitions.clone();
        this.distribution = distribution == null ? Distributions.NONE : distribution;
        this.sortOrders = sortOrders == null ? new SortOrder[]{} : (SortOrder[])sortOrders.clone();
        this.indexes = indexes == null ? Indexes.EMPTY_INDEXES : (Index[])indexes.clone();
        this.auditInfo = auditInfo;
    }

    @Nullable
    public Audit auditInfo() {
        return this.auditInfo;
    }

    public String name() {
        return this.name;
    }

    public Column[] columns() {
        return this.columns;
    }

    public Transform[] partitioning() {
        return this.partitions;
    }

    public SortOrder[] sortOrder() {
        return this.sortOrders;
    }

    public Distribution distribution() {
        return this.distribution;
    }

    public Index[] index() {
        return this.indexes;
    }

    @Nullable
    public String comment() {
        return this.comment;
    }

    public Map<String, String> properties() {
        return this.properties;
    }
}

