/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Striped;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import org.apache.gravitino.cache.EntityCache;

public class SegmentedLock {
    private final Striped<Lock> stripedLocks;
    private static final Object NULL_KEY = new Object();
    private final AtomicReference<CountDownLatch> globalOperationLatch = new AtomicReference();

    public SegmentedLock(int numSegments) {
        if (numSegments <= 0) {
            throw new IllegalArgumentException("Number of segments must be positive, got: " + numSegments);
        }
        this.stripedLocks = Striped.lock((int)numSegments);
    }

    public Lock getSegmentLock(Object key) {
        return (Lock)this.stripedLocks.get(this.normalizeKey(key));
    }

    private Object normalizeKey(Object key) {
        return key != null ? key : NULL_KEY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withLock(Object key, Runnable action) {
        this.waitForGlobalComplete();
        Lock lock = this.getSegmentLock(key);
        try {
            lock.lockInterruptibly();
            try {
                action.run();
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread was interrupted while waiting for lock", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T withLock(Object key, Supplier<T> action) {
        this.waitForGlobalComplete();
        Lock lock = this.getSegmentLock(key);
        try {
            lock.lockInterruptibly();
            try {
                T t = action.get();
                return t;
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread was interrupted while waiting for lock", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T, E extends Exception> T withLockAndThrow(Object key, EntityCache.ThrowingSupplier<T, E> action) throws E {
        this.waitForGlobalComplete();
        Lock lock = this.getSegmentLock(key);
        try {
            lock.lockInterruptibly();
            try {
                T t = action.get();
                return t;
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Thread was interrupted while waiting for lock", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Exception> void withLockAndThrow(Object key, EntityCache.ThrowingRunnable<E> action) throws E {
        this.waitForGlobalComplete();
        Lock lock = this.getSegmentLock(key);
        try {
            lock.lockInterruptibly();
            try {
                action.run();
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Thread was interrupted while waiting for lock", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withGlobalLock(Runnable action) {
        CountDownLatch latch = new CountDownLatch(1);
        if (!this.globalOperationLatch.compareAndSet(null, latch)) {
            throw new IllegalStateException("Global operation already in progress");
        }
        try {
            SegmentedLock segmentedLock = this;
            synchronized (segmentedLock) {
                action.run();
            }
        }
        finally {
            this.globalOperationLatch.set(null);
            latch.countDown();
        }
    }

    private void waitForGlobalComplete() {
        CountDownLatch latch = this.globalOperationLatch.get();
        if (latch != null) {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Thread was interrupted while waiting for global operation to complete", e);
            }
        }
    }

    @VisibleForTesting
    public boolean isClearing() {
        return this.globalOperationLatch.get() != null;
    }

    public int getNumSegments() {
        return this.stripedLocks.size();
    }
}

