/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.authentication;

import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;
import org.apache.gravitino.server.authentication.ProviderType;

public interface OAuthConfig {
    public static final String OAUTH_CONFIG_PREFIX = "gravitino.authenticator.oauth.";
    public static final ConfigEntry<String> SERVICE_AUDIENCE = new ConfigBuilder("gravitino.authenticator.oauth.serviceAudience").doc("The audience name when Gravitino uses OAuth as the authenticator").version("0.3.0").stringConf().createWithDefault((Object)"GravitinoServer");
    public static final ConfigEntry<Long> ALLOW_SKEW_SECONDS = new ConfigBuilder("gravitino.authenticator.oauth.allowSkewSecs").doc("The JWT allows skew seconds when Gravitino uses OAuth as the authenticator").version("0.3.0").longConf().createWithDefault((Object)0L);
    public static final ConfigEntry<String> DEFAULT_SIGN_KEY = new ConfigBuilder("gravitino.authenticator.oauth.defaultSignKey").doc("The signing key of JWT when Gravitino uses OAuth as the authenticator").version("0.3.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> SIGNATURE_ALGORITHM_TYPE = new ConfigBuilder("gravitino.authenticator.oauth.signAlgorithmType").doc("The signature algorithm when Gravitino uses OAuth as the authenticator").version("0.3.0").stringConf().createWithDefault((Object)SignatureAlgorithm.RS256.name());
    public static final ConfigEntry<String> DEFAULT_SERVER_URI = new ConfigBuilder("gravitino.authenticator.oauth.serverUri").doc("The uri of the default OAuth server").version("0.3.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> DEFAULT_TOKEN_PATH = new ConfigBuilder("gravitino.authenticator.oauth.tokenPath").doc("The path for token of the default OAuth server").version("0.3.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> PROVIDER = new ConfigBuilder("gravitino.authenticator.oauth.provider").doc("The OAuth provider to use. This will be used in the Gravitino Web UI to determine the authentication flow.").version("1.0.0").stringConf().checkValue(value -> {
        if (value == null) {
            return false;
        }
        for (ProviderType type : ProviderType.values()) {
            if (!type.name().equalsIgnoreCase((String)value)) continue;
            return true;
        }
        return false;
    }, "Invalid OAuth provider type. Supported values: '" + String.join((CharSequence)", ", (CharSequence[])Arrays.stream(ProviderType.values()).map(v -> v.name().toLowerCase()).toArray(String[]::new)) + "'").createWithDefault((Object)ProviderType.DEFAULT.name().toLowerCase());
    public static final ConfigEntry<String> CLIENT_ID = new ConfigBuilder("gravitino.authenticator.oauth.clientId").doc("OAuth client ID used for Web UI authentication").version("1.0.0").stringConf().create();
    public static final ConfigEntry<String> AUTHORITY = new ConfigBuilder("gravitino.authenticator.oauth.authority").doc("OAuth authority URL (authorization server) used for Web UI authentication").version("1.0.0").stringConf().create();
    public static final ConfigEntry<String> SCOPE = new ConfigBuilder("gravitino.authenticator.oauth.scope").doc("OAuth scopes (space-separated) used for Web UI authentication").version("1.0.0").stringConf().create();
    public static final ConfigEntry<String> JWKS_URI = new ConfigBuilder("gravitino.authenticator.oauth.jwksUri").doc("JWKS URI used for server-side OAuth token validation").version("1.0.0").stringConf().create();
    public static final ConfigEntry<List<String>> PRINCIPAL_FIELDS = new ConfigBuilder("gravitino.authenticator.oauth.principalFields").doc("JWT claim field(s) to use as principal identity. Comma-separated list for fallback in order (e.g., 'preferred_username,email,sub').").version("1.0.0").stringConf().toSequence().createWithDefault(Arrays.asList("sub"));
    public static final ConfigEntry<String> TOKEN_VALIDATOR_CLASS = new ConfigBuilder("gravitino.authenticator.oauth.tokenValidatorClass").doc("Fully qualified class name of the OAuth token validator implementation").version("1.0.0").stringConf().createWithDefault((Object)"org.apache.gravitino.server.authentication.StaticSignKeyValidator");
}

