/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Config;
import org.apache.gravitino.OverwriteDefaultConfig;
import org.apache.gravitino.catalog.lakehouse.iceberg.IcebergPropertiesUtils;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;

public class IcebergConfig
extends Config
implements OverwriteDefaultConfig {
    public static final String ICEBERG_CONFIG_PREFIX = "gravitino.iceberg-rest.";
    @VisibleForTesting
    public static final String ICEBERG_EXTENSION_PACKAGES = "extension-packages";
    public static final int DEFAULT_ICEBERG_REST_SERVICE_HTTP_PORT = 9001;
    public static final int DEFAULT_ICEBERG_REST_SERVICE_HTTPS_PORT = 9433;
    public static final ConfigEntry<String> CATALOG_BACKEND = new ConfigBuilder("catalog-backend").doc("Catalog backend of Gravitino Iceberg catalog").version("0.2.0").stringConf().createWithDefault((Object)"memory");
    public static final ConfigEntry<String> CATALOG_BACKEND_IMPL = new ConfigBuilder("catalog-backend-impl").doc("The fully-qualified class name of a custom catalog implementation, only worked if `catalog-backend` is `custom`").version("0.7.0").stringConf().create();
    public static final ConfigEntry<String> CATALOG_WAREHOUSE = new ConfigBuilder("warehouse").doc("Warehouse directory of catalog").version("0.2.0").stringConf().create();
    public static final ConfigEntry<String> CATALOG_URI = new ConfigBuilder("uri").doc("The uri config of the Iceberg catalog").version("0.2.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> JDBC_USER = new ConfigBuilder("jdbc-user").doc("The username of the Jdbc connection").version("0.2.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> JDBC_PASSWORD = new ConfigBuilder("jdbc-password").doc("The password of the Jdbc connection").version("0.2.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> JDBC_DRIVER = new ConfigBuilder("jdbc-driver").doc("The driver of the Jdbc connection").version("0.3.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<Boolean> JDBC_INIT_TABLES = new ConfigBuilder("jdbc-initialize").doc("Whether to initialize meta tables when create Jdbc catalog").version("0.2.0").booleanConf().createWithDefault((Object)true);
    public static final ConfigEntry<String> IO_IMPL = new ConfigBuilder("io-impl").doc("The io implementation for `FileIO` in Iceberg").version("0.6.0").stringConf().create();
    public static final ConfigEntry<String> S3_ENDPOINT = new ConfigBuilder("s3-endpoint").doc("An alternative endpoint of the S3 service, This could be used to for S3FileIO with any s3-compatible object storage service that has a different endpoint, or access a private S3 endpoint in a virtual private cloud").version("0.6.0").stringConf().create();
    public static final ConfigEntry<String> S3_REGION = new ConfigBuilder("s3-region").doc("The region of the S3 service").version("0.6.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> S3_ACCESS_KEY_ID = new ConfigBuilder("s3-access-key-id").doc("The static access key ID used to access S3 data").version("0.6.0").stringConf().create();
    public static final ConfigEntry<String> S3_SECRET_ACCESS_KEY = new ConfigBuilder("s3-secret-access-key").doc("The static secret access key used to access S3 data").version("0.6.0").stringConf().create();
    public static final ConfigEntry<Boolean> S3_PATH_STYLE_ACCESS = new ConfigBuilder("s3-path-style-access").doc("Whether to use path style access for S3").version("0.9.0").booleanConf().createWithDefault((Object)false);
    public static final ConfigEntry<String> OSS_ENDPOINT = new ConfigBuilder("oss-endpoint").doc("The endpoint of Aliyun OSS service").version("0.7.0").stringConf().create();
    public static final ConfigEntry<String> OSS_ACCESS_KEY_ID = new ConfigBuilder("oss-access-key-id").doc("The static access key ID used to access OSS data").version("0.7.0").stringConf().create();
    public static final ConfigEntry<String> OSS_ACCESS_KEY_SECRET = new ConfigBuilder("oss-secret-access-key").doc("The static access key secret used to access OSS data").version("0.7.0").stringConf().create();
    public static final ConfigEntry<String> ICEBERG_METRICS_STORE = new ConfigBuilder("metricsStore").doc("The store to save Iceberg metrics").version("0.4.0").stringConf().create();
    public static final ConfigEntry<Integer> ICEBERG_METRICS_STORE_RETAIN_DAYS = new ConfigBuilder("metricsStoreRetainDays").doc("The retain days of Iceberg metrics, the value not greater than 0 means retain forever").version("0.4.0").intConf().createWithDefault((Object)-1);
    public static final ConfigEntry<Integer> ICEBERG_METRICS_QUEUE_CAPACITY = new ConfigBuilder("metricsQueueCapacity").doc("The capacity for Iceberg metrics queues, should greater than 0").version("0.4.0").intConf().checkValue(value -> value > 0, "The value must be a positive number").createWithDefault((Object)1000);
    public static final ConfigEntry<String> CATALOG_BACKEND_NAME = new ConfigBuilder("catalog-backend-name").doc("The catalog name for Iceberg catalog backend").version("0.5.2").stringConf().create();
    public static final ConfigEntry<Long> ICEBERG_REST_CATALOG_CACHE_EVICTION_INTERVAL = new ConfigBuilder("catalog-cache-eviction-interval-ms").doc("Catalog cache eviction interval.").version("0.7.0").longConf().createWithDefault((Object)3600000L);
    public static final ConfigEntry<String> ICEBERG_REST_CATALOG_CONFIG_PROVIDER = new ConfigBuilder("catalog-config-provider").doc("Catalog provider class name, you can develop a class that implements `IcebergConfigProvider` and add the corresponding jar file to the Iceberg REST service classpath directory.").version("0.7.0").stringConf().createWithDefault((Object)"static-config-provider");
    public static final ConfigEntry<String> GRAVITINO_URI = new ConfigBuilder("gravitino-uri").doc("The uri of Gravitino server address, only worked if `catalog-provider` is `gravitino-based-provider`.").version("0.7.0").stringConf().create();
    public static final ConfigEntry<String> GRAVITINO_METALAKE = new ConfigBuilder("gravitino-metalake").doc("The metalake name that `gravitino-based-provider` used to request to Gravitino, only worked if `catalog-provider` is `gravitino-based-provider`.").version("0.7.0").stringConf().create();
    public static final ConfigEntry<List<String>> REST_API_EXTENSION_PACKAGES = new ConfigBuilder("extension-packages").doc("Comma-separated list of Iceberg REST API packages to expand").version("0.7.0").stringConf().toSequence().createWithDefault(Collections.emptyList());
    @Deprecated
    public static final ConfigEntry<String> CREDENTIAL_PROVIDER_TYPE = new ConfigBuilder("credential-provider-type").doc(String.format("Deprecated, please use %s instead, The credential provider type for Iceberg", "credential-providers")).version("0.7.0").stringConf().create();
    public static final ConfigEntry<String> TABLE_METADATA_CACHE_IMPL = new ConfigBuilder("table-metadata-cache-impl").doc("Table metadata cache implementation").version("1.1.0").stringConf().create();
    public static final ConfigEntry<Integer> TABLE_METADATA_CACHE_CAPACITY = new ConfigBuilder("table-metadata-cache-capacity").doc("Table metadata cache capacity").version("1.1.0").intConf().createWithDefault((Object)200);
    public static final ConfigEntry<Integer> TABLE_METADATA_CACHE_EXPIRE_MINUTES = new ConfigBuilder("table-metadata-cache-expire-minutes").doc("Table metadata cache expire minutes").version("1.1.0").intConf().createWithDefault((Object)60);

    public String getJdbcDriver() {
        return (String)this.get(JDBC_DRIVER);
    }

    public String getCatalogBackendName() {
        return IcebergPropertiesUtils.getCatalogBackendName((Map)this.getAllConfig());
    }

    public IcebergConfig(Map<String, String> properties) {
        super(false);
        this.loadFromMap(properties, k -> true);
    }

    public IcebergConfig() {
        super(false);
    }

    public Map<String, String> getIcebergCatalogProperties() {
        Map config = this.getAllConfig();
        Map transformedConfig = IcebergPropertiesUtils.toIcebergCatalogProperties((Map)config);
        transformedConfig.putAll(config);
        return transformedConfig;
    }

    public Map<String, String> getOverwriteDefaultConfig() {
        return ImmutableMap.of((Object)"httpPort", (Object)String.valueOf(9001), (Object)"httpsPort", (Object)String.valueOf(9433));
    }
}

