/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.paimon.storage;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Config;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;
import org.apache.gravitino.connector.PropertyEntry;

public class S3StorageConfig
extends Config {
    public static final ConfigEntry<String> PAIMON_S3_ENDPOINT_ENTRY = new ConfigBuilder("s3-endpoint").doc("The endpoint of the AWS s3").version("0.7.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> PAIMON_S3_ACCESS_KEY_ENTRY = new ConfigBuilder("s3-access-key-id").doc("The access key of the AWS s3").version("0.7.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> PAIMON_S3_SECRET_KEY_ENTRY = new ConfigBuilder("s3-secret-access-key").doc("The secret key of the AWS s3").version("0.7.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final Map<String, PropertyEntry<?>> S3_FILESYSTEM_PROPERTY_ENTRIES = new ImmutableMap.Builder().put((Object)"s3-endpoint", (Object)PropertyEntry.stringOptionalPropertyEntry((String)"s3-endpoint", (String)"The endpoint of the AWS s3", (boolean)false, null, (boolean)false)).put((Object)"s3-access-key-id", (Object)PropertyEntry.stringOptionalPropertyEntry((String)"s3-access-key-id", (String)"The access key of the AWS s3", (boolean)false, null, (boolean)false)).put((Object)"s3-secret-access-key", (Object)PropertyEntry.stringOptionalPropertyEntry((String)"s3-secret-access-key", (String)"The secret key of the AWS s3", (boolean)false, null, (boolean)false)).build();

    public S3StorageConfig(Map<String, String> properties) {
        super(false);
        this.loadFromMap(properties, k -> true);
    }

    public String getS3Endpoint() {
        return (String)this.get(PAIMON_S3_ENDPOINT_ENTRY);
    }

    public String getS3AccessKey() {
        return (String)this.get(PAIMON_S3_ACCESS_KEY_ENTRY);
    }

    public String getS3SecretKey() {
        return (String)this.get(PAIMON_S3_SECRET_KEY_ENTRY);
    }
}

