/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.log;

import java.util.Map;
import org.casbin.jcasbin.log.Logger;

public class DefaultLogger
implements Logger {
    private boolean enabled;

    @Override
    public void enableLog(boolean enable) {
        this.enabled = enable;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void logModel(String[][] model) {
        if (!this.enabled) {
            return;
        }
        StringBuilder str = new StringBuilder("Model: ");
        for (CharSequence[] charSequenceArray : model) {
            str.append(String.format("%s\n", String.join((CharSequence)", ", charSequenceArray)));
        }
        System.out.println(str.toString());
    }

    @Override
    public void logEnforce(String matcher, Object[] request, boolean result, String[][] explains) {
        int i;
        if (!this.enabled) {
            return;
        }
        StringBuilder reqStr = new StringBuilder("Request: ");
        for (i = 0; i < request.length; ++i) {
            reqStr.append(i != request.length - 1 ? String.format("%s, ", request[i]) : request[i]);
        }
        reqStr.append(String.format(" ---> %b\n", result));
        reqStr.append("Hit Policy: ");
        for (i = 0; i < explains.length; ++i) {
            reqStr.append(i != explains.length - 1 ? String.format("%s, ", String.join((CharSequence)", ", explains[i])) : String.join((CharSequence)", ", explains[i]));
        }
        System.out.println(reqStr.toString());
    }

    @Override
    public void logPolicy(Map<String, String[][]> policy) {
        if (!this.enabled) {
            return;
        }
        StringBuilder str = new StringBuilder("Policy: ");
        for (Map.Entry<String, String[][]> entry : policy.entrySet()) {
            str.append(String.format("%s : %s\n", entry.getKey(), this.arrayToString(entry.getValue())));
        }
        System.out.println(str.toString());
    }

    private String arrayToString(String[][] array) {
        StringBuilder result = new StringBuilder("[");
        for (int i = 0; i < array.length; ++i) {
            result.append("[").append(String.join((CharSequence)", ", array[i])).append("]");
            if (i >= array.length - 1) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }

    @Override
    public void logRole(String[] roles) {
        if (!this.enabled) {
            return;
        }
        System.out.println("Roles: " + String.join((CharSequence)"\n", roles));
    }

    @Override
    public void logError(Throwable err, String ... msg) {
        if (!this.enabled) {
            return;
        }
        System.out.println(String.join((CharSequence)" ", msg) + " " + err.getMessage());
    }
}

