/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cache;

import com.github.benmanes.caffeine.cache.Weigher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.gravitino.Entity;
import org.apache.gravitino.cache.EntityCacheKey;
import org.checkerframework.checker.index.qual.NonNegative;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityCacheWeigher
implements Weigher<EntityCacheKey, List<Entity>> {
    public static final int METALAKE_WEIGHT = 0;
    public static final int CATALOG_WEIGHT = 0;
    public static final int SCHEMA_WEIGHT = 100;
    public static final int OTHER_WEIGHT = 200;
    public static final int TAG_WEIGHT = 500;
    public static final int POLICY_WEIGHT = 500;
    private static final Logger LOG = LoggerFactory.getLogger((String)EntityCacheWeigher.class.getName());
    private static final EntityCacheWeigher INSTANCE = new EntityCacheWeigher();
    private static final Map<Entity.EntityType, Integer> ENTITY_WEIGHTS = ImmutableMap.of((Object)((Object)Entity.EntityType.METALAKE), (Object)0, (Object)((Object)Entity.EntityType.CATALOG), (Object)0, (Object)((Object)Entity.EntityType.SCHEMA), (Object)100, (Object)((Object)Entity.EntityType.TAG), (Object)500, (Object)((Object)Entity.EntityType.POLICY), (Object)500);
    private static final long MAX_WEIGHT = 24200000L;

    @VisibleForTesting
    protected EntityCacheWeigher() {
    }

    public static long getMaxWeight() {
        return 24200000L;
    }

    public static EntityCacheWeigher getInstance() {
        return INSTANCE;
    }

    public @NonNegative int weigh(@NonNull EntityCacheKey storeEntityCacheKey, @NonNull List<Entity> entities) {
        if (storeEntityCacheKey == null) {
            throw new NullPointerException("storeEntityCacheKey is marked non-null but is null");
        }
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        int weight = 0;
        for (Entity entity : entities) {
            weight += this.calculateWeight(entity.type());
        }
        if ((long)weight > EntityCacheWeigher.getMaxWeight()) {
            LOG.warn("Entity group exceeds max weight: {}", (Object)weight);
        }
        return weight;
    }

    private int calculateWeight(Entity.EntityType entityType) {
        Preconditions.checkArgument((entityType != null ? 1 : 0) != 0, (Object)"entityType cannot be null");
        return ENTITY_WEIGHTS.getOrDefault((Object)entityType, 200);
    }
}

